/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control;

import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AwsSyncClientBuilder;
import com.amazonaws.services.s3control.AWSS3Control;
import com.amazonaws.services.s3control.AWSS3ControlClient;
import com.amazonaws.services.s3control.S3ControlClientOptions;

@NotThreadSafe
public final class AWSS3ControlClientBuilder
extends AwsSyncClientBuilder<AWSS3ControlClientBuilder, AWSS3Control> {
    private static final ClientConfigurationFactory CLIENT_CONFIG_FACTORY = new ClientConfigurationFactory();

    public static AWSS3ControlClientBuilder standard() {
        return new AWSS3ControlClientBuilder();
    }

    public static AWSS3Control defaultClient() {
        return (AWSS3Control)AWSS3ControlClientBuilder.standard().build();
    }

    private AWSS3ControlClientBuilder() {
        super(CLIENT_CONFIG_FACTORY);
    }

    public Boolean isDualstackEnabled() {
        return (Boolean)super.getAdvancedConfig(S3ControlClientOptions.DUALSTACK_ENABLED);
    }

    public AWSS3ControlClientBuilder enableDualstack() {
        return this.withDualstackEnabled(true);
    }

    public void setDualstackEnabled(Boolean dualstackEnabled) {
        super.putAdvancedConfig(S3ControlClientOptions.DUALSTACK_ENABLED, (Object)dualstackEnabled);
    }

    public AWSS3ControlClientBuilder withDualstackEnabled(Boolean dualstackEnabled) {
        this.setDualstackEnabled(dualstackEnabled);
        return this;
    }

    public Boolean isFipsEnabled() {
        return (Boolean)super.getAdvancedConfig(S3ControlClientOptions.FIPS_ENABLED);
    }

    public AWSS3ControlClientBuilder enableFips() {
        return this.withFipsEnabled(true);
    }

    public void setFipsEnabled(Boolean fipsEnabled) {
        super.putAdvancedConfig(S3ControlClientOptions.FIPS_ENABLED, (Object)fipsEnabled);
    }

    public AWSS3ControlClientBuilder withFipsEnabled(Boolean fipsEnabled) {
        this.setFipsEnabled(fipsEnabled);
        return this;
    }

    protected AWSS3Control build(AwsSyncClientParams params) {
        return new AWSS3ControlClient(params);
    }
}

