/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.DeleteAccessPointRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class DeleteAccessPointRequestMarshaller
implements Marshaller<Request<DeleteAccessPointRequest>, DeleteAccessPointRequest> {
    public Request<DeleteAccessPointRequest> marshall(DeleteAccessPointRequest deleteAccessPointRequest) {
        if (deleteAccessPointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteAccessPointRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (deleteAccessPointRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)deleteAccessPointRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/accesspoint/{name}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "name", deleteAccessPointRequest.getName());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

