/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.JobOperation;
import com.amazonaws.services.s3control.model.transform.LambdaInvokeOperationStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.S3CopyObjectOperationStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.S3InitiateRestoreObjectOperationStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.S3SetObjectAclOperationStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.S3SetObjectTaggingOperationStaxUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class JobOperationStaxUnmarshaller
implements Unmarshaller<JobOperation, StaxUnmarshallerContext> {
    private static JobOperationStaxUnmarshaller instance;

    public JobOperation unmarshall(StaxUnmarshallerContext context) throws Exception {
        JobOperation jobOperation = new JobOperation();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return jobOperation;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("LambdaInvoke", targetDepth)) {
                    jobOperation.setLambdaInvoke(LambdaInvokeOperationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("S3PutObjectCopy", targetDepth)) {
                    jobOperation.setS3PutObjectCopy(S3CopyObjectOperationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("S3PutObjectAcl", targetDepth)) {
                    jobOperation.setS3PutObjectAcl(S3SetObjectAclOperationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("S3PutObjectTagging", targetDepth)) {
                    jobOperation.setS3PutObjectTagging(S3SetObjectTaggingOperationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("S3InitiateRestoreObject", targetDepth)) continue;
                jobOperation.setS3InitiateRestoreObject(S3InitiateRestoreObjectOperationStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return jobOperation;
    }

    public static JobOperationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new JobOperationStaxUnmarshaller();
        }
        return instance;
    }
}

