/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model;

import com.amazonaws.services.s3control.model.S3Grantee;
import com.amazonaws.services.s3control.model.S3Permission;
import java.io.Serializable;

public class S3Grant
implements Serializable,
Cloneable {
    private S3Grantee grantee;
    private String permission;

    public void setGrantee(S3Grantee grantee) {
        this.grantee = grantee;
    }

    public S3Grantee getGrantee() {
        return this.grantee;
    }

    public S3Grant withGrantee(S3Grantee grantee) {
        this.setGrantee(grantee);
        return this;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public String getPermission() {
        return this.permission;
    }

    public S3Grant withPermission(String permission) {
        this.setPermission(permission);
        return this;
    }

    public S3Grant withPermission(S3Permission permission) {
        this.permission = permission.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGrantee() != null) {
            sb.append("Grantee: ").append(this.getGrantee()).append(",");
        }
        if (this.getPermission() != null) {
            sb.append("Permission: ").append(this.getPermission());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Grant)) {
            return false;
        }
        S3Grant other = (S3Grant)obj;
        if (other.getGrantee() == null ^ this.getGrantee() == null) {
            return false;
        }
        if (other.getGrantee() != null && !other.getGrantee().equals(this.getGrantee())) {
            return false;
        }
        if (other.getPermission() == null ^ this.getPermission() == null) {
            return false;
        }
        return other.getPermission() == null || other.getPermission().equals(this.getPermission());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGrantee() == null ? 0 : this.getGrantee().hashCode());
        hashCode = 31 * hashCode + (this.getPermission() == null ? 0 : this.getPermission().hashCode());
        return hashCode;
    }

    public S3Grant clone() {
        try {
            return (S3Grant)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

