/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.arn.Arn;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.services.s3.S3AccessPointResource;
import com.amazonaws.services.s3.S3Resource;
import com.amazonaws.services.s3control.AWSS3Control;
import com.amazonaws.services.s3control.AWSS3ControlClientBuilder;
import com.amazonaws.services.s3control.S3ArnableField;
import com.amazonaws.services.s3control.S3ControlHandlerContextKey;
import com.amazonaws.services.s3control.S3ControlResponseMetadata;
import com.amazonaws.services.s3control.internal.S3ControlArnConverter;
import com.amazonaws.services.s3control.internal.S3ControlBucketResource;
import com.amazonaws.services.s3control.internal.S3ControlStaxResponseHandler;
import com.amazonaws.services.s3control.model.AWSS3ControlException;
import com.amazonaws.services.s3control.model.CreateAccessPointForObjectLambdaRequest;
import com.amazonaws.services.s3control.model.CreateAccessPointForObjectLambdaResult;
import com.amazonaws.services.s3control.model.CreateAccessPointRequest;
import com.amazonaws.services.s3control.model.CreateAccessPointResult;
import com.amazonaws.services.s3control.model.CreateBucketRequest;
import com.amazonaws.services.s3control.model.CreateBucketResult;
import com.amazonaws.services.s3control.model.CreateJobRequest;
import com.amazonaws.services.s3control.model.CreateJobResult;
import com.amazonaws.services.s3control.model.DeleteAccessPointForObjectLambdaRequest;
import com.amazonaws.services.s3control.model.DeleteAccessPointForObjectLambdaResult;
import com.amazonaws.services.s3control.model.DeleteAccessPointPolicyForObjectLambdaRequest;
import com.amazonaws.services.s3control.model.DeleteAccessPointPolicyForObjectLambdaResult;
import com.amazonaws.services.s3control.model.DeleteAccessPointPolicyRequest;
import com.amazonaws.services.s3control.model.DeleteAccessPointPolicyResult;
import com.amazonaws.services.s3control.model.DeleteAccessPointRequest;
import com.amazonaws.services.s3control.model.DeleteAccessPointResult;
import com.amazonaws.services.s3control.model.DeleteBucketLifecycleConfigurationRequest;
import com.amazonaws.services.s3control.model.DeleteBucketLifecycleConfigurationResult;
import com.amazonaws.services.s3control.model.DeleteBucketPolicyRequest;
import com.amazonaws.services.s3control.model.DeleteBucketPolicyResult;
import com.amazonaws.services.s3control.model.DeleteBucketRequest;
import com.amazonaws.services.s3control.model.DeleteBucketResult;
import com.amazonaws.services.s3control.model.DeleteBucketTaggingRequest;
import com.amazonaws.services.s3control.model.DeleteBucketTaggingResult;
import com.amazonaws.services.s3control.model.DeleteJobTaggingRequest;
import com.amazonaws.services.s3control.model.DeleteJobTaggingResult;
import com.amazonaws.services.s3control.model.DeletePublicAccessBlockRequest;
import com.amazonaws.services.s3control.model.DeletePublicAccessBlockResult;
import com.amazonaws.services.s3control.model.DeleteStorageLensConfigurationRequest;
import com.amazonaws.services.s3control.model.DeleteStorageLensConfigurationResult;
import com.amazonaws.services.s3control.model.DeleteStorageLensConfigurationTaggingRequest;
import com.amazonaws.services.s3control.model.DeleteStorageLensConfigurationTaggingResult;
import com.amazonaws.services.s3control.model.DescribeJobRequest;
import com.amazonaws.services.s3control.model.DescribeJobResult;
import com.amazonaws.services.s3control.model.GetAccessPointConfigurationForObjectLambdaRequest;
import com.amazonaws.services.s3control.model.GetAccessPointConfigurationForObjectLambdaResult;
import com.amazonaws.services.s3control.model.GetAccessPointForObjectLambdaRequest;
import com.amazonaws.services.s3control.model.GetAccessPointForObjectLambdaResult;
import com.amazonaws.services.s3control.model.GetAccessPointPolicyForObjectLambdaRequest;
import com.amazonaws.services.s3control.model.GetAccessPointPolicyForObjectLambdaResult;
import com.amazonaws.services.s3control.model.GetAccessPointPolicyRequest;
import com.amazonaws.services.s3control.model.GetAccessPointPolicyResult;
import com.amazonaws.services.s3control.model.GetAccessPointPolicyStatusForObjectLambdaRequest;
import com.amazonaws.services.s3control.model.GetAccessPointPolicyStatusForObjectLambdaResult;
import com.amazonaws.services.s3control.model.GetAccessPointPolicyStatusRequest;
import com.amazonaws.services.s3control.model.GetAccessPointPolicyStatusResult;
import com.amazonaws.services.s3control.model.GetAccessPointRequest;
import com.amazonaws.services.s3control.model.GetAccessPointResult;
import com.amazonaws.services.s3control.model.GetBucketLifecycleConfigurationRequest;
import com.amazonaws.services.s3control.model.GetBucketLifecycleConfigurationResult;
import com.amazonaws.services.s3control.model.GetBucketPolicyRequest;
import com.amazonaws.services.s3control.model.GetBucketPolicyResult;
import com.amazonaws.services.s3control.model.GetBucketRequest;
import com.amazonaws.services.s3control.model.GetBucketResult;
import com.amazonaws.services.s3control.model.GetBucketTaggingRequest;
import com.amazonaws.services.s3control.model.GetBucketTaggingResult;
import com.amazonaws.services.s3control.model.GetJobTaggingRequest;
import com.amazonaws.services.s3control.model.GetJobTaggingResult;
import com.amazonaws.services.s3control.model.GetPublicAccessBlockRequest;
import com.amazonaws.services.s3control.model.GetPublicAccessBlockResult;
import com.amazonaws.services.s3control.model.GetStorageLensConfigurationRequest;
import com.amazonaws.services.s3control.model.GetStorageLensConfigurationResult;
import com.amazonaws.services.s3control.model.GetStorageLensConfigurationTaggingRequest;
import com.amazonaws.services.s3control.model.GetStorageLensConfigurationTaggingResult;
import com.amazonaws.services.s3control.model.ListAccessPointsForObjectLambdaRequest;
import com.amazonaws.services.s3control.model.ListAccessPointsForObjectLambdaResult;
import com.amazonaws.services.s3control.model.ListAccessPointsRequest;
import com.amazonaws.services.s3control.model.ListAccessPointsResult;
import com.amazonaws.services.s3control.model.ListJobsRequest;
import com.amazonaws.services.s3control.model.ListJobsResult;
import com.amazonaws.services.s3control.model.ListRegionalBucketsRequest;
import com.amazonaws.services.s3control.model.ListRegionalBucketsResult;
import com.amazonaws.services.s3control.model.ListStorageLensConfigurationsRequest;
import com.amazonaws.services.s3control.model.ListStorageLensConfigurationsResult;
import com.amazonaws.services.s3control.model.PutAccessPointConfigurationForObjectLambdaRequest;
import com.amazonaws.services.s3control.model.PutAccessPointConfigurationForObjectLambdaResult;
import com.amazonaws.services.s3control.model.PutAccessPointPolicyForObjectLambdaRequest;
import com.amazonaws.services.s3control.model.PutAccessPointPolicyForObjectLambdaResult;
import com.amazonaws.services.s3control.model.PutAccessPointPolicyRequest;
import com.amazonaws.services.s3control.model.PutAccessPointPolicyResult;
import com.amazonaws.services.s3control.model.PutBucketLifecycleConfigurationRequest;
import com.amazonaws.services.s3control.model.PutBucketLifecycleConfigurationResult;
import com.amazonaws.services.s3control.model.PutBucketPolicyRequest;
import com.amazonaws.services.s3control.model.PutBucketPolicyResult;
import com.amazonaws.services.s3control.model.PutBucketTaggingRequest;
import com.amazonaws.services.s3control.model.PutBucketTaggingResult;
import com.amazonaws.services.s3control.model.PutJobTaggingRequest;
import com.amazonaws.services.s3control.model.PutJobTaggingResult;
import com.amazonaws.services.s3control.model.PutPublicAccessBlockRequest;
import com.amazonaws.services.s3control.model.PutPublicAccessBlockResult;
import com.amazonaws.services.s3control.model.PutStorageLensConfigurationRequest;
import com.amazonaws.services.s3control.model.PutStorageLensConfigurationResult;
import com.amazonaws.services.s3control.model.PutStorageLensConfigurationTaggingRequest;
import com.amazonaws.services.s3control.model.PutStorageLensConfigurationTaggingResult;
import com.amazonaws.services.s3control.model.UpdateJobPriorityRequest;
import com.amazonaws.services.s3control.model.UpdateJobPriorityResult;
import com.amazonaws.services.s3control.model.UpdateJobStatusRequest;
import com.amazonaws.services.s3control.model.UpdateJobStatusResult;
import com.amazonaws.services.s3control.model.transform.BadRequestExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.BucketAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.BucketAlreadyOwnedByYouExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.CreateAccessPointForObjectLambdaRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.CreateAccessPointForObjectLambdaResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.CreateAccessPointRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.CreateAccessPointResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.CreateBucketRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.CreateBucketResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.CreateJobRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.CreateJobResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteAccessPointForObjectLambdaRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteAccessPointForObjectLambdaResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteAccessPointPolicyForObjectLambdaRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteAccessPointPolicyForObjectLambdaResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteAccessPointPolicyRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteAccessPointPolicyResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteAccessPointRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteAccessPointResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteBucketLifecycleConfigurationRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteBucketLifecycleConfigurationResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteBucketPolicyRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteBucketPolicyResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteBucketRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteBucketResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteBucketTaggingRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteBucketTaggingResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteJobTaggingRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteJobTaggingResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.DeletePublicAccessBlockRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.DeletePublicAccessBlockResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteStorageLensConfigurationRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteStorageLensConfigurationResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteStorageLensConfigurationTaggingRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.DeleteStorageLensConfigurationTaggingResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.DescribeJobRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.DescribeJobResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.GetAccessPointConfigurationForObjectLambdaRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.GetAccessPointConfigurationForObjectLambdaResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.GetAccessPointForObjectLambdaRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.GetAccessPointForObjectLambdaResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.GetAccessPointPolicyForObjectLambdaRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.GetAccessPointPolicyForObjectLambdaResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.GetAccessPointPolicyRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.GetAccessPointPolicyResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.GetAccessPointPolicyStatusForObjectLambdaRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.GetAccessPointPolicyStatusForObjectLambdaResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.GetAccessPointPolicyStatusRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.GetAccessPointPolicyStatusResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.GetAccessPointRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.GetAccessPointResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.GetBucketLifecycleConfigurationRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.GetBucketLifecycleConfigurationResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.GetBucketPolicyRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.GetBucketPolicyResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.GetBucketRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.GetBucketResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.GetBucketTaggingRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.GetBucketTaggingResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.GetJobTaggingRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.GetJobTaggingResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.GetPublicAccessBlockRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.GetPublicAccessBlockResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.GetStorageLensConfigurationRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.GetStorageLensConfigurationResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.GetStorageLensConfigurationTaggingRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.GetStorageLensConfigurationTaggingResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.IdempotencyExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.InternalServiceExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.InvalidRequestExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.JobStatusExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.ListAccessPointsForObjectLambdaRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.ListAccessPointsForObjectLambdaResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.ListAccessPointsRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.ListAccessPointsResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.ListJobsRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.ListJobsResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.ListRegionalBucketsRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.ListRegionalBucketsResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.ListStorageLensConfigurationsRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.ListStorageLensConfigurationsResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.NoSuchPublicAccessBlockConfigurationExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.NotFoundExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.PutAccessPointConfigurationForObjectLambdaRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.PutAccessPointConfigurationForObjectLambdaResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.PutAccessPointPolicyForObjectLambdaRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.PutAccessPointPolicyForObjectLambdaResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.PutAccessPointPolicyRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.PutAccessPointPolicyResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.PutBucketLifecycleConfigurationRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.PutBucketLifecycleConfigurationResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.PutBucketPolicyRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.PutBucketPolicyResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.PutBucketTaggingRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.PutBucketTaggingResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.PutJobTaggingRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.PutJobTaggingResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.PutPublicAccessBlockRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.PutPublicAccessBlockResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.PutStorageLensConfigurationRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.PutStorageLensConfigurationResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.PutStorageLensConfigurationTaggingRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.PutStorageLensConfigurationTaggingResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.TooManyRequestsExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.TooManyTagsExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.UpdateJobPriorityRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.UpdateJobPriorityResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.UpdateJobStatusRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.UpdateJobStatusResultStaxUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import com.amazonaws.util.HostnameValidator;
import com.amazonaws.util.UriResourcePathUtils;
import com.amazonaws.util.ValidationUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

@ThreadSafe
public class AWSS3ControlClient
extends AmazonWebServiceClient
implements AWSS3Control {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSS3Control.class);
    private static final String DEFAULT_SIGNING_NAME = "s3";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();

    public static AWSS3ControlClientBuilder builder() {
        return AWSS3ControlClientBuilder.standard();
    }

    AWSS3ControlClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSS3ControlClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidRequestExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidNextTokenExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new JobStatusExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new NoSuchPublicAccessBlockConfigurationExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InternalServiceExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new BucketAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new NotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new TooManyTagsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new IdempotencyExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new BucketAlreadyOwnedByYouExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new TooManyRequestsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new BadRequestExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new StandardErrorUnmarshaller(AWSS3ControlException.class));
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("s3-control");
        this.setEndpoint("s3-control.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/s3control/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/s3control/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateAccessPointResult createAccessPoint(CreateAccessPointRequest request) {
        request = (CreateAccessPointRequest)this.beforeClientExecution(request);
        return this.executeCreateAccessPoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateAccessPointResult executeCreateAccessPoint(CreateAccessPointRequest createAccessPointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAccessPointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAccessPointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                String bucket = createAccessPointRequest.getBucket();
                Arn arn = null;
                if (bucket != null && bucket.startsWith("arn:")) {
                    arn = Arn.fromString((String)bucket);
                    S3Resource awsResource = S3ControlArnConverter.getInstance().convertArn(arn);
                    if (!(awsResource instanceof S3ControlBucketResource)) {
                        throw new IllegalArgumentException("Unsupported ARN type: " + awsResource.getClass() + ". Expected com.amazonaws.services.s3control.internal.S3ControlBucketResource.");
                    }
                    S3ControlBucketResource resource = (S3ControlBucketResource)awsResource;
                    createAccessPointRequest = createAccessPointRequest.clone();
                    createAccessPointRequest.setBucket(resource.getBucketName());
                    String accountId = createAccessPointRequest.getAccountId();
                    String accountIdInArn = resource.getAccountId();
                    if (accountId != null && !accountId.equals(accountIdInArn)) {
                        throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                    }
                    createAccessPointRequest.setAccountId(accountIdInArn);
                }
                request = new CreateAccessPointRequestMarshaller().marshall((CreateAccessPointRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAccessPointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateAccessPoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
                request.addHandlerContext(S3ControlHandlerContextKey.S3_ARNABLE_FIELD, (Object)new S3ArnableField().withArn(arn));
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)createAccessPointRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)createAccessPointRequest.getAccountId(), (String)"AccountId", (String)"createAccessPointRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", createAccessPointRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<CreateAccessPointResult> responseHandler = new S3ControlStaxResponseHandler<CreateAccessPointResult>(new CreateAccessPointResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            CreateAccessPointResult createAccessPointResult = (CreateAccessPointResult)response.getAwsResponse();
            return createAccessPointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateAccessPointForObjectLambdaResult createAccessPointForObjectLambda(CreateAccessPointForObjectLambdaRequest request) {
        request = (CreateAccessPointForObjectLambdaRequest)this.beforeClientExecution(request);
        return this.executeCreateAccessPointForObjectLambda(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateAccessPointForObjectLambdaResult executeCreateAccessPointForObjectLambda(CreateAccessPointForObjectLambdaRequest createAccessPointForObjectLambdaRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAccessPointForObjectLambdaRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAccessPointForObjectLambdaRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAccessPointForObjectLambdaRequestMarshaller().marshall((CreateAccessPointForObjectLambdaRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAccessPointForObjectLambdaRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateAccessPointForObjectLambda");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)createAccessPointForObjectLambdaRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)createAccessPointForObjectLambdaRequest.getAccountId(), (String)"AccountId", (String)"createAccessPointForObjectLambdaRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", createAccessPointForObjectLambdaRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<CreateAccessPointForObjectLambdaResult> responseHandler = new S3ControlStaxResponseHandler<CreateAccessPointForObjectLambdaResult>(new CreateAccessPointForObjectLambdaResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            CreateAccessPointForObjectLambdaResult createAccessPointForObjectLambdaResult = (CreateAccessPointForObjectLambdaResult)response.getAwsResponse();
            return createAccessPointForObjectLambdaResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateBucketResult createBucket(CreateBucketRequest request) {
        request = (CreateBucketRequest)this.beforeClientExecution(request);
        return this.executeCreateBucket(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateBucketResult executeCreateBucket(CreateBucketRequest createBucketRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createBucketRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateBucketRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateBucketRequestMarshaller().marshall((CreateBucketRequest)super.beforeMarshalling((AmazonWebServiceRequest)createBucketRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateBucket");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            S3ControlStaxResponseHandler<CreateBucketResult> responseHandler = new S3ControlStaxResponseHandler<CreateBucketResult>(new CreateBucketResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateBucketResult createBucketResult = (CreateBucketResult)response.getAwsResponse();
            return createBucketResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateJobResult createJob(CreateJobRequest request) {
        request = (CreateJobRequest)this.beforeClientExecution(request);
        return this.executeCreateJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateJobResult executeCreateJob(CreateJobRequest createJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateJobRequestMarshaller().marshall((CreateJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)createJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)createJobRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)createJobRequest.getAccountId(), (String)"AccountId", (String)"createJobRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", createJobRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<CreateJobResult> responseHandler = new S3ControlStaxResponseHandler<CreateJobResult>(new CreateJobResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            CreateJobResult createJobResult = (CreateJobResult)response.getAwsResponse();
            return createJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAccessPointResult deleteAccessPoint(DeleteAccessPointRequest request) {
        request = (DeleteAccessPointRequest)this.beforeClientExecution(request);
        return this.executeDeleteAccessPoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAccessPointResult executeDeleteAccessPoint(DeleteAccessPointRequest deleteAccessPointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAccessPointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAccessPointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                String name = deleteAccessPointRequest.getName();
                Arn arn = null;
                if (name != null && name.startsWith("arn:")) {
                    arn = Arn.fromString((String)name);
                    S3Resource awsResource = S3ControlArnConverter.getInstance().convertArn(arn);
                    if (!(awsResource instanceof S3AccessPointResource)) {
                        throw new IllegalArgumentException("Unsupported ARN type: " + awsResource.getClass() + ". Expected com.amazonaws.services.s3.S3AccessPointResource.");
                    }
                    S3AccessPointResource resource = (S3AccessPointResource)awsResource;
                    deleteAccessPointRequest = deleteAccessPointRequest.clone();
                    deleteAccessPointRequest.setName(resource.getAccessPointName());
                    String accountId = deleteAccessPointRequest.getAccountId();
                    String accountIdInArn = resource.getAccountId();
                    if (accountId != null && !accountId.equals(accountIdInArn)) {
                        throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                    }
                    deleteAccessPointRequest.setAccountId(accountIdInArn);
                }
                request = new DeleteAccessPointRequestMarshaller().marshall((DeleteAccessPointRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAccessPointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAccessPoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
                request.addHandlerContext(S3ControlHandlerContextKey.S3_ARNABLE_FIELD, (Object)new S3ArnableField().withArn(arn));
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)deleteAccessPointRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)deleteAccessPointRequest.getAccountId(), (String)"AccountId", (String)"deleteAccessPointRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", deleteAccessPointRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<DeleteAccessPointResult> responseHandler = new S3ControlStaxResponseHandler<DeleteAccessPointResult>(new DeleteAccessPointResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            DeleteAccessPointResult deleteAccessPointResult = (DeleteAccessPointResult)response.getAwsResponse();
            return deleteAccessPointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAccessPointForObjectLambdaResult deleteAccessPointForObjectLambda(DeleteAccessPointForObjectLambdaRequest request) {
        request = (DeleteAccessPointForObjectLambdaRequest)this.beforeClientExecution(request);
        return this.executeDeleteAccessPointForObjectLambda(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAccessPointForObjectLambdaResult executeDeleteAccessPointForObjectLambda(DeleteAccessPointForObjectLambdaRequest deleteAccessPointForObjectLambdaRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAccessPointForObjectLambdaRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAccessPointForObjectLambdaRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAccessPointForObjectLambdaRequestMarshaller().marshall((DeleteAccessPointForObjectLambdaRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAccessPointForObjectLambdaRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAccessPointForObjectLambda");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)deleteAccessPointForObjectLambdaRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)deleteAccessPointForObjectLambdaRequest.getAccountId(), (String)"AccountId", (String)"deleteAccessPointForObjectLambdaRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", deleteAccessPointForObjectLambdaRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<DeleteAccessPointForObjectLambdaResult> responseHandler = new S3ControlStaxResponseHandler<DeleteAccessPointForObjectLambdaResult>(new DeleteAccessPointForObjectLambdaResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            DeleteAccessPointForObjectLambdaResult deleteAccessPointForObjectLambdaResult = (DeleteAccessPointForObjectLambdaResult)response.getAwsResponse();
            return deleteAccessPointForObjectLambdaResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAccessPointPolicyResult deleteAccessPointPolicy(DeleteAccessPointPolicyRequest request) {
        request = (DeleteAccessPointPolicyRequest)this.beforeClientExecution(request);
        return this.executeDeleteAccessPointPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAccessPointPolicyResult executeDeleteAccessPointPolicy(DeleteAccessPointPolicyRequest deleteAccessPointPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAccessPointPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAccessPointPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                String name = deleteAccessPointPolicyRequest.getName();
                Arn arn = null;
                if (name != null && name.startsWith("arn:")) {
                    arn = Arn.fromString((String)name);
                    S3Resource awsResource = S3ControlArnConverter.getInstance().convertArn(arn);
                    if (!(awsResource instanceof S3AccessPointResource)) {
                        throw new IllegalArgumentException("Unsupported ARN type: " + awsResource.getClass() + ". Expected com.amazonaws.services.s3.S3AccessPointResource.");
                    }
                    S3AccessPointResource resource = (S3AccessPointResource)awsResource;
                    deleteAccessPointPolicyRequest = deleteAccessPointPolicyRequest.clone();
                    deleteAccessPointPolicyRequest.setName(resource.getAccessPointName());
                    String accountId = deleteAccessPointPolicyRequest.getAccountId();
                    String accountIdInArn = resource.getAccountId();
                    if (accountId != null && !accountId.equals(accountIdInArn)) {
                        throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                    }
                    deleteAccessPointPolicyRequest.setAccountId(accountIdInArn);
                }
                request = new DeleteAccessPointPolicyRequestMarshaller().marshall((DeleteAccessPointPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAccessPointPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAccessPointPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
                request.addHandlerContext(S3ControlHandlerContextKey.S3_ARNABLE_FIELD, (Object)new S3ArnableField().withArn(arn));
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)deleteAccessPointPolicyRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)deleteAccessPointPolicyRequest.getAccountId(), (String)"AccountId", (String)"deleteAccessPointPolicyRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", deleteAccessPointPolicyRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<DeleteAccessPointPolicyResult> responseHandler = new S3ControlStaxResponseHandler<DeleteAccessPointPolicyResult>(new DeleteAccessPointPolicyResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            DeleteAccessPointPolicyResult deleteAccessPointPolicyResult = (DeleteAccessPointPolicyResult)response.getAwsResponse();
            return deleteAccessPointPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAccessPointPolicyForObjectLambdaResult deleteAccessPointPolicyForObjectLambda(DeleteAccessPointPolicyForObjectLambdaRequest request) {
        request = (DeleteAccessPointPolicyForObjectLambdaRequest)this.beforeClientExecution(request);
        return this.executeDeleteAccessPointPolicyForObjectLambda(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAccessPointPolicyForObjectLambdaResult executeDeleteAccessPointPolicyForObjectLambda(DeleteAccessPointPolicyForObjectLambdaRequest deleteAccessPointPolicyForObjectLambdaRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAccessPointPolicyForObjectLambdaRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAccessPointPolicyForObjectLambdaRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAccessPointPolicyForObjectLambdaRequestMarshaller().marshall((DeleteAccessPointPolicyForObjectLambdaRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAccessPointPolicyForObjectLambdaRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAccessPointPolicyForObjectLambda");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)deleteAccessPointPolicyForObjectLambdaRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)deleteAccessPointPolicyForObjectLambdaRequest.getAccountId(), (String)"AccountId", (String)"deleteAccessPointPolicyForObjectLambdaRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", deleteAccessPointPolicyForObjectLambdaRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<DeleteAccessPointPolicyForObjectLambdaResult> responseHandler = new S3ControlStaxResponseHandler<DeleteAccessPointPolicyForObjectLambdaResult>(new DeleteAccessPointPolicyForObjectLambdaResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            DeleteAccessPointPolicyForObjectLambdaResult deleteAccessPointPolicyForObjectLambdaResult = (DeleteAccessPointPolicyForObjectLambdaResult)response.getAwsResponse();
            return deleteAccessPointPolicyForObjectLambdaResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteBucketResult deleteBucket(DeleteBucketRequest request) {
        request = (DeleteBucketRequest)this.beforeClientExecution(request);
        return this.executeDeleteBucket(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteBucketResult executeDeleteBucket(DeleteBucketRequest deleteBucketRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteBucketRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteBucketRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                String bucket = deleteBucketRequest.getBucket();
                Arn arn = null;
                if (bucket != null && bucket.startsWith("arn:")) {
                    arn = Arn.fromString((String)bucket);
                    S3Resource awsResource = S3ControlArnConverter.getInstance().convertArn(arn);
                    if (!(awsResource instanceof S3ControlBucketResource)) {
                        throw new IllegalArgumentException("Unsupported ARN type: " + awsResource.getClass() + ". Expected com.amazonaws.services.s3control.internal.S3ControlBucketResource.");
                    }
                    S3ControlBucketResource resource = (S3ControlBucketResource)awsResource;
                    deleteBucketRequest = deleteBucketRequest.clone();
                    deleteBucketRequest.setBucket(resource.getBucketName());
                    String accountId = deleteBucketRequest.getAccountId();
                    String accountIdInArn = resource.getAccountId();
                    if (accountId != null && !accountId.equals(accountIdInArn)) {
                        throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                    }
                    deleteBucketRequest.setAccountId(accountIdInArn);
                }
                request = new DeleteBucketRequestMarshaller().marshall((DeleteBucketRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteBucketRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteBucket");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
                request.addHandlerContext(S3ControlHandlerContextKey.S3_ARNABLE_FIELD, (Object)new S3ArnableField().withArn(arn));
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)deleteBucketRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)deleteBucketRequest.getAccountId(), (String)"AccountId", (String)"deleteBucketRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", deleteBucketRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<DeleteBucketResult> responseHandler = new S3ControlStaxResponseHandler<DeleteBucketResult>(new DeleteBucketResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            DeleteBucketResult deleteBucketResult = (DeleteBucketResult)response.getAwsResponse();
            return deleteBucketResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteBucketLifecycleConfigurationResult deleteBucketLifecycleConfiguration(DeleteBucketLifecycleConfigurationRequest request) {
        request = (DeleteBucketLifecycleConfigurationRequest)this.beforeClientExecution(request);
        return this.executeDeleteBucketLifecycleConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteBucketLifecycleConfigurationResult executeDeleteBucketLifecycleConfiguration(DeleteBucketLifecycleConfigurationRequest deleteBucketLifecycleConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteBucketLifecycleConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteBucketLifecycleConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                String bucket = deleteBucketLifecycleConfigurationRequest.getBucket();
                Arn arn = null;
                if (bucket != null && bucket.startsWith("arn:")) {
                    arn = Arn.fromString((String)bucket);
                    S3Resource awsResource = S3ControlArnConverter.getInstance().convertArn(arn);
                    if (!(awsResource instanceof S3ControlBucketResource)) {
                        throw new IllegalArgumentException("Unsupported ARN type: " + awsResource.getClass() + ". Expected com.amazonaws.services.s3control.internal.S3ControlBucketResource.");
                    }
                    S3ControlBucketResource resource = (S3ControlBucketResource)awsResource;
                    deleteBucketLifecycleConfigurationRequest = deleteBucketLifecycleConfigurationRequest.clone();
                    deleteBucketLifecycleConfigurationRequest.setBucket(resource.getBucketName());
                    String accountId = deleteBucketLifecycleConfigurationRequest.getAccountId();
                    String accountIdInArn = resource.getAccountId();
                    if (accountId != null && !accountId.equals(accountIdInArn)) {
                        throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                    }
                    deleteBucketLifecycleConfigurationRequest.setAccountId(accountIdInArn);
                }
                request = new DeleteBucketLifecycleConfigurationRequestMarshaller().marshall((DeleteBucketLifecycleConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteBucketLifecycleConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteBucketLifecycleConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
                request.addHandlerContext(S3ControlHandlerContextKey.S3_ARNABLE_FIELD, (Object)new S3ArnableField().withArn(arn));
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)deleteBucketLifecycleConfigurationRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)deleteBucketLifecycleConfigurationRequest.getAccountId(), (String)"AccountId", (String)"deleteBucketLifecycleConfigurationRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", deleteBucketLifecycleConfigurationRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<DeleteBucketLifecycleConfigurationResult> responseHandler = new S3ControlStaxResponseHandler<DeleteBucketLifecycleConfigurationResult>(new DeleteBucketLifecycleConfigurationResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            DeleteBucketLifecycleConfigurationResult deleteBucketLifecycleConfigurationResult = (DeleteBucketLifecycleConfigurationResult)response.getAwsResponse();
            return deleteBucketLifecycleConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteBucketPolicyResult deleteBucketPolicy(DeleteBucketPolicyRequest request) {
        request = (DeleteBucketPolicyRequest)this.beforeClientExecution(request);
        return this.executeDeleteBucketPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteBucketPolicyResult executeDeleteBucketPolicy(DeleteBucketPolicyRequest deleteBucketPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteBucketPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteBucketPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                String bucket = deleteBucketPolicyRequest.getBucket();
                Arn arn = null;
                if (bucket != null && bucket.startsWith("arn:")) {
                    arn = Arn.fromString((String)bucket);
                    S3Resource awsResource = S3ControlArnConverter.getInstance().convertArn(arn);
                    if (!(awsResource instanceof S3ControlBucketResource)) {
                        throw new IllegalArgumentException("Unsupported ARN type: " + awsResource.getClass() + ". Expected com.amazonaws.services.s3control.internal.S3ControlBucketResource.");
                    }
                    S3ControlBucketResource resource = (S3ControlBucketResource)awsResource;
                    deleteBucketPolicyRequest = deleteBucketPolicyRequest.clone();
                    deleteBucketPolicyRequest.setBucket(resource.getBucketName());
                    String accountId = deleteBucketPolicyRequest.getAccountId();
                    String accountIdInArn = resource.getAccountId();
                    if (accountId != null && !accountId.equals(accountIdInArn)) {
                        throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                    }
                    deleteBucketPolicyRequest.setAccountId(accountIdInArn);
                }
                request = new DeleteBucketPolicyRequestMarshaller().marshall((DeleteBucketPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteBucketPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteBucketPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
                request.addHandlerContext(S3ControlHandlerContextKey.S3_ARNABLE_FIELD, (Object)new S3ArnableField().withArn(arn));
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)deleteBucketPolicyRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)deleteBucketPolicyRequest.getAccountId(), (String)"AccountId", (String)"deleteBucketPolicyRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", deleteBucketPolicyRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<DeleteBucketPolicyResult> responseHandler = new S3ControlStaxResponseHandler<DeleteBucketPolicyResult>(new DeleteBucketPolicyResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            DeleteBucketPolicyResult deleteBucketPolicyResult = (DeleteBucketPolicyResult)response.getAwsResponse();
            return deleteBucketPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteBucketTaggingResult deleteBucketTagging(DeleteBucketTaggingRequest request) {
        request = (DeleteBucketTaggingRequest)this.beforeClientExecution(request);
        return this.executeDeleteBucketTagging(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteBucketTaggingResult executeDeleteBucketTagging(DeleteBucketTaggingRequest deleteBucketTaggingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteBucketTaggingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteBucketTaggingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                String bucket = deleteBucketTaggingRequest.getBucket();
                Arn arn = null;
                if (bucket != null && bucket.startsWith("arn:")) {
                    arn = Arn.fromString((String)bucket);
                    S3Resource awsResource = S3ControlArnConverter.getInstance().convertArn(arn);
                    if (!(awsResource instanceof S3ControlBucketResource)) {
                        throw new IllegalArgumentException("Unsupported ARN type: " + awsResource.getClass() + ". Expected com.amazonaws.services.s3control.internal.S3ControlBucketResource.");
                    }
                    S3ControlBucketResource resource = (S3ControlBucketResource)awsResource;
                    deleteBucketTaggingRequest = deleteBucketTaggingRequest.clone();
                    deleteBucketTaggingRequest.setBucket(resource.getBucketName());
                    String accountId = deleteBucketTaggingRequest.getAccountId();
                    String accountIdInArn = resource.getAccountId();
                    if (accountId != null && !accountId.equals(accountIdInArn)) {
                        throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                    }
                    deleteBucketTaggingRequest.setAccountId(accountIdInArn);
                }
                request = new DeleteBucketTaggingRequestMarshaller().marshall((DeleteBucketTaggingRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteBucketTaggingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteBucketTagging");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
                request.addHandlerContext(S3ControlHandlerContextKey.S3_ARNABLE_FIELD, (Object)new S3ArnableField().withArn(arn));
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)deleteBucketTaggingRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)deleteBucketTaggingRequest.getAccountId(), (String)"AccountId", (String)"deleteBucketTaggingRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", deleteBucketTaggingRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<DeleteBucketTaggingResult> responseHandler = new S3ControlStaxResponseHandler<DeleteBucketTaggingResult>(new DeleteBucketTaggingResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            DeleteBucketTaggingResult deleteBucketTaggingResult = (DeleteBucketTaggingResult)response.getAwsResponse();
            return deleteBucketTaggingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteJobTaggingResult deleteJobTagging(DeleteJobTaggingRequest request) {
        request = (DeleteJobTaggingRequest)this.beforeClientExecution(request);
        return this.executeDeleteJobTagging(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteJobTaggingResult executeDeleteJobTagging(DeleteJobTaggingRequest deleteJobTaggingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteJobTaggingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteJobTaggingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteJobTaggingRequestMarshaller().marshall((DeleteJobTaggingRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteJobTaggingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteJobTagging");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)deleteJobTaggingRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)deleteJobTaggingRequest.getAccountId(), (String)"AccountId", (String)"deleteJobTaggingRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", deleteJobTaggingRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<DeleteJobTaggingResult> responseHandler = new S3ControlStaxResponseHandler<DeleteJobTaggingResult>(new DeleteJobTaggingResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            DeleteJobTaggingResult deleteJobTaggingResult = (DeleteJobTaggingResult)response.getAwsResponse();
            return deleteJobTaggingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeletePublicAccessBlockResult deletePublicAccessBlock(DeletePublicAccessBlockRequest request) {
        request = (DeletePublicAccessBlockRequest)this.beforeClientExecution(request);
        return this.executeDeletePublicAccessBlock(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeletePublicAccessBlockResult executeDeletePublicAccessBlock(DeletePublicAccessBlockRequest deletePublicAccessBlockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePublicAccessBlockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePublicAccessBlockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePublicAccessBlockRequestMarshaller().marshall((DeletePublicAccessBlockRequest)super.beforeMarshalling((AmazonWebServiceRequest)deletePublicAccessBlockRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeletePublicAccessBlock");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)deletePublicAccessBlockRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)deletePublicAccessBlockRequest.getAccountId(), (String)"AccountId", (String)"deletePublicAccessBlockRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", deletePublicAccessBlockRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<DeletePublicAccessBlockResult> responseHandler = new S3ControlStaxResponseHandler<DeletePublicAccessBlockResult>(new DeletePublicAccessBlockResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            DeletePublicAccessBlockResult deletePublicAccessBlockResult = (DeletePublicAccessBlockResult)response.getAwsResponse();
            return deletePublicAccessBlockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteStorageLensConfigurationResult deleteStorageLensConfiguration(DeleteStorageLensConfigurationRequest request) {
        request = (DeleteStorageLensConfigurationRequest)this.beforeClientExecution(request);
        return this.executeDeleteStorageLensConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteStorageLensConfigurationResult executeDeleteStorageLensConfiguration(DeleteStorageLensConfigurationRequest deleteStorageLensConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteStorageLensConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteStorageLensConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteStorageLensConfigurationRequestMarshaller().marshall((DeleteStorageLensConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteStorageLensConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteStorageLensConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)deleteStorageLensConfigurationRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)deleteStorageLensConfigurationRequest.getAccountId(), (String)"AccountId", (String)"deleteStorageLensConfigurationRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", deleteStorageLensConfigurationRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<DeleteStorageLensConfigurationResult> responseHandler = new S3ControlStaxResponseHandler<DeleteStorageLensConfigurationResult>(new DeleteStorageLensConfigurationResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            DeleteStorageLensConfigurationResult deleteStorageLensConfigurationResult = (DeleteStorageLensConfigurationResult)response.getAwsResponse();
            return deleteStorageLensConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteStorageLensConfigurationTaggingResult deleteStorageLensConfigurationTagging(DeleteStorageLensConfigurationTaggingRequest request) {
        request = (DeleteStorageLensConfigurationTaggingRequest)this.beforeClientExecution(request);
        return this.executeDeleteStorageLensConfigurationTagging(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteStorageLensConfigurationTaggingResult executeDeleteStorageLensConfigurationTagging(DeleteStorageLensConfigurationTaggingRequest deleteStorageLensConfigurationTaggingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteStorageLensConfigurationTaggingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteStorageLensConfigurationTaggingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteStorageLensConfigurationTaggingRequestMarshaller().marshall((DeleteStorageLensConfigurationTaggingRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteStorageLensConfigurationTaggingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteStorageLensConfigurationTagging");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)deleteStorageLensConfigurationTaggingRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)deleteStorageLensConfigurationTaggingRequest.getAccountId(), (String)"AccountId", (String)"deleteStorageLensConfigurationTaggingRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", deleteStorageLensConfigurationTaggingRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<DeleteStorageLensConfigurationTaggingResult> responseHandler = new S3ControlStaxResponseHandler<DeleteStorageLensConfigurationTaggingResult>(new DeleteStorageLensConfigurationTaggingResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            DeleteStorageLensConfigurationTaggingResult deleteStorageLensConfigurationTaggingResult = (DeleteStorageLensConfigurationTaggingResult)response.getAwsResponse();
            return deleteStorageLensConfigurationTaggingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeJobResult describeJob(DescribeJobRequest request) {
        request = (DescribeJobRequest)this.beforeClientExecution(request);
        return this.executeDescribeJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeJobResult executeDescribeJob(DescribeJobRequest describeJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeJobRequestMarshaller().marshall((DescribeJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)describeJobRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)describeJobRequest.getAccountId(), (String)"AccountId", (String)"describeJobRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", describeJobRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<DescribeJobResult> responseHandler = new S3ControlStaxResponseHandler<DescribeJobResult>(new DescribeJobResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            DescribeJobResult describeJobResult = (DescribeJobResult)response.getAwsResponse();
            return describeJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAccessPointResult getAccessPoint(GetAccessPointRequest request) {
        request = (GetAccessPointRequest)this.beforeClientExecution(request);
        return this.executeGetAccessPoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAccessPointResult executeGetAccessPoint(GetAccessPointRequest getAccessPointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAccessPointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAccessPointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                String name = getAccessPointRequest.getName();
                Arn arn = null;
                if (name != null && name.startsWith("arn:")) {
                    arn = Arn.fromString((String)name);
                    S3Resource awsResource = S3ControlArnConverter.getInstance().convertArn(arn);
                    if (!(awsResource instanceof S3AccessPointResource)) {
                        throw new IllegalArgumentException("Unsupported ARN type: " + awsResource.getClass() + ". Expected com.amazonaws.services.s3.S3AccessPointResource.");
                    }
                    S3AccessPointResource resource = (S3AccessPointResource)awsResource;
                    getAccessPointRequest = getAccessPointRequest.clone();
                    getAccessPointRequest.setName(resource.getAccessPointName());
                    String accountId = getAccessPointRequest.getAccountId();
                    String accountIdInArn = resource.getAccountId();
                    if (accountId != null && !accountId.equals(accountIdInArn)) {
                        throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                    }
                    getAccessPointRequest.setAccountId(accountIdInArn);
                }
                request = new GetAccessPointRequestMarshaller().marshall((GetAccessPointRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAccessPointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAccessPoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
                request.addHandlerContext(S3ControlHandlerContextKey.S3_ARNABLE_FIELD, (Object)new S3ArnableField().withArn(arn));
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)getAccessPointRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)getAccessPointRequest.getAccountId(), (String)"AccountId", (String)"getAccessPointRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", getAccessPointRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<GetAccessPointResult> responseHandler = new S3ControlStaxResponseHandler<GetAccessPointResult>(new GetAccessPointResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            GetAccessPointResult getAccessPointResult = (GetAccessPointResult)response.getAwsResponse();
            return getAccessPointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAccessPointConfigurationForObjectLambdaResult getAccessPointConfigurationForObjectLambda(GetAccessPointConfigurationForObjectLambdaRequest request) {
        request = (GetAccessPointConfigurationForObjectLambdaRequest)this.beforeClientExecution(request);
        return this.executeGetAccessPointConfigurationForObjectLambda(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAccessPointConfigurationForObjectLambdaResult executeGetAccessPointConfigurationForObjectLambda(GetAccessPointConfigurationForObjectLambdaRequest getAccessPointConfigurationForObjectLambdaRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAccessPointConfigurationForObjectLambdaRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAccessPointConfigurationForObjectLambdaRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAccessPointConfigurationForObjectLambdaRequestMarshaller().marshall((GetAccessPointConfigurationForObjectLambdaRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAccessPointConfigurationForObjectLambdaRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAccessPointConfigurationForObjectLambda");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)getAccessPointConfigurationForObjectLambdaRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)getAccessPointConfigurationForObjectLambdaRequest.getAccountId(), (String)"AccountId", (String)"getAccessPointConfigurationForObjectLambdaRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", getAccessPointConfigurationForObjectLambdaRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<GetAccessPointConfigurationForObjectLambdaResult> responseHandler = new S3ControlStaxResponseHandler<GetAccessPointConfigurationForObjectLambdaResult>(new GetAccessPointConfigurationForObjectLambdaResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            GetAccessPointConfigurationForObjectLambdaResult getAccessPointConfigurationForObjectLambdaResult = (GetAccessPointConfigurationForObjectLambdaResult)response.getAwsResponse();
            return getAccessPointConfigurationForObjectLambdaResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAccessPointForObjectLambdaResult getAccessPointForObjectLambda(GetAccessPointForObjectLambdaRequest request) {
        request = (GetAccessPointForObjectLambdaRequest)this.beforeClientExecution(request);
        return this.executeGetAccessPointForObjectLambda(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAccessPointForObjectLambdaResult executeGetAccessPointForObjectLambda(GetAccessPointForObjectLambdaRequest getAccessPointForObjectLambdaRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAccessPointForObjectLambdaRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAccessPointForObjectLambdaRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAccessPointForObjectLambdaRequestMarshaller().marshall((GetAccessPointForObjectLambdaRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAccessPointForObjectLambdaRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAccessPointForObjectLambda");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)getAccessPointForObjectLambdaRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)getAccessPointForObjectLambdaRequest.getAccountId(), (String)"AccountId", (String)"getAccessPointForObjectLambdaRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", getAccessPointForObjectLambdaRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<GetAccessPointForObjectLambdaResult> responseHandler = new S3ControlStaxResponseHandler<GetAccessPointForObjectLambdaResult>(new GetAccessPointForObjectLambdaResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            GetAccessPointForObjectLambdaResult getAccessPointForObjectLambdaResult = (GetAccessPointForObjectLambdaResult)response.getAwsResponse();
            return getAccessPointForObjectLambdaResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAccessPointPolicyResult getAccessPointPolicy(GetAccessPointPolicyRequest request) {
        request = (GetAccessPointPolicyRequest)this.beforeClientExecution(request);
        return this.executeGetAccessPointPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAccessPointPolicyResult executeGetAccessPointPolicy(GetAccessPointPolicyRequest getAccessPointPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAccessPointPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAccessPointPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                String name = getAccessPointPolicyRequest.getName();
                Arn arn = null;
                if (name != null && name.startsWith("arn:")) {
                    arn = Arn.fromString((String)name);
                    S3Resource awsResource = S3ControlArnConverter.getInstance().convertArn(arn);
                    if (!(awsResource instanceof S3AccessPointResource)) {
                        throw new IllegalArgumentException("Unsupported ARN type: " + awsResource.getClass() + ". Expected com.amazonaws.services.s3.S3AccessPointResource.");
                    }
                    S3AccessPointResource resource = (S3AccessPointResource)awsResource;
                    getAccessPointPolicyRequest = getAccessPointPolicyRequest.clone();
                    getAccessPointPolicyRequest.setName(resource.getAccessPointName());
                    String accountId = getAccessPointPolicyRequest.getAccountId();
                    String accountIdInArn = resource.getAccountId();
                    if (accountId != null && !accountId.equals(accountIdInArn)) {
                        throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                    }
                    getAccessPointPolicyRequest.setAccountId(accountIdInArn);
                }
                request = new GetAccessPointPolicyRequestMarshaller().marshall((GetAccessPointPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAccessPointPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAccessPointPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
                request.addHandlerContext(S3ControlHandlerContextKey.S3_ARNABLE_FIELD, (Object)new S3ArnableField().withArn(arn));
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)getAccessPointPolicyRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)getAccessPointPolicyRequest.getAccountId(), (String)"AccountId", (String)"getAccessPointPolicyRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", getAccessPointPolicyRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<GetAccessPointPolicyResult> responseHandler = new S3ControlStaxResponseHandler<GetAccessPointPolicyResult>(new GetAccessPointPolicyResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            GetAccessPointPolicyResult getAccessPointPolicyResult = (GetAccessPointPolicyResult)response.getAwsResponse();
            return getAccessPointPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAccessPointPolicyForObjectLambdaResult getAccessPointPolicyForObjectLambda(GetAccessPointPolicyForObjectLambdaRequest request) {
        request = (GetAccessPointPolicyForObjectLambdaRequest)this.beforeClientExecution(request);
        return this.executeGetAccessPointPolicyForObjectLambda(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAccessPointPolicyForObjectLambdaResult executeGetAccessPointPolicyForObjectLambda(GetAccessPointPolicyForObjectLambdaRequest getAccessPointPolicyForObjectLambdaRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAccessPointPolicyForObjectLambdaRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAccessPointPolicyForObjectLambdaRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAccessPointPolicyForObjectLambdaRequestMarshaller().marshall((GetAccessPointPolicyForObjectLambdaRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAccessPointPolicyForObjectLambdaRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAccessPointPolicyForObjectLambda");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)getAccessPointPolicyForObjectLambdaRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)getAccessPointPolicyForObjectLambdaRequest.getAccountId(), (String)"AccountId", (String)"getAccessPointPolicyForObjectLambdaRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", getAccessPointPolicyForObjectLambdaRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<GetAccessPointPolicyForObjectLambdaResult> responseHandler = new S3ControlStaxResponseHandler<GetAccessPointPolicyForObjectLambdaResult>(new GetAccessPointPolicyForObjectLambdaResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            GetAccessPointPolicyForObjectLambdaResult getAccessPointPolicyForObjectLambdaResult = (GetAccessPointPolicyForObjectLambdaResult)response.getAwsResponse();
            return getAccessPointPolicyForObjectLambdaResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAccessPointPolicyStatusResult getAccessPointPolicyStatus(GetAccessPointPolicyStatusRequest request) {
        request = (GetAccessPointPolicyStatusRequest)this.beforeClientExecution(request);
        return this.executeGetAccessPointPolicyStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAccessPointPolicyStatusResult executeGetAccessPointPolicyStatus(GetAccessPointPolicyStatusRequest getAccessPointPolicyStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAccessPointPolicyStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAccessPointPolicyStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAccessPointPolicyStatusRequestMarshaller().marshall((GetAccessPointPolicyStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAccessPointPolicyStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAccessPointPolicyStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)getAccessPointPolicyStatusRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)getAccessPointPolicyStatusRequest.getAccountId(), (String)"AccountId", (String)"getAccessPointPolicyStatusRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", getAccessPointPolicyStatusRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<GetAccessPointPolicyStatusResult> responseHandler = new S3ControlStaxResponseHandler<GetAccessPointPolicyStatusResult>(new GetAccessPointPolicyStatusResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            GetAccessPointPolicyStatusResult getAccessPointPolicyStatusResult = (GetAccessPointPolicyStatusResult)response.getAwsResponse();
            return getAccessPointPolicyStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAccessPointPolicyStatusForObjectLambdaResult getAccessPointPolicyStatusForObjectLambda(GetAccessPointPolicyStatusForObjectLambdaRequest request) {
        request = (GetAccessPointPolicyStatusForObjectLambdaRequest)this.beforeClientExecution(request);
        return this.executeGetAccessPointPolicyStatusForObjectLambda(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAccessPointPolicyStatusForObjectLambdaResult executeGetAccessPointPolicyStatusForObjectLambda(GetAccessPointPolicyStatusForObjectLambdaRequest getAccessPointPolicyStatusForObjectLambdaRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAccessPointPolicyStatusForObjectLambdaRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAccessPointPolicyStatusForObjectLambdaRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAccessPointPolicyStatusForObjectLambdaRequestMarshaller().marshall((GetAccessPointPolicyStatusForObjectLambdaRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAccessPointPolicyStatusForObjectLambdaRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAccessPointPolicyStatusForObjectLambda");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)getAccessPointPolicyStatusForObjectLambdaRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)getAccessPointPolicyStatusForObjectLambdaRequest.getAccountId(), (String)"AccountId", (String)"getAccessPointPolicyStatusForObjectLambdaRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", getAccessPointPolicyStatusForObjectLambdaRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<GetAccessPointPolicyStatusForObjectLambdaResult> responseHandler = new S3ControlStaxResponseHandler<GetAccessPointPolicyStatusForObjectLambdaResult>(new GetAccessPointPolicyStatusForObjectLambdaResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            GetAccessPointPolicyStatusForObjectLambdaResult getAccessPointPolicyStatusForObjectLambdaResult = (GetAccessPointPolicyStatusForObjectLambdaResult)response.getAwsResponse();
            return getAccessPointPolicyStatusForObjectLambdaResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetBucketResult getBucket(GetBucketRequest request) {
        request = (GetBucketRequest)this.beforeClientExecution(request);
        return this.executeGetBucket(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetBucketResult executeGetBucket(GetBucketRequest getBucketRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getBucketRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetBucketRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                String bucket = getBucketRequest.getBucket();
                Arn arn = null;
                if (bucket != null && bucket.startsWith("arn:")) {
                    arn = Arn.fromString((String)bucket);
                    S3Resource awsResource = S3ControlArnConverter.getInstance().convertArn(arn);
                    if (!(awsResource instanceof S3ControlBucketResource)) {
                        throw new IllegalArgumentException("Unsupported ARN type: " + awsResource.getClass() + ". Expected com.amazonaws.services.s3control.internal.S3ControlBucketResource.");
                    }
                    S3ControlBucketResource resource = (S3ControlBucketResource)awsResource;
                    getBucketRequest = getBucketRequest.clone();
                    getBucketRequest.setBucket(resource.getBucketName());
                    String accountId = getBucketRequest.getAccountId();
                    String accountIdInArn = resource.getAccountId();
                    if (accountId != null && !accountId.equals(accountIdInArn)) {
                        throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                    }
                    getBucketRequest.setAccountId(accountIdInArn);
                }
                request = new GetBucketRequestMarshaller().marshall((GetBucketRequest)super.beforeMarshalling((AmazonWebServiceRequest)getBucketRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetBucket");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
                request.addHandlerContext(S3ControlHandlerContextKey.S3_ARNABLE_FIELD, (Object)new S3ArnableField().withArn(arn));
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)getBucketRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)getBucketRequest.getAccountId(), (String)"AccountId", (String)"getBucketRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", getBucketRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<GetBucketResult> responseHandler = new S3ControlStaxResponseHandler<GetBucketResult>(new GetBucketResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            GetBucketResult getBucketResult = (GetBucketResult)response.getAwsResponse();
            return getBucketResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetBucketLifecycleConfigurationResult getBucketLifecycleConfiguration(GetBucketLifecycleConfigurationRequest request) {
        request = (GetBucketLifecycleConfigurationRequest)this.beforeClientExecution(request);
        return this.executeGetBucketLifecycleConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetBucketLifecycleConfigurationResult executeGetBucketLifecycleConfiguration(GetBucketLifecycleConfigurationRequest getBucketLifecycleConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getBucketLifecycleConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetBucketLifecycleConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                String bucket = getBucketLifecycleConfigurationRequest.getBucket();
                Arn arn = null;
                if (bucket != null && bucket.startsWith("arn:")) {
                    arn = Arn.fromString((String)bucket);
                    S3Resource awsResource = S3ControlArnConverter.getInstance().convertArn(arn);
                    if (!(awsResource instanceof S3ControlBucketResource)) {
                        throw new IllegalArgumentException("Unsupported ARN type: " + awsResource.getClass() + ". Expected com.amazonaws.services.s3control.internal.S3ControlBucketResource.");
                    }
                    S3ControlBucketResource resource = (S3ControlBucketResource)awsResource;
                    getBucketLifecycleConfigurationRequest = getBucketLifecycleConfigurationRequest.clone();
                    getBucketLifecycleConfigurationRequest.setBucket(resource.getBucketName());
                    String accountId = getBucketLifecycleConfigurationRequest.getAccountId();
                    String accountIdInArn = resource.getAccountId();
                    if (accountId != null && !accountId.equals(accountIdInArn)) {
                        throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                    }
                    getBucketLifecycleConfigurationRequest.setAccountId(accountIdInArn);
                }
                request = new GetBucketLifecycleConfigurationRequestMarshaller().marshall((GetBucketLifecycleConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getBucketLifecycleConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetBucketLifecycleConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
                request.addHandlerContext(S3ControlHandlerContextKey.S3_ARNABLE_FIELD, (Object)new S3ArnableField().withArn(arn));
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)getBucketLifecycleConfigurationRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)getBucketLifecycleConfigurationRequest.getAccountId(), (String)"AccountId", (String)"getBucketLifecycleConfigurationRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", getBucketLifecycleConfigurationRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<GetBucketLifecycleConfigurationResult> responseHandler = new S3ControlStaxResponseHandler<GetBucketLifecycleConfigurationResult>(new GetBucketLifecycleConfigurationResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            GetBucketLifecycleConfigurationResult getBucketLifecycleConfigurationResult = (GetBucketLifecycleConfigurationResult)response.getAwsResponse();
            return getBucketLifecycleConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetBucketPolicyResult getBucketPolicy(GetBucketPolicyRequest request) {
        request = (GetBucketPolicyRequest)this.beforeClientExecution(request);
        return this.executeGetBucketPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetBucketPolicyResult executeGetBucketPolicy(GetBucketPolicyRequest getBucketPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getBucketPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetBucketPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                String bucket = getBucketPolicyRequest.getBucket();
                Arn arn = null;
                if (bucket != null && bucket.startsWith("arn:")) {
                    arn = Arn.fromString((String)bucket);
                    S3Resource awsResource = S3ControlArnConverter.getInstance().convertArn(arn);
                    if (!(awsResource instanceof S3ControlBucketResource)) {
                        throw new IllegalArgumentException("Unsupported ARN type: " + awsResource.getClass() + ". Expected com.amazonaws.services.s3control.internal.S3ControlBucketResource.");
                    }
                    S3ControlBucketResource resource = (S3ControlBucketResource)awsResource;
                    getBucketPolicyRequest = getBucketPolicyRequest.clone();
                    getBucketPolicyRequest.setBucket(resource.getBucketName());
                    String accountId = getBucketPolicyRequest.getAccountId();
                    String accountIdInArn = resource.getAccountId();
                    if (accountId != null && !accountId.equals(accountIdInArn)) {
                        throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                    }
                    getBucketPolicyRequest.setAccountId(accountIdInArn);
                }
                request = new GetBucketPolicyRequestMarshaller().marshall((GetBucketPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getBucketPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetBucketPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
                request.addHandlerContext(S3ControlHandlerContextKey.S3_ARNABLE_FIELD, (Object)new S3ArnableField().withArn(arn));
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)getBucketPolicyRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)getBucketPolicyRequest.getAccountId(), (String)"AccountId", (String)"getBucketPolicyRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", getBucketPolicyRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<GetBucketPolicyResult> responseHandler = new S3ControlStaxResponseHandler<GetBucketPolicyResult>(new GetBucketPolicyResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            GetBucketPolicyResult getBucketPolicyResult = (GetBucketPolicyResult)response.getAwsResponse();
            return getBucketPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetBucketTaggingResult getBucketTagging(GetBucketTaggingRequest request) {
        request = (GetBucketTaggingRequest)this.beforeClientExecution(request);
        return this.executeGetBucketTagging(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetBucketTaggingResult executeGetBucketTagging(GetBucketTaggingRequest getBucketTaggingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getBucketTaggingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetBucketTaggingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                String bucket = getBucketTaggingRequest.getBucket();
                Arn arn = null;
                if (bucket != null && bucket.startsWith("arn:")) {
                    arn = Arn.fromString((String)bucket);
                    S3Resource awsResource = S3ControlArnConverter.getInstance().convertArn(arn);
                    if (!(awsResource instanceof S3ControlBucketResource)) {
                        throw new IllegalArgumentException("Unsupported ARN type: " + awsResource.getClass() + ". Expected com.amazonaws.services.s3control.internal.S3ControlBucketResource.");
                    }
                    S3ControlBucketResource resource = (S3ControlBucketResource)awsResource;
                    getBucketTaggingRequest = getBucketTaggingRequest.clone();
                    getBucketTaggingRequest.setBucket(resource.getBucketName());
                    String accountId = getBucketTaggingRequest.getAccountId();
                    String accountIdInArn = resource.getAccountId();
                    if (accountId != null && !accountId.equals(accountIdInArn)) {
                        throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                    }
                    getBucketTaggingRequest.setAccountId(accountIdInArn);
                }
                request = new GetBucketTaggingRequestMarshaller().marshall((GetBucketTaggingRequest)super.beforeMarshalling((AmazonWebServiceRequest)getBucketTaggingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetBucketTagging");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
                request.addHandlerContext(S3ControlHandlerContextKey.S3_ARNABLE_FIELD, (Object)new S3ArnableField().withArn(arn));
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)getBucketTaggingRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)getBucketTaggingRequest.getAccountId(), (String)"AccountId", (String)"getBucketTaggingRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", getBucketTaggingRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<GetBucketTaggingResult> responseHandler = new S3ControlStaxResponseHandler<GetBucketTaggingResult>(new GetBucketTaggingResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            GetBucketTaggingResult getBucketTaggingResult = (GetBucketTaggingResult)response.getAwsResponse();
            return getBucketTaggingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetJobTaggingResult getJobTagging(GetJobTaggingRequest request) {
        request = (GetJobTaggingRequest)this.beforeClientExecution(request);
        return this.executeGetJobTagging(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetJobTaggingResult executeGetJobTagging(GetJobTaggingRequest getJobTaggingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getJobTaggingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetJobTaggingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetJobTaggingRequestMarshaller().marshall((GetJobTaggingRequest)super.beforeMarshalling((AmazonWebServiceRequest)getJobTaggingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetJobTagging");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)getJobTaggingRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)getJobTaggingRequest.getAccountId(), (String)"AccountId", (String)"getJobTaggingRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", getJobTaggingRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<GetJobTaggingResult> responseHandler = new S3ControlStaxResponseHandler<GetJobTaggingResult>(new GetJobTaggingResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            GetJobTaggingResult getJobTaggingResult = (GetJobTaggingResult)response.getAwsResponse();
            return getJobTaggingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetPublicAccessBlockResult getPublicAccessBlock(GetPublicAccessBlockRequest request) {
        request = (GetPublicAccessBlockRequest)this.beforeClientExecution(request);
        return this.executeGetPublicAccessBlock(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetPublicAccessBlockResult executeGetPublicAccessBlock(GetPublicAccessBlockRequest getPublicAccessBlockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPublicAccessBlockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPublicAccessBlockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPublicAccessBlockRequestMarshaller().marshall((GetPublicAccessBlockRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPublicAccessBlockRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetPublicAccessBlock");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)getPublicAccessBlockRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)getPublicAccessBlockRequest.getAccountId(), (String)"AccountId", (String)"getPublicAccessBlockRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", getPublicAccessBlockRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<GetPublicAccessBlockResult> responseHandler = new S3ControlStaxResponseHandler<GetPublicAccessBlockResult>(new GetPublicAccessBlockResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            GetPublicAccessBlockResult getPublicAccessBlockResult = (GetPublicAccessBlockResult)response.getAwsResponse();
            return getPublicAccessBlockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetStorageLensConfigurationResult getStorageLensConfiguration(GetStorageLensConfigurationRequest request) {
        request = (GetStorageLensConfigurationRequest)this.beforeClientExecution(request);
        return this.executeGetStorageLensConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetStorageLensConfigurationResult executeGetStorageLensConfiguration(GetStorageLensConfigurationRequest getStorageLensConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getStorageLensConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetStorageLensConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetStorageLensConfigurationRequestMarshaller().marshall((GetStorageLensConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getStorageLensConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetStorageLensConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)getStorageLensConfigurationRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)getStorageLensConfigurationRequest.getAccountId(), (String)"AccountId", (String)"getStorageLensConfigurationRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", getStorageLensConfigurationRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<GetStorageLensConfigurationResult> responseHandler = new S3ControlStaxResponseHandler<GetStorageLensConfigurationResult>(new GetStorageLensConfigurationResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            GetStorageLensConfigurationResult getStorageLensConfigurationResult = (GetStorageLensConfigurationResult)response.getAwsResponse();
            return getStorageLensConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetStorageLensConfigurationTaggingResult getStorageLensConfigurationTagging(GetStorageLensConfigurationTaggingRequest request) {
        request = (GetStorageLensConfigurationTaggingRequest)this.beforeClientExecution(request);
        return this.executeGetStorageLensConfigurationTagging(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetStorageLensConfigurationTaggingResult executeGetStorageLensConfigurationTagging(GetStorageLensConfigurationTaggingRequest getStorageLensConfigurationTaggingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getStorageLensConfigurationTaggingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetStorageLensConfigurationTaggingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetStorageLensConfigurationTaggingRequestMarshaller().marshall((GetStorageLensConfigurationTaggingRequest)super.beforeMarshalling((AmazonWebServiceRequest)getStorageLensConfigurationTaggingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetStorageLensConfigurationTagging");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)getStorageLensConfigurationTaggingRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)getStorageLensConfigurationTaggingRequest.getAccountId(), (String)"AccountId", (String)"getStorageLensConfigurationTaggingRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", getStorageLensConfigurationTaggingRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<GetStorageLensConfigurationTaggingResult> responseHandler = new S3ControlStaxResponseHandler<GetStorageLensConfigurationTaggingResult>(new GetStorageLensConfigurationTaggingResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            GetStorageLensConfigurationTaggingResult getStorageLensConfigurationTaggingResult = (GetStorageLensConfigurationTaggingResult)response.getAwsResponse();
            return getStorageLensConfigurationTaggingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAccessPointsResult listAccessPoints(ListAccessPointsRequest request) {
        request = (ListAccessPointsRequest)this.beforeClientExecution(request);
        return this.executeListAccessPoints(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAccessPointsResult executeListAccessPoints(ListAccessPointsRequest listAccessPointsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAccessPointsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAccessPointsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                String bucket = listAccessPointsRequest.getBucket();
                Arn arn = null;
                if (bucket != null && bucket.startsWith("arn:")) {
                    arn = Arn.fromString((String)bucket);
                    S3Resource awsResource = S3ControlArnConverter.getInstance().convertArn(arn);
                    if (!(awsResource instanceof S3ControlBucketResource)) {
                        throw new IllegalArgumentException("Unsupported ARN type: " + awsResource.getClass() + ". Expected com.amazonaws.services.s3control.internal.S3ControlBucketResource.");
                    }
                    S3ControlBucketResource resource = (S3ControlBucketResource)awsResource;
                    listAccessPointsRequest = listAccessPointsRequest.clone();
                    listAccessPointsRequest.setBucket(resource.getBucketName());
                    String accountId = listAccessPointsRequest.getAccountId();
                    String accountIdInArn = resource.getAccountId();
                    if (accountId != null && !accountId.equals(accountIdInArn)) {
                        throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                    }
                    listAccessPointsRequest.setAccountId(accountIdInArn);
                }
                request = new ListAccessPointsRequestMarshaller().marshall((ListAccessPointsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAccessPointsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAccessPoints");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
                request.addHandlerContext(S3ControlHandlerContextKey.S3_ARNABLE_FIELD, (Object)new S3ArnableField().withArn(arn));
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)listAccessPointsRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)listAccessPointsRequest.getAccountId(), (String)"AccountId", (String)"listAccessPointsRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", listAccessPointsRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<ListAccessPointsResult> responseHandler = new S3ControlStaxResponseHandler<ListAccessPointsResult>(new ListAccessPointsResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            ListAccessPointsResult listAccessPointsResult = (ListAccessPointsResult)response.getAwsResponse();
            return listAccessPointsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAccessPointsForObjectLambdaResult listAccessPointsForObjectLambda(ListAccessPointsForObjectLambdaRequest request) {
        request = (ListAccessPointsForObjectLambdaRequest)this.beforeClientExecution(request);
        return this.executeListAccessPointsForObjectLambda(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAccessPointsForObjectLambdaResult executeListAccessPointsForObjectLambda(ListAccessPointsForObjectLambdaRequest listAccessPointsForObjectLambdaRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAccessPointsForObjectLambdaRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAccessPointsForObjectLambdaRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAccessPointsForObjectLambdaRequestMarshaller().marshall((ListAccessPointsForObjectLambdaRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAccessPointsForObjectLambdaRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAccessPointsForObjectLambda");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)listAccessPointsForObjectLambdaRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)listAccessPointsForObjectLambdaRequest.getAccountId(), (String)"AccountId", (String)"listAccessPointsForObjectLambdaRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", listAccessPointsForObjectLambdaRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<ListAccessPointsForObjectLambdaResult> responseHandler = new S3ControlStaxResponseHandler<ListAccessPointsForObjectLambdaResult>(new ListAccessPointsForObjectLambdaResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            ListAccessPointsForObjectLambdaResult listAccessPointsForObjectLambdaResult = (ListAccessPointsForObjectLambdaResult)response.getAwsResponse();
            return listAccessPointsForObjectLambdaResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListJobsResult listJobs(ListJobsRequest request) {
        request = (ListJobsRequest)this.beforeClientExecution(request);
        return this.executeListJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListJobsResult executeListJobs(ListJobsRequest listJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListJobsRequestMarshaller().marshall((ListJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)listJobsRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)listJobsRequest.getAccountId(), (String)"AccountId", (String)"listJobsRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", listJobsRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<ListJobsResult> responseHandler = new S3ControlStaxResponseHandler<ListJobsResult>(new ListJobsResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            ListJobsResult listJobsResult = (ListJobsResult)response.getAwsResponse();
            return listJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRegionalBucketsResult listRegionalBuckets(ListRegionalBucketsRequest request) {
        request = (ListRegionalBucketsRequest)this.beforeClientExecution(request);
        return this.executeListRegionalBuckets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRegionalBucketsResult executeListRegionalBuckets(ListRegionalBucketsRequest listRegionalBucketsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRegionalBucketsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRegionalBucketsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRegionalBucketsRequestMarshaller().marshall((ListRegionalBucketsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRegionalBucketsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListRegionalBuckets");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)listRegionalBucketsRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)listRegionalBucketsRequest.getAccountId(), (String)"AccountId", (String)"listRegionalBucketsRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", listRegionalBucketsRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<ListRegionalBucketsResult> responseHandler = new S3ControlStaxResponseHandler<ListRegionalBucketsResult>(new ListRegionalBucketsResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            ListRegionalBucketsResult listRegionalBucketsResult = (ListRegionalBucketsResult)response.getAwsResponse();
            return listRegionalBucketsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListStorageLensConfigurationsResult listStorageLensConfigurations(ListStorageLensConfigurationsRequest request) {
        request = (ListStorageLensConfigurationsRequest)this.beforeClientExecution(request);
        return this.executeListStorageLensConfigurations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListStorageLensConfigurationsResult executeListStorageLensConfigurations(ListStorageLensConfigurationsRequest listStorageLensConfigurationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listStorageLensConfigurationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListStorageLensConfigurationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListStorageLensConfigurationsRequestMarshaller().marshall((ListStorageLensConfigurationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listStorageLensConfigurationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListStorageLensConfigurations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)listStorageLensConfigurationsRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)listStorageLensConfigurationsRequest.getAccountId(), (String)"AccountId", (String)"listStorageLensConfigurationsRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", listStorageLensConfigurationsRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<ListStorageLensConfigurationsResult> responseHandler = new S3ControlStaxResponseHandler<ListStorageLensConfigurationsResult>(new ListStorageLensConfigurationsResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            ListStorageLensConfigurationsResult listStorageLensConfigurationsResult = (ListStorageLensConfigurationsResult)response.getAwsResponse();
            return listStorageLensConfigurationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutAccessPointConfigurationForObjectLambdaResult putAccessPointConfigurationForObjectLambda(PutAccessPointConfigurationForObjectLambdaRequest request) {
        request = (PutAccessPointConfigurationForObjectLambdaRequest)this.beforeClientExecution(request);
        return this.executePutAccessPointConfigurationForObjectLambda(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutAccessPointConfigurationForObjectLambdaResult executePutAccessPointConfigurationForObjectLambda(PutAccessPointConfigurationForObjectLambdaRequest putAccessPointConfigurationForObjectLambdaRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putAccessPointConfigurationForObjectLambdaRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutAccessPointConfigurationForObjectLambdaRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutAccessPointConfigurationForObjectLambdaRequestMarshaller().marshall((PutAccessPointConfigurationForObjectLambdaRequest)super.beforeMarshalling((AmazonWebServiceRequest)putAccessPointConfigurationForObjectLambdaRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutAccessPointConfigurationForObjectLambda");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)putAccessPointConfigurationForObjectLambdaRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)putAccessPointConfigurationForObjectLambdaRequest.getAccountId(), (String)"AccountId", (String)"putAccessPointConfigurationForObjectLambdaRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", putAccessPointConfigurationForObjectLambdaRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<PutAccessPointConfigurationForObjectLambdaResult> responseHandler = new S3ControlStaxResponseHandler<PutAccessPointConfigurationForObjectLambdaResult>(new PutAccessPointConfigurationForObjectLambdaResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            PutAccessPointConfigurationForObjectLambdaResult putAccessPointConfigurationForObjectLambdaResult = (PutAccessPointConfigurationForObjectLambdaResult)response.getAwsResponse();
            return putAccessPointConfigurationForObjectLambdaResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutAccessPointPolicyResult putAccessPointPolicy(PutAccessPointPolicyRequest request) {
        request = (PutAccessPointPolicyRequest)this.beforeClientExecution(request);
        return this.executePutAccessPointPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutAccessPointPolicyResult executePutAccessPointPolicy(PutAccessPointPolicyRequest putAccessPointPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putAccessPointPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutAccessPointPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                String name = putAccessPointPolicyRequest.getName();
                Arn arn = null;
                if (name != null && name.startsWith("arn:")) {
                    arn = Arn.fromString((String)name);
                    S3Resource awsResource = S3ControlArnConverter.getInstance().convertArn(arn);
                    if (!(awsResource instanceof S3AccessPointResource)) {
                        throw new IllegalArgumentException("Unsupported ARN type: " + awsResource.getClass() + ". Expected com.amazonaws.services.s3.S3AccessPointResource.");
                    }
                    S3AccessPointResource resource = (S3AccessPointResource)awsResource;
                    putAccessPointPolicyRequest = putAccessPointPolicyRequest.clone();
                    putAccessPointPolicyRequest.setName(resource.getAccessPointName());
                    String accountId = putAccessPointPolicyRequest.getAccountId();
                    String accountIdInArn = resource.getAccountId();
                    if (accountId != null && !accountId.equals(accountIdInArn)) {
                        throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                    }
                    putAccessPointPolicyRequest.setAccountId(accountIdInArn);
                }
                request = new PutAccessPointPolicyRequestMarshaller().marshall((PutAccessPointPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)putAccessPointPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutAccessPointPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
                request.addHandlerContext(S3ControlHandlerContextKey.S3_ARNABLE_FIELD, (Object)new S3ArnableField().withArn(arn));
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)putAccessPointPolicyRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)putAccessPointPolicyRequest.getAccountId(), (String)"AccountId", (String)"putAccessPointPolicyRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", putAccessPointPolicyRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<PutAccessPointPolicyResult> responseHandler = new S3ControlStaxResponseHandler<PutAccessPointPolicyResult>(new PutAccessPointPolicyResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            PutAccessPointPolicyResult putAccessPointPolicyResult = (PutAccessPointPolicyResult)response.getAwsResponse();
            return putAccessPointPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutAccessPointPolicyForObjectLambdaResult putAccessPointPolicyForObjectLambda(PutAccessPointPolicyForObjectLambdaRequest request) {
        request = (PutAccessPointPolicyForObjectLambdaRequest)this.beforeClientExecution(request);
        return this.executePutAccessPointPolicyForObjectLambda(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutAccessPointPolicyForObjectLambdaResult executePutAccessPointPolicyForObjectLambda(PutAccessPointPolicyForObjectLambdaRequest putAccessPointPolicyForObjectLambdaRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putAccessPointPolicyForObjectLambdaRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutAccessPointPolicyForObjectLambdaRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutAccessPointPolicyForObjectLambdaRequestMarshaller().marshall((PutAccessPointPolicyForObjectLambdaRequest)super.beforeMarshalling((AmazonWebServiceRequest)putAccessPointPolicyForObjectLambdaRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutAccessPointPolicyForObjectLambda");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)putAccessPointPolicyForObjectLambdaRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)putAccessPointPolicyForObjectLambdaRequest.getAccountId(), (String)"AccountId", (String)"putAccessPointPolicyForObjectLambdaRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", putAccessPointPolicyForObjectLambdaRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<PutAccessPointPolicyForObjectLambdaResult> responseHandler = new S3ControlStaxResponseHandler<PutAccessPointPolicyForObjectLambdaResult>(new PutAccessPointPolicyForObjectLambdaResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            PutAccessPointPolicyForObjectLambdaResult putAccessPointPolicyForObjectLambdaResult = (PutAccessPointPolicyForObjectLambdaResult)response.getAwsResponse();
            return putAccessPointPolicyForObjectLambdaResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutBucketLifecycleConfigurationResult putBucketLifecycleConfiguration(PutBucketLifecycleConfigurationRequest request) {
        request = (PutBucketLifecycleConfigurationRequest)this.beforeClientExecution(request);
        return this.executePutBucketLifecycleConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutBucketLifecycleConfigurationResult executePutBucketLifecycleConfiguration(PutBucketLifecycleConfigurationRequest putBucketLifecycleConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putBucketLifecycleConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutBucketLifecycleConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                String bucket = putBucketLifecycleConfigurationRequest.getBucket();
                Arn arn = null;
                if (bucket != null && bucket.startsWith("arn:")) {
                    arn = Arn.fromString((String)bucket);
                    S3Resource awsResource = S3ControlArnConverter.getInstance().convertArn(arn);
                    if (!(awsResource instanceof S3ControlBucketResource)) {
                        throw new IllegalArgumentException("Unsupported ARN type: " + awsResource.getClass() + ". Expected com.amazonaws.services.s3control.internal.S3ControlBucketResource.");
                    }
                    S3ControlBucketResource resource = (S3ControlBucketResource)awsResource;
                    putBucketLifecycleConfigurationRequest = putBucketLifecycleConfigurationRequest.clone();
                    putBucketLifecycleConfigurationRequest.setBucket(resource.getBucketName());
                    String accountId = putBucketLifecycleConfigurationRequest.getAccountId();
                    String accountIdInArn = resource.getAccountId();
                    if (accountId != null && !accountId.equals(accountIdInArn)) {
                        throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                    }
                    putBucketLifecycleConfigurationRequest.setAccountId(accountIdInArn);
                }
                request = new PutBucketLifecycleConfigurationRequestMarshaller().marshall((PutBucketLifecycleConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)putBucketLifecycleConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutBucketLifecycleConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
                request.addHandlerContext(S3ControlHandlerContextKey.S3_ARNABLE_FIELD, (Object)new S3ArnableField().withArn(arn));
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)putBucketLifecycleConfigurationRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)putBucketLifecycleConfigurationRequest.getAccountId(), (String)"AccountId", (String)"putBucketLifecycleConfigurationRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", putBucketLifecycleConfigurationRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<PutBucketLifecycleConfigurationResult> responseHandler = new S3ControlStaxResponseHandler<PutBucketLifecycleConfigurationResult>(new PutBucketLifecycleConfigurationResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            PutBucketLifecycleConfigurationResult putBucketLifecycleConfigurationResult = (PutBucketLifecycleConfigurationResult)response.getAwsResponse();
            return putBucketLifecycleConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutBucketPolicyResult putBucketPolicy(PutBucketPolicyRequest request) {
        request = (PutBucketPolicyRequest)this.beforeClientExecution(request);
        return this.executePutBucketPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutBucketPolicyResult executePutBucketPolicy(PutBucketPolicyRequest putBucketPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putBucketPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutBucketPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                String bucket = putBucketPolicyRequest.getBucket();
                Arn arn = null;
                if (bucket != null && bucket.startsWith("arn:")) {
                    arn = Arn.fromString((String)bucket);
                    S3Resource awsResource = S3ControlArnConverter.getInstance().convertArn(arn);
                    if (!(awsResource instanceof S3ControlBucketResource)) {
                        throw new IllegalArgumentException("Unsupported ARN type: " + awsResource.getClass() + ". Expected com.amazonaws.services.s3control.internal.S3ControlBucketResource.");
                    }
                    S3ControlBucketResource resource = (S3ControlBucketResource)awsResource;
                    putBucketPolicyRequest = putBucketPolicyRequest.clone();
                    putBucketPolicyRequest.setBucket(resource.getBucketName());
                    String accountId = putBucketPolicyRequest.getAccountId();
                    String accountIdInArn = resource.getAccountId();
                    if (accountId != null && !accountId.equals(accountIdInArn)) {
                        throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                    }
                    putBucketPolicyRequest.setAccountId(accountIdInArn);
                }
                request = new PutBucketPolicyRequestMarshaller().marshall((PutBucketPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)putBucketPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutBucketPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
                request.addHandlerContext(S3ControlHandlerContextKey.S3_ARNABLE_FIELD, (Object)new S3ArnableField().withArn(arn));
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)putBucketPolicyRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)putBucketPolicyRequest.getAccountId(), (String)"AccountId", (String)"putBucketPolicyRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", putBucketPolicyRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<PutBucketPolicyResult> responseHandler = new S3ControlStaxResponseHandler<PutBucketPolicyResult>(new PutBucketPolicyResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            PutBucketPolicyResult putBucketPolicyResult = (PutBucketPolicyResult)response.getAwsResponse();
            return putBucketPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutBucketTaggingResult putBucketTagging(PutBucketTaggingRequest request) {
        request = (PutBucketTaggingRequest)this.beforeClientExecution(request);
        return this.executePutBucketTagging(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutBucketTaggingResult executePutBucketTagging(PutBucketTaggingRequest putBucketTaggingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putBucketTaggingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutBucketTaggingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                String bucket = putBucketTaggingRequest.getBucket();
                Arn arn = null;
                if (bucket != null && bucket.startsWith("arn:")) {
                    arn = Arn.fromString((String)bucket);
                    S3Resource awsResource = S3ControlArnConverter.getInstance().convertArn(arn);
                    if (!(awsResource instanceof S3ControlBucketResource)) {
                        throw new IllegalArgumentException("Unsupported ARN type: " + awsResource.getClass() + ". Expected com.amazonaws.services.s3control.internal.S3ControlBucketResource.");
                    }
                    S3ControlBucketResource resource = (S3ControlBucketResource)awsResource;
                    putBucketTaggingRequest = putBucketTaggingRequest.clone();
                    putBucketTaggingRequest.setBucket(resource.getBucketName());
                    String accountId = putBucketTaggingRequest.getAccountId();
                    String accountIdInArn = resource.getAccountId();
                    if (accountId != null && !accountId.equals(accountIdInArn)) {
                        throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                    }
                    putBucketTaggingRequest.setAccountId(accountIdInArn);
                }
                request = new PutBucketTaggingRequestMarshaller().marshall((PutBucketTaggingRequest)super.beforeMarshalling((AmazonWebServiceRequest)putBucketTaggingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutBucketTagging");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
                request.addHandlerContext(S3ControlHandlerContextKey.S3_ARNABLE_FIELD, (Object)new S3ArnableField().withArn(arn));
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)putBucketTaggingRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)putBucketTaggingRequest.getAccountId(), (String)"AccountId", (String)"putBucketTaggingRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", putBucketTaggingRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<PutBucketTaggingResult> responseHandler = new S3ControlStaxResponseHandler<PutBucketTaggingResult>(new PutBucketTaggingResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            PutBucketTaggingResult putBucketTaggingResult = (PutBucketTaggingResult)response.getAwsResponse();
            return putBucketTaggingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutJobTaggingResult putJobTagging(PutJobTaggingRequest request) {
        request = (PutJobTaggingRequest)this.beforeClientExecution(request);
        return this.executePutJobTagging(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutJobTaggingResult executePutJobTagging(PutJobTaggingRequest putJobTaggingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putJobTaggingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutJobTaggingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutJobTaggingRequestMarshaller().marshall((PutJobTaggingRequest)super.beforeMarshalling((AmazonWebServiceRequest)putJobTaggingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutJobTagging");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)putJobTaggingRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)putJobTaggingRequest.getAccountId(), (String)"AccountId", (String)"putJobTaggingRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", putJobTaggingRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<PutJobTaggingResult> responseHandler = new S3ControlStaxResponseHandler<PutJobTaggingResult>(new PutJobTaggingResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            PutJobTaggingResult putJobTaggingResult = (PutJobTaggingResult)response.getAwsResponse();
            return putJobTaggingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutPublicAccessBlockResult putPublicAccessBlock(PutPublicAccessBlockRequest request) {
        request = (PutPublicAccessBlockRequest)this.beforeClientExecution(request);
        return this.executePutPublicAccessBlock(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutPublicAccessBlockResult executePutPublicAccessBlock(PutPublicAccessBlockRequest putPublicAccessBlockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putPublicAccessBlockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutPublicAccessBlockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutPublicAccessBlockRequestMarshaller().marshall((PutPublicAccessBlockRequest)super.beforeMarshalling((AmazonWebServiceRequest)putPublicAccessBlockRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutPublicAccessBlock");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)putPublicAccessBlockRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)putPublicAccessBlockRequest.getAccountId(), (String)"AccountId", (String)"putPublicAccessBlockRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", putPublicAccessBlockRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<PutPublicAccessBlockResult> responseHandler = new S3ControlStaxResponseHandler<PutPublicAccessBlockResult>(new PutPublicAccessBlockResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            PutPublicAccessBlockResult putPublicAccessBlockResult = (PutPublicAccessBlockResult)response.getAwsResponse();
            return putPublicAccessBlockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutStorageLensConfigurationResult putStorageLensConfiguration(PutStorageLensConfigurationRequest request) {
        request = (PutStorageLensConfigurationRequest)this.beforeClientExecution(request);
        return this.executePutStorageLensConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutStorageLensConfigurationResult executePutStorageLensConfiguration(PutStorageLensConfigurationRequest putStorageLensConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putStorageLensConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutStorageLensConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutStorageLensConfigurationRequestMarshaller().marshall((PutStorageLensConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)putStorageLensConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutStorageLensConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)putStorageLensConfigurationRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)putStorageLensConfigurationRequest.getAccountId(), (String)"AccountId", (String)"putStorageLensConfigurationRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", putStorageLensConfigurationRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<PutStorageLensConfigurationResult> responseHandler = new S3ControlStaxResponseHandler<PutStorageLensConfigurationResult>(new PutStorageLensConfigurationResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            PutStorageLensConfigurationResult putStorageLensConfigurationResult = (PutStorageLensConfigurationResult)response.getAwsResponse();
            return putStorageLensConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutStorageLensConfigurationTaggingResult putStorageLensConfigurationTagging(PutStorageLensConfigurationTaggingRequest request) {
        request = (PutStorageLensConfigurationTaggingRequest)this.beforeClientExecution(request);
        return this.executePutStorageLensConfigurationTagging(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutStorageLensConfigurationTaggingResult executePutStorageLensConfigurationTagging(PutStorageLensConfigurationTaggingRequest putStorageLensConfigurationTaggingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putStorageLensConfigurationTaggingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutStorageLensConfigurationTaggingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutStorageLensConfigurationTaggingRequestMarshaller().marshall((PutStorageLensConfigurationTaggingRequest)super.beforeMarshalling((AmazonWebServiceRequest)putStorageLensConfigurationTaggingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutStorageLensConfigurationTagging");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)putStorageLensConfigurationTaggingRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)putStorageLensConfigurationTaggingRequest.getAccountId(), (String)"AccountId", (String)"putStorageLensConfigurationTaggingRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", putStorageLensConfigurationTaggingRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<PutStorageLensConfigurationTaggingResult> responseHandler = new S3ControlStaxResponseHandler<PutStorageLensConfigurationTaggingResult>(new PutStorageLensConfigurationTaggingResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            PutStorageLensConfigurationTaggingResult putStorageLensConfigurationTaggingResult = (PutStorageLensConfigurationTaggingResult)response.getAwsResponse();
            return putStorageLensConfigurationTaggingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateJobPriorityResult updateJobPriority(UpdateJobPriorityRequest request) {
        request = (UpdateJobPriorityRequest)this.beforeClientExecution(request);
        return this.executeUpdateJobPriority(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateJobPriorityResult executeUpdateJobPriority(UpdateJobPriorityRequest updateJobPriorityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateJobPriorityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateJobPriorityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateJobPriorityRequestMarshaller().marshall((UpdateJobPriorityRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateJobPriorityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateJobPriority");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)updateJobPriorityRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)updateJobPriorityRequest.getAccountId(), (String)"AccountId", (String)"updateJobPriorityRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", updateJobPriorityRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<UpdateJobPriorityResult> responseHandler = new S3ControlStaxResponseHandler<UpdateJobPriorityResult>(new UpdateJobPriorityResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            UpdateJobPriorityResult updateJobPriorityResult = (UpdateJobPriorityResult)response.getAwsResponse();
            return updateJobPriorityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateJobStatusResult updateJobStatus(UpdateJobStatusRequest request) {
        request = (UpdateJobStatusRequest)this.beforeClientExecution(request);
        return this.executeUpdateJobStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateJobStatusResult executeUpdateJobStatus(UpdateJobStatusRequest updateJobStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateJobStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateJobStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateJobStatusRequestMarshaller().marshall((UpdateJobStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateJobStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateJobStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                ValidationUtils.assertStringNotEmpty((String)updateJobStatusRequest.getAccountId(), (String)"AccountId");
                HostnameValidator.validateHostnameCompliant((String)updateJobStatusRequest.getAccountId(), (String)"AccountId", (String)"updateJobStatusRequest");
                String hostPrefix = "{AccountId}.";
                String resolvedHostPrefix = String.format("%s.", updateJobStatusRequest.getAccountId());
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            S3ControlStaxResponseHandler<UpdateJobStatusResult> responseHandler = new S3ControlStaxResponseHandler<UpdateJobStatusResult>(new UpdateJobStatusResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext, null, endpointTraitHost);
            UpdateJobStatusResult updateJobStatusResult = (UpdateJobStatusResult)response.getAwsResponse();
            return updateJobStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public S3ControlResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        ResponseMetadata metadata = this.client.getResponseMetadataForRequest(request);
        if (metadata != null) {
            return new S3ControlResponseMetadata(metadata);
        }
        return null;
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

