/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53resolver.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.route53resolver.model.Protocol;
import com.amazonaws.services.route53resolver.model.transform.TargetAddressMarshaller;
import java.io.Serializable;

public class TargetAddress
implements Serializable,
Cloneable,
StructuredPojo {
    private String ip;
    private Integer port;
    private String ipv6;
    private String protocol;

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getIp() {
        return this.ip;
    }

    public TargetAddress withIp(String ip) {
        this.setIp(ip);
        return this;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getPort() {
        return this.port;
    }

    public TargetAddress withPort(Integer port) {
        this.setPort(port);
        return this;
    }

    public void setIpv6(String ipv6) {
        this.ipv6 = ipv6;
    }

    public String getIpv6() {
        return this.ipv6;
    }

    public TargetAddress withIpv6(String ipv6) {
        this.setIpv6(ipv6);
        return this;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public TargetAddress withProtocol(String protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public TargetAddress withProtocol(Protocol protocol) {
        this.protocol = protocol.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIp() != null) {
            sb.append("Ip: ").append(this.getIp()).append(",");
        }
        if (this.getPort() != null) {
            sb.append("Port: ").append(this.getPort()).append(",");
        }
        if (this.getIpv6() != null) {
            sb.append("Ipv6: ").append(this.getIpv6()).append(",");
        }
        if (this.getProtocol() != null) {
            sb.append("Protocol: ").append(this.getProtocol());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetAddress)) {
            return false;
        }
        TargetAddress other = (TargetAddress)obj;
        if (other.getIp() == null ^ this.getIp() == null) {
            return false;
        }
        if (other.getIp() != null && !other.getIp().equals(this.getIp())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getIpv6() == null ^ this.getIpv6() == null) {
            return false;
        }
        if (other.getIpv6() != null && !other.getIpv6().equals(this.getIpv6())) {
            return false;
        }
        if (other.getProtocol() == null ^ this.getProtocol() == null) {
            return false;
        }
        return other.getProtocol() == null || other.getProtocol().equals(this.getProtocol());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIp() == null ? 0 : this.getIp().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getIpv6() == null ? 0 : this.getIpv6().hashCode());
        hashCode = 31 * hashCode + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        return hashCode;
    }

    public TargetAddress clone() {
        try {
            return (TargetAddress)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TargetAddressMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

