/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53recoverycluster;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.route53recoverycluster.AWSRoute53RecoveryCluster;
import com.amazonaws.services.route53recoverycluster.AWSRoute53RecoveryClusterClientBuilder;
import com.amazonaws.services.route53recoverycluster.model.AWSRoute53RecoveryClusterException;
import com.amazonaws.services.route53recoverycluster.model.GetRoutingControlStateRequest;
import com.amazonaws.services.route53recoverycluster.model.GetRoutingControlStateResult;
import com.amazonaws.services.route53recoverycluster.model.ListRoutingControlsRequest;
import com.amazonaws.services.route53recoverycluster.model.ListRoutingControlsResult;
import com.amazonaws.services.route53recoverycluster.model.UpdateRoutingControlStateRequest;
import com.amazonaws.services.route53recoverycluster.model.UpdateRoutingControlStateResult;
import com.amazonaws.services.route53recoverycluster.model.UpdateRoutingControlStatesRequest;
import com.amazonaws.services.route53recoverycluster.model.UpdateRoutingControlStatesResult;
import com.amazonaws.services.route53recoverycluster.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.EndpointTemporarilyUnavailableExceptionUnmarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.GetRoutingControlStateRequestProtocolMarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.GetRoutingControlStateResultJsonUnmarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.ListRoutingControlsRequestProtocolMarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.ListRoutingControlsResultJsonUnmarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.ServiceLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.UpdateRoutingControlStateRequestProtocolMarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.UpdateRoutingControlStateResultJsonUnmarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.UpdateRoutingControlStatesRequestProtocolMarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.UpdateRoutingControlStatesResultJsonUnmarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSRoute53RecoveryClusterClient
extends AmazonWebServiceClient
implements AWSRoute53RecoveryCluster {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSRoute53RecoveryCluster.class);
    private static final String DEFAULT_SIGNING_NAME = "route53-recovery-cluster";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceLimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceLimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EndpointTemporarilyUnavailableException").withExceptionUnmarshaller((JsonErrorUnmarshaller)EndpointTemporarilyUnavailableExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSRoute53RecoveryClusterException.class));

    public static AWSRoute53RecoveryClusterClientBuilder builder() {
        return AWSRoute53RecoveryClusterClientBuilder.standard();
    }

    AWSRoute53RecoveryClusterClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSRoute53RecoveryClusterClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("route53-recovery-cluster.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/route53recoverycluster/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/route53recoverycluster/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public GetRoutingControlStateResult getRoutingControlState(GetRoutingControlStateRequest request) {
        request = (GetRoutingControlStateRequest)this.beforeClientExecution(request);
        return this.executeGetRoutingControlState(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetRoutingControlStateResult executeGetRoutingControlState(GetRoutingControlStateRequest getRoutingControlStateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRoutingControlStateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRoutingControlStateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRoutingControlStateRequestProtocolMarshaller(protocolFactory).marshall((GetRoutingControlStateRequest)super.beforeMarshalling((AmazonWebServiceRequest)getRoutingControlStateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Route53 Recovery Cluster");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetRoutingControlState");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetRoutingControlStateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRoutingControlStateResult getRoutingControlStateResult = (GetRoutingControlStateResult)response.getAwsResponse();
            return getRoutingControlStateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRoutingControlsResult listRoutingControls(ListRoutingControlsRequest request) {
        request = (ListRoutingControlsRequest)this.beforeClientExecution(request);
        return this.executeListRoutingControls(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRoutingControlsResult executeListRoutingControls(ListRoutingControlsRequest listRoutingControlsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRoutingControlsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRoutingControlsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRoutingControlsRequestProtocolMarshaller(protocolFactory).marshall((ListRoutingControlsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRoutingControlsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Route53 Recovery Cluster");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListRoutingControls");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRoutingControlsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRoutingControlsResult listRoutingControlsResult = (ListRoutingControlsResult)response.getAwsResponse();
            return listRoutingControlsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateRoutingControlStateResult updateRoutingControlState(UpdateRoutingControlStateRequest request) {
        request = (UpdateRoutingControlStateRequest)this.beforeClientExecution(request);
        return this.executeUpdateRoutingControlState(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateRoutingControlStateResult executeUpdateRoutingControlState(UpdateRoutingControlStateRequest updateRoutingControlStateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRoutingControlStateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRoutingControlStateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRoutingControlStateRequestProtocolMarshaller(protocolFactory).marshall((UpdateRoutingControlStateRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateRoutingControlStateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Route53 Recovery Cluster");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateRoutingControlState");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateRoutingControlStateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateRoutingControlStateResult updateRoutingControlStateResult = (UpdateRoutingControlStateResult)response.getAwsResponse();
            return updateRoutingControlStateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateRoutingControlStatesResult updateRoutingControlStates(UpdateRoutingControlStatesRequest request) {
        request = (UpdateRoutingControlStatesRequest)this.beforeClientExecution(request);
        return this.executeUpdateRoutingControlStates(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateRoutingControlStatesResult executeUpdateRoutingControlStates(UpdateRoutingControlStatesRequest updateRoutingControlStatesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRoutingControlStatesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRoutingControlStatesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRoutingControlStatesRequestProtocolMarshaller(protocolFactory).marshall((UpdateRoutingControlStatesRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateRoutingControlStatesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Route53 Recovery Cluster");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateRoutingControlStates");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateRoutingControlStatesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateRoutingControlStatesResult updateRoutingControlStatesResult = (UpdateRoutingControlStatesResult)response.getAwsResponse();
            return updateRoutingControlStatesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

