/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53recoverycluster.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.route53recoverycluster.model.RoutingControlState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateRoutingControlStateRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String routingControlArn;
    private String routingControlState;
    private List<String> safetyRulesToOverride;

    public void setRoutingControlArn(String routingControlArn) {
        this.routingControlArn = routingControlArn;
    }

    public String getRoutingControlArn() {
        return this.routingControlArn;
    }

    public UpdateRoutingControlStateRequest withRoutingControlArn(String routingControlArn) {
        this.setRoutingControlArn(routingControlArn);
        return this;
    }

    public void setRoutingControlState(String routingControlState) {
        this.routingControlState = routingControlState;
    }

    public String getRoutingControlState() {
        return this.routingControlState;
    }

    public UpdateRoutingControlStateRequest withRoutingControlState(String routingControlState) {
        this.setRoutingControlState(routingControlState);
        return this;
    }

    public UpdateRoutingControlStateRequest withRoutingControlState(RoutingControlState routingControlState) {
        this.routingControlState = routingControlState.toString();
        return this;
    }

    public List<String> getSafetyRulesToOverride() {
        return this.safetyRulesToOverride;
    }

    public void setSafetyRulesToOverride(Collection<String> safetyRulesToOverride) {
        if (safetyRulesToOverride == null) {
            this.safetyRulesToOverride = null;
            return;
        }
        this.safetyRulesToOverride = new ArrayList<String>(safetyRulesToOverride);
    }

    public UpdateRoutingControlStateRequest withSafetyRulesToOverride(String ... safetyRulesToOverride) {
        if (this.safetyRulesToOverride == null) {
            this.setSafetyRulesToOverride(new ArrayList<String>(safetyRulesToOverride.length));
        }
        for (String ele : safetyRulesToOverride) {
            this.safetyRulesToOverride.add(ele);
        }
        return this;
    }

    public UpdateRoutingControlStateRequest withSafetyRulesToOverride(Collection<String> safetyRulesToOverride) {
        this.setSafetyRulesToOverride(safetyRulesToOverride);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRoutingControlArn() != null) {
            sb.append("RoutingControlArn: ").append(this.getRoutingControlArn()).append(",");
        }
        if (this.getRoutingControlState() != null) {
            sb.append("RoutingControlState: ").append(this.getRoutingControlState()).append(",");
        }
        if (this.getSafetyRulesToOverride() != null) {
            sb.append("SafetyRulesToOverride: ").append(this.getSafetyRulesToOverride());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRoutingControlStateRequest)) {
            return false;
        }
        UpdateRoutingControlStateRequest other = (UpdateRoutingControlStateRequest)obj;
        if (other.getRoutingControlArn() == null ^ this.getRoutingControlArn() == null) {
            return false;
        }
        if (other.getRoutingControlArn() != null && !other.getRoutingControlArn().equals(this.getRoutingControlArn())) {
            return false;
        }
        if (other.getRoutingControlState() == null ^ this.getRoutingControlState() == null) {
            return false;
        }
        if (other.getRoutingControlState() != null && !other.getRoutingControlState().equals(this.getRoutingControlState())) {
            return false;
        }
        if (other.getSafetyRulesToOverride() == null ^ this.getSafetyRulesToOverride() == null) {
            return false;
        }
        return other.getSafetyRulesToOverride() == null || other.getSafetyRulesToOverride().equals(this.getSafetyRulesToOverride());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRoutingControlArn() == null ? 0 : this.getRoutingControlArn().hashCode());
        hashCode = 31 * hashCode + (this.getRoutingControlState() == null ? 0 : this.getRoutingControlState().hashCode());
        hashCode = 31 * hashCode + (this.getSafetyRulesToOverride() == null ? 0 : this.getSafetyRulesToOverride().hashCode());
        return hashCode;
    }

    public UpdateRoutingControlStateRequest clone() {
        return (UpdateRoutingControlStateRequest)super.clone();
    }
}

