/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.ListCidrBlocksRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class ListCidrBlocksRequestMarshaller
implements Marshaller<Request<ListCidrBlocksRequest>, ListCidrBlocksRequest> {
    public Request<ListCidrBlocksRequest> marshall(ListCidrBlocksRequest listCidrBlocksRequest) {
        if (listCidrBlocksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listCidrBlocksRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/cidrcollection/{CidrCollectionId}/cidrblocks";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "CidrCollectionId", listCidrBlocksRequest.getCollectionId());
        request.setResourcePath(uriResourcePath);
        if (listCidrBlocksRequest.getLocationName() != null) {
            request.addParameter("location", StringUtils.fromString((String)listCidrBlocksRequest.getLocationName()));
        }
        if (listCidrBlocksRequest.getNextToken() != null) {
            request.addParameter("nexttoken", StringUtils.fromString((String)listCidrBlocksRequest.getNextToken()));
        }
        if (listCidrBlocksRequest.getMaxResults() != null) {
            request.addParameter("maxresults", StringUtils.fromString((String)listCidrBlocksRequest.getMaxResults()));
        }
        return request;
    }
}

