/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.route53domains.model.Nameserver;
import com.amazonaws.services.route53domains.model.TransferDomainRequest;
import com.amazonaws.services.route53domains.model.transform.ContactDetailJsonMarshaller;
import com.amazonaws.services.route53domains.model.transform.NameserverJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class TransferDomainRequestMarshaller
implements Marshaller<Request<TransferDomainRequest>, TransferDomainRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public TransferDomainRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<TransferDomainRequest> marshall(TransferDomainRequest transferDomainRequest) {
        if (transferDomainRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)transferDomainRequest, "AmazonRoute53Domains");
        request.addHeader("X-Amz-Target", "Route53Domains_v20140515.TransferDomain");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList nameserversList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (transferDomainRequest.getDomainName() != null) {
                jsonGenerator.writeFieldName("DomainName").writeValue(transferDomainRequest.getDomainName());
            }
            if (transferDomainRequest.getIdnLangCode() != null) {
                jsonGenerator.writeFieldName("IdnLangCode").writeValue(transferDomainRequest.getIdnLangCode());
            }
            if (transferDomainRequest.getDurationInYears() != null) {
                jsonGenerator.writeFieldName("DurationInYears").writeValue(transferDomainRequest.getDurationInYears().intValue());
            }
            if (!(nameserversList = (SdkInternalList)transferDomainRequest.getNameservers()).isEmpty() || !nameserversList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Nameservers");
                jsonGenerator.writeStartArray();
                for (Nameserver nameserversListValue : nameserversList) {
                    if (nameserversListValue == null) continue;
                    NameserverJsonMarshaller.getInstance().marshall(nameserversListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (transferDomainRequest.getAuthCode() != null) {
                jsonGenerator.writeFieldName("AuthCode").writeValue(transferDomainRequest.getAuthCode());
            }
            if (transferDomainRequest.getAutoRenew() != null) {
                jsonGenerator.writeFieldName("AutoRenew").writeValue(transferDomainRequest.getAutoRenew().booleanValue());
            }
            if (transferDomainRequest.getAdminContact() != null) {
                jsonGenerator.writeFieldName("AdminContact");
                ContactDetailJsonMarshaller.getInstance().marshall(transferDomainRequest.getAdminContact(), jsonGenerator);
            }
            if (transferDomainRequest.getRegistrantContact() != null) {
                jsonGenerator.writeFieldName("RegistrantContact");
                ContactDetailJsonMarshaller.getInstance().marshall(transferDomainRequest.getRegistrantContact(), jsonGenerator);
            }
            if (transferDomainRequest.getTechContact() != null) {
                jsonGenerator.writeFieldName("TechContact");
                ContactDetailJsonMarshaller.getInstance().marshall(transferDomainRequest.getTechContact(), jsonGenerator);
            }
            if (transferDomainRequest.getPrivacyProtectAdminContact() != null) {
                jsonGenerator.writeFieldName("PrivacyProtectAdminContact").writeValue(transferDomainRequest.getPrivacyProtectAdminContact().booleanValue());
            }
            if (transferDomainRequest.getPrivacyProtectRegistrantContact() != null) {
                jsonGenerator.writeFieldName("PrivacyProtectRegistrantContact").writeValue(transferDomainRequest.getPrivacyProtectRegistrantContact().booleanValue());
            }
            if (transferDomainRequest.getPrivacyProtectTechContact() != null) {
                jsonGenerator.writeFieldName("PrivacyProtectTechContact").writeValue(transferDomainRequest.getPrivacyProtectTechContact().booleanValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

