/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.route53.model.DelegationSet;
import com.amazonaws.services.route53.model.HostedZone;
import com.amazonaws.services.route53.model.VPC;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetHostedZoneResult
implements Serializable,
Cloneable {
    private HostedZone hostedZone;
    private DelegationSet delegationSet;
    private ListWithAutoConstructFlag<VPC> vPCs;

    public HostedZone getHostedZone() {
        return this.hostedZone;
    }

    public void setHostedZone(HostedZone hostedZone) {
        this.hostedZone = hostedZone;
    }

    public GetHostedZoneResult withHostedZone(HostedZone hostedZone) {
        this.hostedZone = hostedZone;
        return this;
    }

    public DelegationSet getDelegationSet() {
        return this.delegationSet;
    }

    public void setDelegationSet(DelegationSet delegationSet) {
        this.delegationSet = delegationSet;
    }

    public GetHostedZoneResult withDelegationSet(DelegationSet delegationSet) {
        this.delegationSet = delegationSet;
        return this;
    }

    public List<VPC> getVPCs() {
        if (this.vPCs == null) {
            this.vPCs = new ListWithAutoConstructFlag();
            this.vPCs.setAutoConstruct(true);
        }
        return this.vPCs;
    }

    public void setVPCs(Collection<VPC> vPCs) {
        if (vPCs == null) {
            this.vPCs = null;
            return;
        }
        ListWithAutoConstructFlag vPCsCopy = new ListWithAutoConstructFlag(vPCs.size());
        vPCsCopy.addAll(vPCs);
        this.vPCs = vPCsCopy;
    }

    public GetHostedZoneResult withVPCs(VPC ... vPCs) {
        if (this.getVPCs() == null) {
            this.setVPCs(new ArrayList<VPC>(vPCs.length));
        }
        for (VPC value : vPCs) {
            this.getVPCs().add(value);
        }
        return this;
    }

    public GetHostedZoneResult withVPCs(Collection<VPC> vPCs) {
        if (vPCs == null) {
            this.vPCs = null;
        } else {
            ListWithAutoConstructFlag vPCsCopy = new ListWithAutoConstructFlag(vPCs.size());
            vPCsCopy.addAll(vPCs);
            this.vPCs = vPCsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHostedZone() != null) {
            sb.append("HostedZone: " + this.getHostedZone() + ",");
        }
        if (this.getDelegationSet() != null) {
            sb.append("DelegationSet: " + this.getDelegationSet() + ",");
        }
        if (this.getVPCs() != null) {
            sb.append("VPCs: " + this.getVPCs());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHostedZone() == null ? 0 : this.getHostedZone().hashCode());
        hashCode = 31 * hashCode + (this.getDelegationSet() == null ? 0 : this.getDelegationSet().hashCode());
        hashCode = 31 * hashCode + (this.getVPCs() == null ? 0 : this.getVPCs().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostedZoneResult)) {
            return false;
        }
        GetHostedZoneResult other = (GetHostedZoneResult)obj;
        if (other.getHostedZone() == null ^ this.getHostedZone() == null) {
            return false;
        }
        if (other.getHostedZone() != null && !other.getHostedZone().equals(this.getHostedZone())) {
            return false;
        }
        if (other.getDelegationSet() == null ^ this.getDelegationSet() == null) {
            return false;
        }
        if (other.getDelegationSet() != null && !other.getDelegationSet().equals(this.getDelegationSet())) {
            return false;
        }
        if (other.getVPCs() == null ^ this.getVPCs() == null) {
            return false;
        }
        return other.getVPCs() == null || other.getVPCs().equals(this.getVPCs());
    }

    public GetHostedZoneResult clone() {
        try {
            return (GetHostedZoneResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

