/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.ListHostedZonesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListHostedZonesRequestMarshaller
implements Marshaller<Request<ListHostedZonesRequest>, ListHostedZonesRequest> {
    public Request<ListHostedZonesRequest> marshall(ListHostedZonesRequest listHostedZonesRequest) {
        String delegationSetId;
        String maxItems;
        String marker;
        if (listHostedZonesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listHostedZonesRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/hostedzone";
        request.setResourcePath(uriResourcePath);
        String string = marker = listHostedZonesRequest.getMarker() == null ? null : StringUtils.fromString((String)listHostedZonesRequest.getMarker());
        if (marker != null) {
            request.addParameter("marker", marker);
        }
        String string2 = maxItems = listHostedZonesRequest.getMaxItems() == null ? null : StringUtils.fromString((String)listHostedZonesRequest.getMaxItems());
        if (maxItems != null) {
            request.addParameter("maxitems", maxItems);
        }
        String string3 = delegationSetId = listHostedZonesRequest.getDelegationSetId() == null ? null : StringUtils.fromString((String)listHostedZonesRequest.getDelegationSetId());
        if (delegationSetId != null) {
            request.addParameter("delegationsetid", delegationSetId);
        }
        return request;
    }
}

