/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.route53domains.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateTagsForDomainRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String domainName;
    private ListWithAutoConstructFlag<Tag> tagsToUpdate;

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public UpdateTagsForDomainRequest withDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    public List<Tag> getTagsToUpdate() {
        if (this.tagsToUpdate == null) {
            this.tagsToUpdate = new ListWithAutoConstructFlag();
            this.tagsToUpdate.setAutoConstruct(true);
        }
        return this.tagsToUpdate;
    }

    public void setTagsToUpdate(Collection<Tag> tagsToUpdate) {
        if (tagsToUpdate == null) {
            this.tagsToUpdate = null;
            return;
        }
        ListWithAutoConstructFlag tagsToUpdateCopy = new ListWithAutoConstructFlag(tagsToUpdate.size());
        tagsToUpdateCopy.addAll(tagsToUpdate);
        this.tagsToUpdate = tagsToUpdateCopy;
    }

    public UpdateTagsForDomainRequest withTagsToUpdate(Tag ... tagsToUpdate) {
        if (this.getTagsToUpdate() == null) {
            this.setTagsToUpdate(new ArrayList<Tag>(tagsToUpdate.length));
        }
        for (Tag value : tagsToUpdate) {
            this.getTagsToUpdate().add(value);
        }
        return this;
    }

    public UpdateTagsForDomainRequest withTagsToUpdate(Collection<Tag> tagsToUpdate) {
        if (tagsToUpdate == null) {
            this.tagsToUpdate = null;
        } else {
            ListWithAutoConstructFlag tagsToUpdateCopy = new ListWithAutoConstructFlag(tagsToUpdate.size());
            tagsToUpdateCopy.addAll(tagsToUpdate);
            this.tagsToUpdate = tagsToUpdateCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainName() != null) {
            sb.append("DomainName: " + this.getDomainName() + ",");
        }
        if (this.getTagsToUpdate() != null) {
            sb.append("TagsToUpdate: " + this.getTagsToUpdate());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getTagsToUpdate() == null ? 0 : this.getTagsToUpdate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTagsForDomainRequest)) {
            return false;
        }
        UpdateTagsForDomainRequest other = (UpdateTagsForDomainRequest)obj;
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (other.getDomainName() != null && !other.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (other.getTagsToUpdate() == null ^ this.getTagsToUpdate() == null) {
            return false;
        }
        return other.getTagsToUpdate() == null || other.getTagsToUpdate().equals(this.getTagsToUpdate());
    }

    public UpdateTagsForDomainRequest clone() {
        return (UpdateTagsForDomainRequest)super.clone();
    }
}

