/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.ListGeoLocationsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ListGeoLocationsRequestMarshaller
implements Marshaller<Request<ListGeoLocationsRequest>, ListGeoLocationsRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    public Request<ListGeoLocationsRequest> marshall(ListGeoLocationsRequest listGeoLocationsRequest) {
        String value;
        String name;
        if (listGeoLocationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listGeoLocationsRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("StartContinentCode")) {
            name = DYNAMIC_QUERY_PARAMS.get("StartContinentCode");
            String string = value = listGeoLocationsRequest.getStartContinentCode() == null ? null : StringUtils.fromString((String)listGeoLocationsRequest.getStartContinentCode());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{StartContinentCode}", listGeoLocationsRequest.getStartContinentCode() == null ? "" : StringUtils.fromString((String)listGeoLocationsRequest.getStartContinentCode()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("StartCountryCode")) {
            name = DYNAMIC_QUERY_PARAMS.get("StartCountryCode");
            String string = value = listGeoLocationsRequest.getStartCountryCode() == null ? null : StringUtils.fromString((String)listGeoLocationsRequest.getStartCountryCode());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{StartCountryCode}", listGeoLocationsRequest.getStartCountryCode() == null ? "" : StringUtils.fromString((String)listGeoLocationsRequest.getStartCountryCode()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("StartSubdivisionCode")) {
            name = DYNAMIC_QUERY_PARAMS.get("StartSubdivisionCode");
            String string = value = listGeoLocationsRequest.getStartSubdivisionCode() == null ? null : StringUtils.fromString((String)listGeoLocationsRequest.getStartSubdivisionCode());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{StartSubdivisionCode}", listGeoLocationsRequest.getStartSubdivisionCode() == null ? "" : StringUtils.fromString((String)listGeoLocationsRequest.getStartSubdivisionCode()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("MaxItems")) {
            name = DYNAMIC_QUERY_PARAMS.get("MaxItems");
            String string = value = listGeoLocationsRequest.getMaxItems() == null ? null : StringUtils.fromString((String)listGeoLocationsRequest.getMaxItems());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{MaxItems}", listGeoLocationsRequest.getMaxItems() == null ? "" : StringUtils.fromString((String)listGeoLocationsRequest.getMaxItems()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        return request;
    }

    static {
        String path = "/2013-04-01/geolocations?startcontinentcode={StartContinentCode}&startcountrycode={StartCountryCode}&startsubdivisioncode={StartSubdivisionCode}&maxitems={MaxItems}";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

