/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.robomaker.model.Environment;
import com.amazonaws.services.robomaker.model.RobotSoftwareSuite;
import com.amazonaws.services.robomaker.model.SourceConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateRobotApplicationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private List<SourceConfig> sources;
    private RobotSoftwareSuite robotSoftwareSuite;
    private Map<String, String> tags;
    private Environment environment;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateRobotApplicationRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public List<SourceConfig> getSources() {
        return this.sources;
    }

    public void setSources(Collection<SourceConfig> sources) {
        if (sources == null) {
            this.sources = null;
            return;
        }
        this.sources = new ArrayList<SourceConfig>(sources);
    }

    public CreateRobotApplicationRequest withSources(SourceConfig ... sources) {
        if (this.sources == null) {
            this.setSources(new ArrayList<SourceConfig>(sources.length));
        }
        for (SourceConfig ele : sources) {
            this.sources.add(ele);
        }
        return this;
    }

    public CreateRobotApplicationRequest withSources(Collection<SourceConfig> sources) {
        this.setSources(sources);
        return this;
    }

    public void setRobotSoftwareSuite(RobotSoftwareSuite robotSoftwareSuite) {
        this.robotSoftwareSuite = robotSoftwareSuite;
    }

    public RobotSoftwareSuite getRobotSoftwareSuite() {
        return this.robotSoftwareSuite;
    }

    public CreateRobotApplicationRequest withRobotSoftwareSuite(RobotSoftwareSuite robotSoftwareSuite) {
        this.setRobotSoftwareSuite(robotSoftwareSuite);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateRobotApplicationRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateRobotApplicationRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateRobotApplicationRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public CreateRobotApplicationRequest withEnvironment(Environment environment) {
        this.setEnvironment(environment);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getSources() != null) {
            sb.append("Sources: ").append(this.getSources()).append(",");
        }
        if (this.getRobotSoftwareSuite() != null) {
            sb.append("RobotSoftwareSuite: ").append(this.getRobotSoftwareSuite()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: ").append(this.getEnvironment());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRobotApplicationRequest)) {
            return false;
        }
        CreateRobotApplicationRequest other = (CreateRobotApplicationRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getSources() == null ^ this.getSources() == null) {
            return false;
        }
        if (other.getSources() != null && !other.getSources().equals(this.getSources())) {
            return false;
        }
        if (other.getRobotSoftwareSuite() == null ^ this.getRobotSoftwareSuite() == null) {
            return false;
        }
        if (other.getRobotSoftwareSuite() != null && !other.getRobotSoftwareSuite().equals(this.getRobotSoftwareSuite())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        return other.getEnvironment() == null || other.getEnvironment().equals(this.getEnvironment());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getSources() == null ? 0 : this.getSources().hashCode());
        hashCode = 31 * hashCode + (this.getRobotSoftwareSuite() == null ? 0 : this.getRobotSoftwareSuite().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        return hashCode;
    }

    public CreateRobotApplicationRequest clone() {
        return (CreateRobotApplicationRequest)super.clone();
    }
}

