/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.robomaker.model.DataSource;
import java.util.List;

@SdkInternalApi
public class DataSourceMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> S3BUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Bucket").build();
    private static final MarshallingInfo<List> S3KEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Keys").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<String> DESTINATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destination").build();
    private static final DataSourceMarshaller instance = new DataSourceMarshaller();

    public static DataSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataSource dataSource, ProtocolMarshaller protocolMarshaller) {
        if (dataSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataSource.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)dataSource.getS3Bucket(), S3BUCKET_BINDING);
            protocolMarshaller.marshall(dataSource.getS3Keys(), S3KEYS_BINDING);
            protocolMarshaller.marshall((Object)dataSource.getType(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)dataSource.getDestination(), DESTINATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

