/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.robomaker.model.DataSourceConfig;
import com.amazonaws.services.robomaker.model.FailureBehavior;
import com.amazonaws.services.robomaker.model.LoggingConfig;
import com.amazonaws.services.robomaker.model.OutputLocation;
import com.amazonaws.services.robomaker.model.RobotApplicationConfig;
import com.amazonaws.services.robomaker.model.SimulationApplicationConfig;
import com.amazonaws.services.robomaker.model.VPCConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateSimulationJobRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientRequestToken;
    private OutputLocation outputLocation;
    private LoggingConfig loggingConfig;
    private Long maxJobDurationInSeconds;
    private String iamRole;
    private String failureBehavior;
    private List<RobotApplicationConfig> robotApplications;
    private List<SimulationApplicationConfig> simulationApplications;
    private List<DataSourceConfig> dataSources;
    private Map<String, String> tags;
    private VPCConfig vpcConfig;

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public CreateSimulationJobRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public void setOutputLocation(OutputLocation outputLocation) {
        this.outputLocation = outputLocation;
    }

    public OutputLocation getOutputLocation() {
        return this.outputLocation;
    }

    public CreateSimulationJobRequest withOutputLocation(OutputLocation outputLocation) {
        this.setOutputLocation(outputLocation);
        return this;
    }

    public void setLoggingConfig(LoggingConfig loggingConfig) {
        this.loggingConfig = loggingConfig;
    }

    public LoggingConfig getLoggingConfig() {
        return this.loggingConfig;
    }

    public CreateSimulationJobRequest withLoggingConfig(LoggingConfig loggingConfig) {
        this.setLoggingConfig(loggingConfig);
        return this;
    }

    public void setMaxJobDurationInSeconds(Long maxJobDurationInSeconds) {
        this.maxJobDurationInSeconds = maxJobDurationInSeconds;
    }

    public Long getMaxJobDurationInSeconds() {
        return this.maxJobDurationInSeconds;
    }

    public CreateSimulationJobRequest withMaxJobDurationInSeconds(Long maxJobDurationInSeconds) {
        this.setMaxJobDurationInSeconds(maxJobDurationInSeconds);
        return this;
    }

    public void setIamRole(String iamRole) {
        this.iamRole = iamRole;
    }

    public String getIamRole() {
        return this.iamRole;
    }

    public CreateSimulationJobRequest withIamRole(String iamRole) {
        this.setIamRole(iamRole);
        return this;
    }

    public void setFailureBehavior(String failureBehavior) {
        this.failureBehavior = failureBehavior;
    }

    public String getFailureBehavior() {
        return this.failureBehavior;
    }

    public CreateSimulationJobRequest withFailureBehavior(String failureBehavior) {
        this.setFailureBehavior(failureBehavior);
        return this;
    }

    public CreateSimulationJobRequest withFailureBehavior(FailureBehavior failureBehavior) {
        this.failureBehavior = failureBehavior.toString();
        return this;
    }

    public List<RobotApplicationConfig> getRobotApplications() {
        return this.robotApplications;
    }

    public void setRobotApplications(Collection<RobotApplicationConfig> robotApplications) {
        if (robotApplications == null) {
            this.robotApplications = null;
            return;
        }
        this.robotApplications = new ArrayList<RobotApplicationConfig>(robotApplications);
    }

    public CreateSimulationJobRequest withRobotApplications(RobotApplicationConfig ... robotApplications) {
        if (this.robotApplications == null) {
            this.setRobotApplications(new ArrayList<RobotApplicationConfig>(robotApplications.length));
        }
        for (RobotApplicationConfig ele : robotApplications) {
            this.robotApplications.add(ele);
        }
        return this;
    }

    public CreateSimulationJobRequest withRobotApplications(Collection<RobotApplicationConfig> robotApplications) {
        this.setRobotApplications(robotApplications);
        return this;
    }

    public List<SimulationApplicationConfig> getSimulationApplications() {
        return this.simulationApplications;
    }

    public void setSimulationApplications(Collection<SimulationApplicationConfig> simulationApplications) {
        if (simulationApplications == null) {
            this.simulationApplications = null;
            return;
        }
        this.simulationApplications = new ArrayList<SimulationApplicationConfig>(simulationApplications);
    }

    public CreateSimulationJobRequest withSimulationApplications(SimulationApplicationConfig ... simulationApplications) {
        if (this.simulationApplications == null) {
            this.setSimulationApplications(new ArrayList<SimulationApplicationConfig>(simulationApplications.length));
        }
        for (SimulationApplicationConfig ele : simulationApplications) {
            this.simulationApplications.add(ele);
        }
        return this;
    }

    public CreateSimulationJobRequest withSimulationApplications(Collection<SimulationApplicationConfig> simulationApplications) {
        this.setSimulationApplications(simulationApplications);
        return this;
    }

    public List<DataSourceConfig> getDataSources() {
        return this.dataSources;
    }

    public void setDataSources(Collection<DataSourceConfig> dataSources) {
        if (dataSources == null) {
            this.dataSources = null;
            return;
        }
        this.dataSources = new ArrayList<DataSourceConfig>(dataSources);
    }

    public CreateSimulationJobRequest withDataSources(DataSourceConfig ... dataSources) {
        if (this.dataSources == null) {
            this.setDataSources(new ArrayList<DataSourceConfig>(dataSources.length));
        }
        for (DataSourceConfig ele : dataSources) {
            this.dataSources.add(ele);
        }
        return this;
    }

    public CreateSimulationJobRequest withDataSources(Collection<DataSourceConfig> dataSources) {
        this.setDataSources(dataSources);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateSimulationJobRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateSimulationJobRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateSimulationJobRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setVpcConfig(VPCConfig vpcConfig) {
        this.vpcConfig = vpcConfig;
    }

    public VPCConfig getVpcConfig() {
        return this.vpcConfig;
    }

    public CreateSimulationJobRequest withVpcConfig(VPCConfig vpcConfig) {
        this.setVpcConfig(vpcConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getOutputLocation() != null) {
            sb.append("OutputLocation: ").append(this.getOutputLocation()).append(",");
        }
        if (this.getLoggingConfig() != null) {
            sb.append("LoggingConfig: ").append(this.getLoggingConfig()).append(",");
        }
        if (this.getMaxJobDurationInSeconds() != null) {
            sb.append("MaxJobDurationInSeconds: ").append(this.getMaxJobDurationInSeconds()).append(",");
        }
        if (this.getIamRole() != null) {
            sb.append("IamRole: ").append(this.getIamRole()).append(",");
        }
        if (this.getFailureBehavior() != null) {
            sb.append("FailureBehavior: ").append(this.getFailureBehavior()).append(",");
        }
        if (this.getRobotApplications() != null) {
            sb.append("RobotApplications: ").append(this.getRobotApplications()).append(",");
        }
        if (this.getSimulationApplications() != null) {
            sb.append("SimulationApplications: ").append(this.getSimulationApplications()).append(",");
        }
        if (this.getDataSources() != null) {
            sb.append("DataSources: ").append(this.getDataSources()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getVpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.getVpcConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSimulationJobRequest)) {
            return false;
        }
        CreateSimulationJobRequest other = (CreateSimulationJobRequest)obj;
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getOutputLocation() == null ^ this.getOutputLocation() == null) {
            return false;
        }
        if (other.getOutputLocation() != null && !other.getOutputLocation().equals(this.getOutputLocation())) {
            return false;
        }
        if (other.getLoggingConfig() == null ^ this.getLoggingConfig() == null) {
            return false;
        }
        if (other.getLoggingConfig() != null && !other.getLoggingConfig().equals(this.getLoggingConfig())) {
            return false;
        }
        if (other.getMaxJobDurationInSeconds() == null ^ this.getMaxJobDurationInSeconds() == null) {
            return false;
        }
        if (other.getMaxJobDurationInSeconds() != null && !other.getMaxJobDurationInSeconds().equals(this.getMaxJobDurationInSeconds())) {
            return false;
        }
        if (other.getIamRole() == null ^ this.getIamRole() == null) {
            return false;
        }
        if (other.getIamRole() != null && !other.getIamRole().equals(this.getIamRole())) {
            return false;
        }
        if (other.getFailureBehavior() == null ^ this.getFailureBehavior() == null) {
            return false;
        }
        if (other.getFailureBehavior() != null && !other.getFailureBehavior().equals(this.getFailureBehavior())) {
            return false;
        }
        if (other.getRobotApplications() == null ^ this.getRobotApplications() == null) {
            return false;
        }
        if (other.getRobotApplications() != null && !other.getRobotApplications().equals(this.getRobotApplications())) {
            return false;
        }
        if (other.getSimulationApplications() == null ^ this.getSimulationApplications() == null) {
            return false;
        }
        if (other.getSimulationApplications() != null && !other.getSimulationApplications().equals(this.getSimulationApplications())) {
            return false;
        }
        if (other.getDataSources() == null ^ this.getDataSources() == null) {
            return false;
        }
        if (other.getDataSources() != null && !other.getDataSources().equals(this.getDataSources())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getVpcConfig() == null ^ this.getVpcConfig() == null) {
            return false;
        }
        return other.getVpcConfig() == null || other.getVpcConfig().equals(this.getVpcConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getOutputLocation() == null ? 0 : this.getOutputLocation().hashCode());
        hashCode = 31 * hashCode + (this.getLoggingConfig() == null ? 0 : this.getLoggingConfig().hashCode());
        hashCode = 31 * hashCode + (this.getMaxJobDurationInSeconds() == null ? 0 : this.getMaxJobDurationInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getIamRole() == null ? 0 : this.getIamRole().hashCode());
        hashCode = 31 * hashCode + (this.getFailureBehavior() == null ? 0 : this.getFailureBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getRobotApplications() == null ? 0 : this.getRobotApplications().hashCode());
        hashCode = 31 * hashCode + (this.getSimulationApplications() == null ? 0 : this.getSimulationApplications().hashCode());
        hashCode = 31 * hashCode + (this.getDataSources() == null ? 0 : this.getDataSources().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfig() == null ? 0 : this.getVpcConfig().hashCode());
        return hashCode;
    }

    public CreateSimulationJobRequest clone() {
        return (CreateSimulationJobRequest)super.clone();
    }
}

