/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourcegroups.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.resourcegroups.model.GroupConfigurationItem;
import com.amazonaws.services.resourcegroups.model.GroupConfigurationStatus;
import com.amazonaws.services.resourcegroups.model.transform.GroupConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GroupConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<GroupConfigurationItem> configuration;
    private List<GroupConfigurationItem> proposedConfiguration;
    private String status;
    private String failureReason;

    public List<GroupConfigurationItem> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Collection<GroupConfigurationItem> configuration) {
        if (configuration == null) {
            this.configuration = null;
            return;
        }
        this.configuration = new ArrayList<GroupConfigurationItem>(configuration);
    }

    public GroupConfiguration withConfiguration(GroupConfigurationItem ... configuration) {
        if (this.configuration == null) {
            this.setConfiguration(new ArrayList<GroupConfigurationItem>(configuration.length));
        }
        for (GroupConfigurationItem ele : configuration) {
            this.configuration.add(ele);
        }
        return this;
    }

    public GroupConfiguration withConfiguration(Collection<GroupConfigurationItem> configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public List<GroupConfigurationItem> getProposedConfiguration() {
        return this.proposedConfiguration;
    }

    public void setProposedConfiguration(Collection<GroupConfigurationItem> proposedConfiguration) {
        if (proposedConfiguration == null) {
            this.proposedConfiguration = null;
            return;
        }
        this.proposedConfiguration = new ArrayList<GroupConfigurationItem>(proposedConfiguration);
    }

    public GroupConfiguration withProposedConfiguration(GroupConfigurationItem ... proposedConfiguration) {
        if (this.proposedConfiguration == null) {
            this.setProposedConfiguration(new ArrayList<GroupConfigurationItem>(proposedConfiguration.length));
        }
        for (GroupConfigurationItem ele : proposedConfiguration) {
            this.proposedConfiguration.add(ele);
        }
        return this;
    }

    public GroupConfiguration withProposedConfiguration(Collection<GroupConfigurationItem> proposedConfiguration) {
        this.setProposedConfiguration(proposedConfiguration);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public GroupConfiguration withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public GroupConfiguration withStatus(GroupConfigurationStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public GroupConfiguration withFailureReason(String failureReason) {
        this.setFailureReason(failureReason);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration()).append(",");
        }
        if (this.getProposedConfiguration() != null) {
            sb.append("ProposedConfiguration: ").append(this.getProposedConfiguration()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getFailureReason() != null) {
            sb.append("FailureReason: ").append(this.getFailureReason());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupConfiguration)) {
            return false;
        }
        GroupConfiguration other = (GroupConfiguration)obj;
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        if (other.getConfiguration() != null && !other.getConfiguration().equals(this.getConfiguration())) {
            return false;
        }
        if (other.getProposedConfiguration() == null ^ this.getProposedConfiguration() == null) {
            return false;
        }
        if (other.getProposedConfiguration() != null && !other.getProposedConfiguration().equals(this.getProposedConfiguration())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getFailureReason() == null ^ this.getFailureReason() == null) {
            return false;
        }
        return other.getFailureReason() == null || other.getFailureReason().equals(this.getFailureReason());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getProposedConfiguration() == null ? 0 : this.getProposedConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getFailureReason() == null ? 0 : this.getFailureReason().hashCode());
        return hashCode;
    }

    public GroupConfiguration clone() {
        try {
            return (GroupConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GroupConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

