/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourceexplorer2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.resourceexplorer2.model.ResourceProperty;
import com.amazonaws.services.resourceexplorer2.model.transform.ResourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Resource
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private Date lastReportedAt;
    private String owningAccountId;
    private List<ResourceProperty> properties;
    private String region;
    private String resourceType;
    private String service;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Resource withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setLastReportedAt(Date lastReportedAt) {
        this.lastReportedAt = lastReportedAt;
    }

    public Date getLastReportedAt() {
        return this.lastReportedAt;
    }

    public Resource withLastReportedAt(Date lastReportedAt) {
        this.setLastReportedAt(lastReportedAt);
        return this;
    }

    public void setOwningAccountId(String owningAccountId) {
        this.owningAccountId = owningAccountId;
    }

    public String getOwningAccountId() {
        return this.owningAccountId;
    }

    public Resource withOwningAccountId(String owningAccountId) {
        this.setOwningAccountId(owningAccountId);
        return this;
    }

    public List<ResourceProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(Collection<ResourceProperty> properties) {
        if (properties == null) {
            this.properties = null;
            return;
        }
        this.properties = new ArrayList<ResourceProperty>(properties);
    }

    public Resource withProperties(ResourceProperty ... properties) {
        if (this.properties == null) {
            this.setProperties(new ArrayList<ResourceProperty>(properties.length));
        }
        for (ResourceProperty ele : properties) {
            this.properties.add(ele);
        }
        return this;
    }

    public Resource withProperties(Collection<ResourceProperty> properties) {
        this.setProperties(properties);
        return this;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public Resource withRegion(String region) {
        this.setRegion(region);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public Resource withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getService() {
        return this.service;
    }

    public Resource withService(String service) {
        this.setService(service);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getLastReportedAt() != null) {
            sb.append("LastReportedAt: ").append(this.getLastReportedAt()).append(",");
        }
        if (this.getOwningAccountId() != null) {
            sb.append("OwningAccountId: ").append(this.getOwningAccountId()).append(",");
        }
        if (this.getProperties() != null) {
            sb.append("Properties: ").append(this.getProperties()).append(",");
        }
        if (this.getRegion() != null) {
            sb.append("Region: ").append(this.getRegion()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getService() != null) {
            sb.append("Service: ").append(this.getService());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getLastReportedAt() == null ^ this.getLastReportedAt() == null) {
            return false;
        }
        if (other.getLastReportedAt() != null && !other.getLastReportedAt().equals(this.getLastReportedAt())) {
            return false;
        }
        if (other.getOwningAccountId() == null ^ this.getOwningAccountId() == null) {
            return false;
        }
        if (other.getOwningAccountId() != null && !other.getOwningAccountId().equals(this.getOwningAccountId())) {
            return false;
        }
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        if (other.getProperties() != null && !other.getProperties().equals(this.getProperties())) {
            return false;
        }
        if (other.getRegion() == null ^ this.getRegion() == null) {
            return false;
        }
        if (other.getRegion() != null && !other.getRegion().equals(this.getRegion())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getService() == null ^ this.getService() == null) {
            return false;
        }
        return other.getService() == null || other.getService().equals(this.getService());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getLastReportedAt() == null ? 0 : this.getLastReportedAt().hashCode());
        hashCode = 31 * hashCode + (this.getOwningAccountId() == null ? 0 : this.getOwningAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        hashCode = 31 * hashCode + (this.getRegion() == null ? 0 : this.getRegion().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getService() == null ? 0 : this.getService().hashCode());
        return hashCode;
    }

    public Resource clone() {
        try {
            return (Resource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

