/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourceexplorer2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.resourceexplorer2.model.IncludedProperty;
import com.amazonaws.services.resourceexplorer2.model.SearchFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateViewRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientToken;
    private SearchFilter filters;
    private List<IncludedProperty> includedProperties;
    private String scope;
    private Map<String, String> tags;
    private String viewName;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateViewRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setFilters(SearchFilter filters) {
        this.filters = filters;
    }

    public SearchFilter getFilters() {
        return this.filters;
    }

    public CreateViewRequest withFilters(SearchFilter filters) {
        this.setFilters(filters);
        return this;
    }

    public List<IncludedProperty> getIncludedProperties() {
        return this.includedProperties;
    }

    public void setIncludedProperties(Collection<IncludedProperty> includedProperties) {
        if (includedProperties == null) {
            this.includedProperties = null;
            return;
        }
        this.includedProperties = new ArrayList<IncludedProperty>(includedProperties);
    }

    public CreateViewRequest withIncludedProperties(IncludedProperty ... includedProperties) {
        if (this.includedProperties == null) {
            this.setIncludedProperties(new ArrayList<IncludedProperty>(includedProperties.length));
        }
        for (IncludedProperty ele : includedProperties) {
            this.includedProperties.add(ele);
        }
        return this;
    }

    public CreateViewRequest withIncludedProperties(Collection<IncludedProperty> includedProperties) {
        this.setIncludedProperties(includedProperties);
        return this;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public CreateViewRequest withScope(String scope) {
        this.setScope(scope);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateViewRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateViewRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateViewRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public CreateViewRequest withViewName(String viewName) {
        this.setViewName(viewName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getIncludedProperties() != null) {
            sb.append("IncludedProperties: ").append(this.getIncludedProperties()).append(",");
        }
        if (this.getScope() != null) {
            sb.append("Scope: ").append(this.getScope()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getViewName() != null) {
            sb.append("ViewName: ").append(this.getViewName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateViewRequest)) {
            return false;
        }
        CreateViewRequest other = (CreateViewRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getIncludedProperties() == null ^ this.getIncludedProperties() == null) {
            return false;
        }
        if (other.getIncludedProperties() != null && !other.getIncludedProperties().equals(this.getIncludedProperties())) {
            return false;
        }
        if (other.getScope() == null ^ this.getScope() == null) {
            return false;
        }
        if (other.getScope() != null && !other.getScope().equals(this.getScope())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getViewName() == null ^ this.getViewName() == null) {
            return false;
        }
        return other.getViewName() == null || other.getViewName().equals(this.getViewName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getIncludedProperties() == null ? 0 : this.getIncludedProperties().hashCode());
        hashCode = 31 * hashCode + (this.getScope() == null ? 0 : this.getScope().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getViewName() == null ? 0 : this.getViewName().hashCode());
        return hashCode;
    }

    public CreateViewRequest clone() {
        return (CreateViewRequest)super.clone();
    }
}

