/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resiliencehub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.resiliencehub.model.AppAssessmentScheduleType;
import com.amazonaws.services.resiliencehub.model.AppComplianceStatusType;
import com.amazonaws.services.resiliencehub.model.AppDriftStatusType;
import com.amazonaws.services.resiliencehub.model.AppStatusType;
import com.amazonaws.services.resiliencehub.model.EventSubscription;
import com.amazonaws.services.resiliencehub.model.PermissionModel;
import com.amazonaws.services.resiliencehub.model.transform.AppMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class App
implements Serializable,
Cloneable,
StructuredPojo {
    private String appArn;
    private String assessmentSchedule;
    private String complianceStatus;
    private Date creationTime;
    private String description;
    private String driftStatus;
    private List<EventSubscription> eventSubscriptions;
    private Date lastAppComplianceEvaluationTime;
    private Date lastDriftEvaluationTime;
    private Date lastResiliencyScoreEvaluationTime;
    private String name;
    private PermissionModel permissionModel;
    private String policyArn;
    private Double resiliencyScore;
    private Integer rpoInSecs;
    private Integer rtoInSecs;
    private String status;
    private Map<String, String> tags;

    public void setAppArn(String appArn) {
        this.appArn = appArn;
    }

    public String getAppArn() {
        return this.appArn;
    }

    public App withAppArn(String appArn) {
        this.setAppArn(appArn);
        return this;
    }

    public void setAssessmentSchedule(String assessmentSchedule) {
        this.assessmentSchedule = assessmentSchedule;
    }

    public String getAssessmentSchedule() {
        return this.assessmentSchedule;
    }

    public App withAssessmentSchedule(String assessmentSchedule) {
        this.setAssessmentSchedule(assessmentSchedule);
        return this;
    }

    public App withAssessmentSchedule(AppAssessmentScheduleType assessmentSchedule) {
        this.assessmentSchedule = assessmentSchedule.toString();
        return this;
    }

    public void setComplianceStatus(String complianceStatus) {
        this.complianceStatus = complianceStatus;
    }

    public String getComplianceStatus() {
        return this.complianceStatus;
    }

    public App withComplianceStatus(String complianceStatus) {
        this.setComplianceStatus(complianceStatus);
        return this;
    }

    public App withComplianceStatus(AppComplianceStatusType complianceStatus) {
        this.complianceStatus = complianceStatus.toString();
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public App withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public App withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDriftStatus(String driftStatus) {
        this.driftStatus = driftStatus;
    }

    public String getDriftStatus() {
        return this.driftStatus;
    }

    public App withDriftStatus(String driftStatus) {
        this.setDriftStatus(driftStatus);
        return this;
    }

    public App withDriftStatus(AppDriftStatusType driftStatus) {
        this.driftStatus = driftStatus.toString();
        return this;
    }

    public List<EventSubscription> getEventSubscriptions() {
        return this.eventSubscriptions;
    }

    public void setEventSubscriptions(Collection<EventSubscription> eventSubscriptions) {
        if (eventSubscriptions == null) {
            this.eventSubscriptions = null;
            return;
        }
        this.eventSubscriptions = new ArrayList<EventSubscription>(eventSubscriptions);
    }

    public App withEventSubscriptions(EventSubscription ... eventSubscriptions) {
        if (this.eventSubscriptions == null) {
            this.setEventSubscriptions(new ArrayList<EventSubscription>(eventSubscriptions.length));
        }
        for (EventSubscription ele : eventSubscriptions) {
            this.eventSubscriptions.add(ele);
        }
        return this;
    }

    public App withEventSubscriptions(Collection<EventSubscription> eventSubscriptions) {
        this.setEventSubscriptions(eventSubscriptions);
        return this;
    }

    public void setLastAppComplianceEvaluationTime(Date lastAppComplianceEvaluationTime) {
        this.lastAppComplianceEvaluationTime = lastAppComplianceEvaluationTime;
    }

    public Date getLastAppComplianceEvaluationTime() {
        return this.lastAppComplianceEvaluationTime;
    }

    public App withLastAppComplianceEvaluationTime(Date lastAppComplianceEvaluationTime) {
        this.setLastAppComplianceEvaluationTime(lastAppComplianceEvaluationTime);
        return this;
    }

    public void setLastDriftEvaluationTime(Date lastDriftEvaluationTime) {
        this.lastDriftEvaluationTime = lastDriftEvaluationTime;
    }

    public Date getLastDriftEvaluationTime() {
        return this.lastDriftEvaluationTime;
    }

    public App withLastDriftEvaluationTime(Date lastDriftEvaluationTime) {
        this.setLastDriftEvaluationTime(lastDriftEvaluationTime);
        return this;
    }

    public void setLastResiliencyScoreEvaluationTime(Date lastResiliencyScoreEvaluationTime) {
        this.lastResiliencyScoreEvaluationTime = lastResiliencyScoreEvaluationTime;
    }

    public Date getLastResiliencyScoreEvaluationTime() {
        return this.lastResiliencyScoreEvaluationTime;
    }

    public App withLastResiliencyScoreEvaluationTime(Date lastResiliencyScoreEvaluationTime) {
        this.setLastResiliencyScoreEvaluationTime(lastResiliencyScoreEvaluationTime);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public App withName(String name) {
        this.setName(name);
        return this;
    }

    public void setPermissionModel(PermissionModel permissionModel) {
        this.permissionModel = permissionModel;
    }

    public PermissionModel getPermissionModel() {
        return this.permissionModel;
    }

    public App withPermissionModel(PermissionModel permissionModel) {
        this.setPermissionModel(permissionModel);
        return this;
    }

    public void setPolicyArn(String policyArn) {
        this.policyArn = policyArn;
    }

    public String getPolicyArn() {
        return this.policyArn;
    }

    public App withPolicyArn(String policyArn) {
        this.setPolicyArn(policyArn);
        return this;
    }

    public void setResiliencyScore(Double resiliencyScore) {
        this.resiliencyScore = resiliencyScore;
    }

    public Double getResiliencyScore() {
        return this.resiliencyScore;
    }

    public App withResiliencyScore(Double resiliencyScore) {
        this.setResiliencyScore(resiliencyScore);
        return this;
    }

    public void setRpoInSecs(Integer rpoInSecs) {
        this.rpoInSecs = rpoInSecs;
    }

    public Integer getRpoInSecs() {
        return this.rpoInSecs;
    }

    public App withRpoInSecs(Integer rpoInSecs) {
        this.setRpoInSecs(rpoInSecs);
        return this;
    }

    public void setRtoInSecs(Integer rtoInSecs) {
        this.rtoInSecs = rtoInSecs;
    }

    public Integer getRtoInSecs() {
        return this.rtoInSecs;
    }

    public App withRtoInSecs(Integer rtoInSecs) {
        this.setRtoInSecs(rtoInSecs);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public App withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public App withStatus(AppStatusType status) {
        this.status = status.toString();
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public App withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public App addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public App clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAppArn() != null) {
            sb.append("AppArn: ").append(this.getAppArn()).append(",");
        }
        if (this.getAssessmentSchedule() != null) {
            sb.append("AssessmentSchedule: ").append(this.getAssessmentSchedule()).append(",");
        }
        if (this.getComplianceStatus() != null) {
            sb.append("ComplianceStatus: ").append(this.getComplianceStatus()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getDriftStatus() != null) {
            sb.append("DriftStatus: ").append(this.getDriftStatus()).append(",");
        }
        if (this.getEventSubscriptions() != null) {
            sb.append("EventSubscriptions: ").append(this.getEventSubscriptions()).append(",");
        }
        if (this.getLastAppComplianceEvaluationTime() != null) {
            sb.append("LastAppComplianceEvaluationTime: ").append(this.getLastAppComplianceEvaluationTime()).append(",");
        }
        if (this.getLastDriftEvaluationTime() != null) {
            sb.append("LastDriftEvaluationTime: ").append(this.getLastDriftEvaluationTime()).append(",");
        }
        if (this.getLastResiliencyScoreEvaluationTime() != null) {
            sb.append("LastResiliencyScoreEvaluationTime: ").append(this.getLastResiliencyScoreEvaluationTime()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getPermissionModel() != null) {
            sb.append("PermissionModel: ").append(this.getPermissionModel()).append(",");
        }
        if (this.getPolicyArn() != null) {
            sb.append("PolicyArn: ").append(this.getPolicyArn()).append(",");
        }
        if (this.getResiliencyScore() != null) {
            sb.append("ResiliencyScore: ").append(this.getResiliencyScore()).append(",");
        }
        if (this.getRpoInSecs() != null) {
            sb.append("RpoInSecs: ").append(this.getRpoInSecs()).append(",");
        }
        if (this.getRtoInSecs() != null) {
            sb.append("RtoInSecs: ").append(this.getRtoInSecs()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof App)) {
            return false;
        }
        App other = (App)obj;
        if (other.getAppArn() == null ^ this.getAppArn() == null) {
            return false;
        }
        if (other.getAppArn() != null && !other.getAppArn().equals(this.getAppArn())) {
            return false;
        }
        if (other.getAssessmentSchedule() == null ^ this.getAssessmentSchedule() == null) {
            return false;
        }
        if (other.getAssessmentSchedule() != null && !other.getAssessmentSchedule().equals(this.getAssessmentSchedule())) {
            return false;
        }
        if (other.getComplianceStatus() == null ^ this.getComplianceStatus() == null) {
            return false;
        }
        if (other.getComplianceStatus() != null && !other.getComplianceStatus().equals(this.getComplianceStatus())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDriftStatus() == null ^ this.getDriftStatus() == null) {
            return false;
        }
        if (other.getDriftStatus() != null && !other.getDriftStatus().equals(this.getDriftStatus())) {
            return false;
        }
        if (other.getEventSubscriptions() == null ^ this.getEventSubscriptions() == null) {
            return false;
        }
        if (other.getEventSubscriptions() != null && !other.getEventSubscriptions().equals(this.getEventSubscriptions())) {
            return false;
        }
        if (other.getLastAppComplianceEvaluationTime() == null ^ this.getLastAppComplianceEvaluationTime() == null) {
            return false;
        }
        if (other.getLastAppComplianceEvaluationTime() != null && !other.getLastAppComplianceEvaluationTime().equals(this.getLastAppComplianceEvaluationTime())) {
            return false;
        }
        if (other.getLastDriftEvaluationTime() == null ^ this.getLastDriftEvaluationTime() == null) {
            return false;
        }
        if (other.getLastDriftEvaluationTime() != null && !other.getLastDriftEvaluationTime().equals(this.getLastDriftEvaluationTime())) {
            return false;
        }
        if (other.getLastResiliencyScoreEvaluationTime() == null ^ this.getLastResiliencyScoreEvaluationTime() == null) {
            return false;
        }
        if (other.getLastResiliencyScoreEvaluationTime() != null && !other.getLastResiliencyScoreEvaluationTime().equals(this.getLastResiliencyScoreEvaluationTime())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPermissionModel() == null ^ this.getPermissionModel() == null) {
            return false;
        }
        if (other.getPermissionModel() != null && !other.getPermissionModel().equals(this.getPermissionModel())) {
            return false;
        }
        if (other.getPolicyArn() == null ^ this.getPolicyArn() == null) {
            return false;
        }
        if (other.getPolicyArn() != null && !other.getPolicyArn().equals(this.getPolicyArn())) {
            return false;
        }
        if (other.getResiliencyScore() == null ^ this.getResiliencyScore() == null) {
            return false;
        }
        if (other.getResiliencyScore() != null && !other.getResiliencyScore().equals(this.getResiliencyScore())) {
            return false;
        }
        if (other.getRpoInSecs() == null ^ this.getRpoInSecs() == null) {
            return false;
        }
        if (other.getRpoInSecs() != null && !other.getRpoInSecs().equals(this.getRpoInSecs())) {
            return false;
        }
        if (other.getRtoInSecs() == null ^ this.getRtoInSecs() == null) {
            return false;
        }
        if (other.getRtoInSecs() != null && !other.getRtoInSecs().equals(this.getRtoInSecs())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAppArn() == null ? 0 : this.getAppArn().hashCode());
        hashCode = 31 * hashCode + (this.getAssessmentSchedule() == null ? 0 : this.getAssessmentSchedule().hashCode());
        hashCode = 31 * hashCode + (this.getComplianceStatus() == null ? 0 : this.getComplianceStatus().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDriftStatus() == null ? 0 : this.getDriftStatus().hashCode());
        hashCode = 31 * hashCode + (this.getEventSubscriptions() == null ? 0 : this.getEventSubscriptions().hashCode());
        hashCode = 31 * hashCode + (this.getLastAppComplianceEvaluationTime() == null ? 0 : this.getLastAppComplianceEvaluationTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastDriftEvaluationTime() == null ? 0 : this.getLastDriftEvaluationTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastResiliencyScoreEvaluationTime() == null ? 0 : this.getLastResiliencyScoreEvaluationTime().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPermissionModel() == null ? 0 : this.getPermissionModel().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyArn() == null ? 0 : this.getPolicyArn().hashCode());
        hashCode = 31 * hashCode + (this.getResiliencyScore() == null ? 0 : this.getResiliencyScore().hashCode());
        hashCode = 31 * hashCode + (this.getRpoInSecs() == null ? 0 : this.getRpoInSecs().hashCode());
        hashCode = 31 * hashCode + (this.getRtoInSecs() == null ? 0 : this.getRtoInSecs().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public App clone() {
        try {
            return (App)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AppMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

