/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resiliencehub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.resiliencehub.model.transform.EksSourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EksSource
implements Serializable,
Cloneable,
StructuredPojo {
    private String eksClusterArn;
    private List<String> namespaces;

    public void setEksClusterArn(String eksClusterArn) {
        this.eksClusterArn = eksClusterArn;
    }

    public String getEksClusterArn() {
        return this.eksClusterArn;
    }

    public EksSource withEksClusterArn(String eksClusterArn) {
        this.setEksClusterArn(eksClusterArn);
        return this;
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Collection<String> namespaces) {
        if (namespaces == null) {
            this.namespaces = null;
            return;
        }
        this.namespaces = new ArrayList<String>(namespaces);
    }

    public EksSource withNamespaces(String ... namespaces) {
        if (this.namespaces == null) {
            this.setNamespaces(new ArrayList<String>(namespaces.length));
        }
        for (String ele : namespaces) {
            this.namespaces.add(ele);
        }
        return this;
    }

    public EksSource withNamespaces(Collection<String> namespaces) {
        this.setNamespaces(namespaces);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEksClusterArn() != null) {
            sb.append("EksClusterArn: ").append(this.getEksClusterArn()).append(",");
        }
        if (this.getNamespaces() != null) {
            sb.append("Namespaces: ").append(this.getNamespaces());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksSource)) {
            return false;
        }
        EksSource other = (EksSource)obj;
        if (other.getEksClusterArn() == null ^ this.getEksClusterArn() == null) {
            return false;
        }
        if (other.getEksClusterArn() != null && !other.getEksClusterArn().equals(this.getEksClusterArn())) {
            return false;
        }
        if (other.getNamespaces() == null ^ this.getNamespaces() == null) {
            return false;
        }
        return other.getNamespaces() == null || other.getNamespaces().equals(this.getNamespaces());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEksClusterArn() == null ? 0 : this.getEksClusterArn().hashCode());
        hashCode = 31 * hashCode + (this.getNamespaces() == null ? 0 : this.getNamespaces().hashCode());
        return hashCode;
    }

    public EksSource clone() {
        try {
            return (EksSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EksSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

