/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resiliencehub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.resiliencehub.model.RecommendationTemplateStatus;
import com.amazonaws.services.resiliencehub.model.RenderRecommendationType;
import com.amazonaws.services.resiliencehub.model.S3Location;
import com.amazonaws.services.resiliencehub.model.TemplateFormat;
import com.amazonaws.services.resiliencehub.model.transform.RecommendationTemplateMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecommendationTemplate
implements Serializable,
Cloneable,
StructuredPojo {
    private String appArn;
    private String assessmentArn;
    private Date endTime;
    private String format;
    private String message;
    private String name;
    private Boolean needsReplacements;
    private List<String> recommendationIds;
    private String recommendationTemplateArn;
    private List<String> recommendationTypes;
    private Date startTime;
    private String status;
    private Map<String, String> tags;
    private S3Location templatesLocation;

    public void setAppArn(String appArn) {
        this.appArn = appArn;
    }

    public String getAppArn() {
        return this.appArn;
    }

    public RecommendationTemplate withAppArn(String appArn) {
        this.setAppArn(appArn);
        return this;
    }

    public void setAssessmentArn(String assessmentArn) {
        this.assessmentArn = assessmentArn;
    }

    public String getAssessmentArn() {
        return this.assessmentArn;
    }

    public RecommendationTemplate withAssessmentArn(String assessmentArn) {
        this.setAssessmentArn(assessmentArn);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public RecommendationTemplate withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public RecommendationTemplate withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public RecommendationTemplate withFormat(TemplateFormat format) {
        this.format = format.toString();
        return this;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public RecommendationTemplate withMessage(String message) {
        this.setMessage(message);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public RecommendationTemplate withName(String name) {
        this.setName(name);
        return this;
    }

    public void setNeedsReplacements(Boolean needsReplacements) {
        this.needsReplacements = needsReplacements;
    }

    public Boolean getNeedsReplacements() {
        return this.needsReplacements;
    }

    public RecommendationTemplate withNeedsReplacements(Boolean needsReplacements) {
        this.setNeedsReplacements(needsReplacements);
        return this;
    }

    public Boolean isNeedsReplacements() {
        return this.needsReplacements;
    }

    public List<String> getRecommendationIds() {
        return this.recommendationIds;
    }

    public void setRecommendationIds(Collection<String> recommendationIds) {
        if (recommendationIds == null) {
            this.recommendationIds = null;
            return;
        }
        this.recommendationIds = new ArrayList<String>(recommendationIds);
    }

    public RecommendationTemplate withRecommendationIds(String ... recommendationIds) {
        if (this.recommendationIds == null) {
            this.setRecommendationIds(new ArrayList<String>(recommendationIds.length));
        }
        for (String ele : recommendationIds) {
            this.recommendationIds.add(ele);
        }
        return this;
    }

    public RecommendationTemplate withRecommendationIds(Collection<String> recommendationIds) {
        this.setRecommendationIds(recommendationIds);
        return this;
    }

    public void setRecommendationTemplateArn(String recommendationTemplateArn) {
        this.recommendationTemplateArn = recommendationTemplateArn;
    }

    public String getRecommendationTemplateArn() {
        return this.recommendationTemplateArn;
    }

    public RecommendationTemplate withRecommendationTemplateArn(String recommendationTemplateArn) {
        this.setRecommendationTemplateArn(recommendationTemplateArn);
        return this;
    }

    public List<String> getRecommendationTypes() {
        return this.recommendationTypes;
    }

    public void setRecommendationTypes(Collection<String> recommendationTypes) {
        if (recommendationTypes == null) {
            this.recommendationTypes = null;
            return;
        }
        this.recommendationTypes = new ArrayList<String>(recommendationTypes);
    }

    public RecommendationTemplate withRecommendationTypes(String ... recommendationTypes) {
        if (this.recommendationTypes == null) {
            this.setRecommendationTypes(new ArrayList<String>(recommendationTypes.length));
        }
        for (String ele : recommendationTypes) {
            this.recommendationTypes.add(ele);
        }
        return this;
    }

    public RecommendationTemplate withRecommendationTypes(Collection<String> recommendationTypes) {
        this.setRecommendationTypes(recommendationTypes);
        return this;
    }

    public RecommendationTemplate withRecommendationTypes(RenderRecommendationType ... recommendationTypes) {
        ArrayList<String> recommendationTypesCopy = new ArrayList<String>(recommendationTypes.length);
        for (RenderRecommendationType value : recommendationTypes) {
            recommendationTypesCopy.add(value.toString());
        }
        if (this.getRecommendationTypes() == null) {
            this.setRecommendationTypes(recommendationTypesCopy);
        } else {
            this.getRecommendationTypes().addAll(recommendationTypesCopy);
        }
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public RecommendationTemplate withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public RecommendationTemplate withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public RecommendationTemplate withStatus(RecommendationTemplateStatus status) {
        this.status = status.toString();
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public RecommendationTemplate withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public RecommendationTemplate addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public RecommendationTemplate clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setTemplatesLocation(S3Location templatesLocation) {
        this.templatesLocation = templatesLocation;
    }

    public S3Location getTemplatesLocation() {
        return this.templatesLocation;
    }

    public RecommendationTemplate withTemplatesLocation(S3Location templatesLocation) {
        this.setTemplatesLocation(templatesLocation);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAppArn() != null) {
            sb.append("AppArn: ").append(this.getAppArn()).append(",");
        }
        if (this.getAssessmentArn() != null) {
            sb.append("AssessmentArn: ").append(this.getAssessmentArn()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getFormat() != null) {
            sb.append("Format: ").append(this.getFormat()).append(",");
        }
        if (this.getMessage() != null) {
            sb.append("Message: ").append(this.getMessage()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getNeedsReplacements() != null) {
            sb.append("NeedsReplacements: ").append(this.getNeedsReplacements()).append(",");
        }
        if (this.getRecommendationIds() != null) {
            sb.append("RecommendationIds: ").append(this.getRecommendationIds()).append(",");
        }
        if (this.getRecommendationTemplateArn() != null) {
            sb.append("RecommendationTemplateArn: ").append(this.getRecommendationTemplateArn()).append(",");
        }
        if (this.getRecommendationTypes() != null) {
            sb.append("RecommendationTypes: ").append(this.getRecommendationTypes()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getTemplatesLocation() != null) {
            sb.append("TemplatesLocation: ").append(this.getTemplatesLocation());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationTemplate)) {
            return false;
        }
        RecommendationTemplate other = (RecommendationTemplate)obj;
        if (other.getAppArn() == null ^ this.getAppArn() == null) {
            return false;
        }
        if (other.getAppArn() != null && !other.getAppArn().equals(this.getAppArn())) {
            return false;
        }
        if (other.getAssessmentArn() == null ^ this.getAssessmentArn() == null) {
            return false;
        }
        if (other.getAssessmentArn() != null && !other.getAssessmentArn().equals(this.getAssessmentArn())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        if (other.getFormat() != null && !other.getFormat().equals(this.getFormat())) {
            return false;
        }
        if (other.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (other.getMessage() != null && !other.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getNeedsReplacements() == null ^ this.getNeedsReplacements() == null) {
            return false;
        }
        if (other.getNeedsReplacements() != null && !other.getNeedsReplacements().equals(this.getNeedsReplacements())) {
            return false;
        }
        if (other.getRecommendationIds() == null ^ this.getRecommendationIds() == null) {
            return false;
        }
        if (other.getRecommendationIds() != null && !other.getRecommendationIds().equals(this.getRecommendationIds())) {
            return false;
        }
        if (other.getRecommendationTemplateArn() == null ^ this.getRecommendationTemplateArn() == null) {
            return false;
        }
        if (other.getRecommendationTemplateArn() != null && !other.getRecommendationTemplateArn().equals(this.getRecommendationTemplateArn())) {
            return false;
        }
        if (other.getRecommendationTypes() == null ^ this.getRecommendationTypes() == null) {
            return false;
        }
        if (other.getRecommendationTypes() != null && !other.getRecommendationTypes().equals(this.getRecommendationTypes())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getTemplatesLocation() == null ^ this.getTemplatesLocation() == null) {
            return false;
        }
        return other.getTemplatesLocation() == null || other.getTemplatesLocation().equals(this.getTemplatesLocation());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAppArn() == null ? 0 : this.getAppArn().hashCode());
        hashCode = 31 * hashCode + (this.getAssessmentArn() == null ? 0 : this.getAssessmentArn().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getFormat() == null ? 0 : this.getFormat().hashCode());
        hashCode = 31 * hashCode + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getNeedsReplacements() == null ? 0 : this.getNeedsReplacements().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendationIds() == null ? 0 : this.getRecommendationIds().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendationTemplateArn() == null ? 0 : this.getRecommendationTemplateArn().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendationTypes() == null ? 0 : this.getRecommendationTypes().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getTemplatesLocation() == null ? 0 : this.getTemplatesLocation().hashCode());
        return hashCode;
    }

    public RecommendationTemplate clone() {
        try {
            return (RecommendationTemplate)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecommendationTemplateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

