/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resiliencehub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.resiliencehub.model.AppComponent;
import com.amazonaws.services.resiliencehub.model.LogicalResourceId;
import com.amazonaws.services.resiliencehub.model.PhysicalResourceId;
import com.amazonaws.services.resiliencehub.model.transform.PhysicalResourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PhysicalResource
implements Serializable,
Cloneable,
StructuredPojo {
    private List<AppComponent> appComponents;
    private LogicalResourceId logicalResourceId;
    private PhysicalResourceId physicalResourceId;
    private String resourceName;
    private String resourceType;

    public List<AppComponent> getAppComponents() {
        return this.appComponents;
    }

    public void setAppComponents(Collection<AppComponent> appComponents) {
        if (appComponents == null) {
            this.appComponents = null;
            return;
        }
        this.appComponents = new ArrayList<AppComponent>(appComponents);
    }

    public PhysicalResource withAppComponents(AppComponent ... appComponents) {
        if (this.appComponents == null) {
            this.setAppComponents(new ArrayList<AppComponent>(appComponents.length));
        }
        for (AppComponent ele : appComponents) {
            this.appComponents.add(ele);
        }
        return this;
    }

    public PhysicalResource withAppComponents(Collection<AppComponent> appComponents) {
        this.setAppComponents(appComponents);
        return this;
    }

    public void setLogicalResourceId(LogicalResourceId logicalResourceId) {
        this.logicalResourceId = logicalResourceId;
    }

    public LogicalResourceId getLogicalResourceId() {
        return this.logicalResourceId;
    }

    public PhysicalResource withLogicalResourceId(LogicalResourceId logicalResourceId) {
        this.setLogicalResourceId(logicalResourceId);
        return this;
    }

    public void setPhysicalResourceId(PhysicalResourceId physicalResourceId) {
        this.physicalResourceId = physicalResourceId;
    }

    public PhysicalResourceId getPhysicalResourceId() {
        return this.physicalResourceId;
    }

    public PhysicalResource withPhysicalResourceId(PhysicalResourceId physicalResourceId) {
        this.setPhysicalResourceId(physicalResourceId);
        return this;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public PhysicalResource withResourceName(String resourceName) {
        this.setResourceName(resourceName);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public PhysicalResource withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAppComponents() != null) {
            sb.append("AppComponents: ").append(this.getAppComponents()).append(",");
        }
        if (this.getLogicalResourceId() != null) {
            sb.append("LogicalResourceId: ").append(this.getLogicalResourceId()).append(",");
        }
        if (this.getPhysicalResourceId() != null) {
            sb.append("PhysicalResourceId: ").append(this.getPhysicalResourceId()).append(",");
        }
        if (this.getResourceName() != null) {
            sb.append("ResourceName: ").append(this.getResourceName()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhysicalResource)) {
            return false;
        }
        PhysicalResource other = (PhysicalResource)obj;
        if (other.getAppComponents() == null ^ this.getAppComponents() == null) {
            return false;
        }
        if (other.getAppComponents() != null && !other.getAppComponents().equals(this.getAppComponents())) {
            return false;
        }
        if (other.getLogicalResourceId() == null ^ this.getLogicalResourceId() == null) {
            return false;
        }
        if (other.getLogicalResourceId() != null && !other.getLogicalResourceId().equals(this.getLogicalResourceId())) {
            return false;
        }
        if (other.getPhysicalResourceId() == null ^ this.getPhysicalResourceId() == null) {
            return false;
        }
        if (other.getPhysicalResourceId() != null && !other.getPhysicalResourceId().equals(this.getPhysicalResourceId())) {
            return false;
        }
        if (other.getResourceName() == null ^ this.getResourceName() == null) {
            return false;
        }
        if (other.getResourceName() != null && !other.getResourceName().equals(this.getResourceName())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        return other.getResourceType() == null || other.getResourceType().equals(this.getResourceType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAppComponents() == null ? 0 : this.getAppComponents().hashCode());
        hashCode = 31 * hashCode + (this.getLogicalResourceId() == null ? 0 : this.getLogicalResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getPhysicalResourceId() == null ? 0 : this.getPhysicalResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getResourceName() == null ? 0 : this.getResourceName().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        return hashCode;
    }

    public PhysicalResource clone() {
        try {
            return (PhysicalResource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PhysicalResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

