/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.rekognition.model.CustomizationFeature;
import com.amazonaws.services.rekognition.model.ProjectAutoUpdate;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CreateProjectRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String projectName;
    private String feature;
    private String autoUpdate;
    private Map<String, String> tags;

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public CreateProjectRequest withProjectName(String projectName) {
        this.setProjectName(projectName);
        return this;
    }

    public void setFeature(String feature) {
        this.feature = feature;
    }

    public String getFeature() {
        return this.feature;
    }

    public CreateProjectRequest withFeature(String feature) {
        this.setFeature(feature);
        return this;
    }

    public CreateProjectRequest withFeature(CustomizationFeature feature) {
        this.feature = feature.toString();
        return this;
    }

    public void setAutoUpdate(String autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public String getAutoUpdate() {
        return this.autoUpdate;
    }

    public CreateProjectRequest withAutoUpdate(String autoUpdate) {
        this.setAutoUpdate(autoUpdate);
        return this;
    }

    public CreateProjectRequest withAutoUpdate(ProjectAutoUpdate autoUpdate) {
        this.autoUpdate = autoUpdate.toString();
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateProjectRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateProjectRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateProjectRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProjectName() != null) {
            sb.append("ProjectName: ").append(this.getProjectName()).append(",");
        }
        if (this.getFeature() != null) {
            sb.append("Feature: ").append(this.getFeature()).append(",");
        }
        if (this.getAutoUpdate() != null) {
            sb.append("AutoUpdate: ").append(this.getAutoUpdate()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectRequest)) {
            return false;
        }
        CreateProjectRequest other = (CreateProjectRequest)obj;
        if (other.getProjectName() == null ^ this.getProjectName() == null) {
            return false;
        }
        if (other.getProjectName() != null && !other.getProjectName().equals(this.getProjectName())) {
            return false;
        }
        if (other.getFeature() == null ^ this.getFeature() == null) {
            return false;
        }
        if (other.getFeature() != null && !other.getFeature().equals(this.getFeature())) {
            return false;
        }
        if (other.getAutoUpdate() == null ^ this.getAutoUpdate() == null) {
            return false;
        }
        if (other.getAutoUpdate() != null && !other.getAutoUpdate().equals(this.getAutoUpdate())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProjectName() == null ? 0 : this.getProjectName().hashCode());
        hashCode = 31 * hashCode + (this.getFeature() == null ? 0 : this.getFeature().hashCode());
        hashCode = 31 * hashCode + (this.getAutoUpdate() == null ? 0 : this.getAutoUpdate().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateProjectRequest clone() {
        return (CreateProjectRequest)super.clone();
    }
}

