/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.rekognition.model.Celebrity;
import com.amazonaws.services.rekognition.model.ComparedFace;
import com.amazonaws.services.rekognition.model.OrientationCorrection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RecognizeCelebritiesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Celebrity> celebrityFaces;
    private List<ComparedFace> unrecognizedFaces;
    private String orientationCorrection;

    public List<Celebrity> getCelebrityFaces() {
        return this.celebrityFaces;
    }

    public void setCelebrityFaces(Collection<Celebrity> celebrityFaces) {
        if (celebrityFaces == null) {
            this.celebrityFaces = null;
            return;
        }
        this.celebrityFaces = new ArrayList<Celebrity>(celebrityFaces);
    }

    public RecognizeCelebritiesResult withCelebrityFaces(Celebrity ... celebrityFaces) {
        if (this.celebrityFaces == null) {
            this.setCelebrityFaces(new ArrayList<Celebrity>(celebrityFaces.length));
        }
        for (Celebrity ele : celebrityFaces) {
            this.celebrityFaces.add(ele);
        }
        return this;
    }

    public RecognizeCelebritiesResult withCelebrityFaces(Collection<Celebrity> celebrityFaces) {
        this.setCelebrityFaces(celebrityFaces);
        return this;
    }

    public List<ComparedFace> getUnrecognizedFaces() {
        return this.unrecognizedFaces;
    }

    public void setUnrecognizedFaces(Collection<ComparedFace> unrecognizedFaces) {
        if (unrecognizedFaces == null) {
            this.unrecognizedFaces = null;
            return;
        }
        this.unrecognizedFaces = new ArrayList<ComparedFace>(unrecognizedFaces);
    }

    public RecognizeCelebritiesResult withUnrecognizedFaces(ComparedFace ... unrecognizedFaces) {
        if (this.unrecognizedFaces == null) {
            this.setUnrecognizedFaces(new ArrayList<ComparedFace>(unrecognizedFaces.length));
        }
        for (ComparedFace ele : unrecognizedFaces) {
            this.unrecognizedFaces.add(ele);
        }
        return this;
    }

    public RecognizeCelebritiesResult withUnrecognizedFaces(Collection<ComparedFace> unrecognizedFaces) {
        this.setUnrecognizedFaces(unrecognizedFaces);
        return this;
    }

    public void setOrientationCorrection(String orientationCorrection) {
        this.orientationCorrection = orientationCorrection;
    }

    public String getOrientationCorrection() {
        return this.orientationCorrection;
    }

    public RecognizeCelebritiesResult withOrientationCorrection(String orientationCorrection) {
        this.setOrientationCorrection(orientationCorrection);
        return this;
    }

    public void setOrientationCorrection(OrientationCorrection orientationCorrection) {
        this.withOrientationCorrection(orientationCorrection);
    }

    public RecognizeCelebritiesResult withOrientationCorrection(OrientationCorrection orientationCorrection) {
        this.orientationCorrection = orientationCorrection.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCelebrityFaces() != null) {
            sb.append("CelebrityFaces: ").append(this.getCelebrityFaces()).append(",");
        }
        if (this.getUnrecognizedFaces() != null) {
            sb.append("UnrecognizedFaces: ").append(this.getUnrecognizedFaces()).append(",");
        }
        if (this.getOrientationCorrection() != null) {
            sb.append("OrientationCorrection: ").append(this.getOrientationCorrection());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecognizeCelebritiesResult)) {
            return false;
        }
        RecognizeCelebritiesResult other = (RecognizeCelebritiesResult)obj;
        if (other.getCelebrityFaces() == null ^ this.getCelebrityFaces() == null) {
            return false;
        }
        if (other.getCelebrityFaces() != null && !other.getCelebrityFaces().equals(this.getCelebrityFaces())) {
            return false;
        }
        if (other.getUnrecognizedFaces() == null ^ this.getUnrecognizedFaces() == null) {
            return false;
        }
        if (other.getUnrecognizedFaces() != null && !other.getUnrecognizedFaces().equals(this.getUnrecognizedFaces())) {
            return false;
        }
        if (other.getOrientationCorrection() == null ^ this.getOrientationCorrection() == null) {
            return false;
        }
        return other.getOrientationCorrection() == null || other.getOrientationCorrection().equals(this.getOrientationCorrection());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCelebrityFaces() == null ? 0 : this.getCelebrityFaces().hashCode());
        hashCode = 31 * hashCode + (this.getUnrecognizedFaces() == null ? 0 : this.getUnrecognizedFaces().hashCode());
        hashCode = 31 * hashCode + (this.getOrientationCorrection() == null ? 0 : this.getOrientationCorrection().hashCode());
        return hashCode;
    }

    public RecognizeCelebritiesResult clone() {
        try {
            return (RecognizeCelebritiesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

