/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.rekognition.AmazonRekognition;
import com.amazonaws.services.rekognition.model.DescribeProjectVersionsRequest;
import com.amazonaws.services.rekognition.waiters.DescribeProjectVersionsFunction;
import com.amazonaws.services.rekognition.waiters.ProjectVersionRunning;
import com.amazonaws.services.rekognition.waiters.ProjectVersionTrainingCompleted;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AmazonRekognitionWaiters {
    private final AmazonRekognition client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AmazonRekognitionWaiters");

    @SdkInternalApi
    public AmazonRekognitionWaiters(AmazonRekognition client) {
        this.client = client;
    }

    public Waiter<DescribeProjectVersionsRequest> projectVersionTrainingCompleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeProjectVersionsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ProjectVersionTrainingCompleted.IsTRAINING_COMPLETEDMatcher(), new ProjectVersionTrainingCompleted.IsTRAINING_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(360), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(120))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeProjectVersionsRequest> projectVersionRunning() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeProjectVersionsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ProjectVersionRunning.IsRUNNINGMatcher(), new ProjectVersionRunning.IsFAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

