/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.rekognition.model.RegionOfInterest;
import com.amazonaws.services.rekognition.model.StreamProcessorDataSharingPreference;
import com.amazonaws.services.rekognition.model.StreamProcessorInput;
import com.amazonaws.services.rekognition.model.StreamProcessorNotificationChannel;
import com.amazonaws.services.rekognition.model.StreamProcessorOutput;
import com.amazonaws.services.rekognition.model.StreamProcessorSettings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateStreamProcessorRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private StreamProcessorInput input;
    private StreamProcessorOutput output;
    private String name;
    private StreamProcessorSettings settings;
    private String roleArn;
    private Map<String, String> tags;
    private StreamProcessorNotificationChannel notificationChannel;
    private String kmsKeyId;
    private List<RegionOfInterest> regionsOfInterest;
    private StreamProcessorDataSharingPreference dataSharingPreference;

    public void setInput(StreamProcessorInput input) {
        this.input = input;
    }

    public StreamProcessorInput getInput() {
        return this.input;
    }

    public CreateStreamProcessorRequest withInput(StreamProcessorInput input) {
        this.setInput(input);
        return this;
    }

    public void setOutput(StreamProcessorOutput output) {
        this.output = output;
    }

    public StreamProcessorOutput getOutput() {
        return this.output;
    }

    public CreateStreamProcessorRequest withOutput(StreamProcessorOutput output) {
        this.setOutput(output);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateStreamProcessorRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setSettings(StreamProcessorSettings settings) {
        this.settings = settings;
    }

    public StreamProcessorSettings getSettings() {
        return this.settings;
    }

    public CreateStreamProcessorRequest withSettings(StreamProcessorSettings settings) {
        this.setSettings(settings);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public CreateStreamProcessorRequest withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateStreamProcessorRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateStreamProcessorRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateStreamProcessorRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setNotificationChannel(StreamProcessorNotificationChannel notificationChannel) {
        this.notificationChannel = notificationChannel;
    }

    public StreamProcessorNotificationChannel getNotificationChannel() {
        return this.notificationChannel;
    }

    public CreateStreamProcessorRequest withNotificationChannel(StreamProcessorNotificationChannel notificationChannel) {
        this.setNotificationChannel(notificationChannel);
        return this;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public CreateStreamProcessorRequest withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public List<RegionOfInterest> getRegionsOfInterest() {
        return this.regionsOfInterest;
    }

    public void setRegionsOfInterest(Collection<RegionOfInterest> regionsOfInterest) {
        if (regionsOfInterest == null) {
            this.regionsOfInterest = null;
            return;
        }
        this.regionsOfInterest = new ArrayList<RegionOfInterest>(regionsOfInterest);
    }

    public CreateStreamProcessorRequest withRegionsOfInterest(RegionOfInterest ... regionsOfInterest) {
        if (this.regionsOfInterest == null) {
            this.setRegionsOfInterest(new ArrayList<RegionOfInterest>(regionsOfInterest.length));
        }
        for (RegionOfInterest ele : regionsOfInterest) {
            this.regionsOfInterest.add(ele);
        }
        return this;
    }

    public CreateStreamProcessorRequest withRegionsOfInterest(Collection<RegionOfInterest> regionsOfInterest) {
        this.setRegionsOfInterest(regionsOfInterest);
        return this;
    }

    public void setDataSharingPreference(StreamProcessorDataSharingPreference dataSharingPreference) {
        this.dataSharingPreference = dataSharingPreference;
    }

    public StreamProcessorDataSharingPreference getDataSharingPreference() {
        return this.dataSharingPreference;
    }

    public CreateStreamProcessorRequest withDataSharingPreference(StreamProcessorDataSharingPreference dataSharingPreference) {
        this.setDataSharingPreference(dataSharingPreference);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInput() != null) {
            sb.append("Input: ").append(this.getInput()).append(",");
        }
        if (this.getOutput() != null) {
            sb.append("Output: ").append(this.getOutput()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getSettings() != null) {
            sb.append("Settings: ").append(this.getSettings()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getNotificationChannel() != null) {
            sb.append("NotificationChannel: ").append(this.getNotificationChannel()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getRegionsOfInterest() != null) {
            sb.append("RegionsOfInterest: ").append(this.getRegionsOfInterest()).append(",");
        }
        if (this.getDataSharingPreference() != null) {
            sb.append("DataSharingPreference: ").append(this.getDataSharingPreference());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamProcessorRequest)) {
            return false;
        }
        CreateStreamProcessorRequest other = (CreateStreamProcessorRequest)obj;
        if (other.getInput() == null ^ this.getInput() == null) {
            return false;
        }
        if (other.getInput() != null && !other.getInput().equals(this.getInput())) {
            return false;
        }
        if (other.getOutput() == null ^ this.getOutput() == null) {
            return false;
        }
        if (other.getOutput() != null && !other.getOutput().equals(this.getOutput())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getSettings() == null ^ this.getSettings() == null) {
            return false;
        }
        if (other.getSettings() != null && !other.getSettings().equals(this.getSettings())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getNotificationChannel() == null ^ this.getNotificationChannel() == null) {
            return false;
        }
        if (other.getNotificationChannel() != null && !other.getNotificationChannel().equals(this.getNotificationChannel())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getRegionsOfInterest() == null ^ this.getRegionsOfInterest() == null) {
            return false;
        }
        if (other.getRegionsOfInterest() != null && !other.getRegionsOfInterest().equals(this.getRegionsOfInterest())) {
            return false;
        }
        if (other.getDataSharingPreference() == null ^ this.getDataSharingPreference() == null) {
            return false;
        }
        return other.getDataSharingPreference() == null || other.getDataSharingPreference().equals(this.getDataSharingPreference());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInput() == null ? 0 : this.getInput().hashCode());
        hashCode = 31 * hashCode + (this.getOutput() == null ? 0 : this.getOutput().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getSettings() == null ? 0 : this.getSettings().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationChannel() == null ? 0 : this.getNotificationChannel().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getRegionsOfInterest() == null ? 0 : this.getRegionsOfInterest().hashCode());
        hashCode = 31 * hashCode + (this.getDataSharingPreference() == null ? 0 : this.getDataSharingPreference().hashCode());
        return hashCode;
    }

    public CreateStreamProcessorRequest clone() {
        return (CreateStreamProcessorRequest)super.clone();
    }
}

