/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.rekognition.model.CelebrityRecognition;
import com.amazonaws.services.rekognition.model.VideoJobStatus;
import com.amazonaws.services.rekognition.model.VideoMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetCelebrityRecognitionResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String jobStatus;
    private String statusMessage;
    private VideoMetadata videoMetadata;
    private String nextToken;
    private List<CelebrityRecognition> celebrities;

    public void setJobStatus(String jobStatus) {
        this.jobStatus = jobStatus;
    }

    public String getJobStatus() {
        return this.jobStatus;
    }

    public GetCelebrityRecognitionResult withJobStatus(String jobStatus) {
        this.setJobStatus(jobStatus);
        return this;
    }

    public GetCelebrityRecognitionResult withJobStatus(VideoJobStatus jobStatus) {
        this.jobStatus = jobStatus.toString();
        return this;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public GetCelebrityRecognitionResult withStatusMessage(String statusMessage) {
        this.setStatusMessage(statusMessage);
        return this;
    }

    public void setVideoMetadata(VideoMetadata videoMetadata) {
        this.videoMetadata = videoMetadata;
    }

    public VideoMetadata getVideoMetadata() {
        return this.videoMetadata;
    }

    public GetCelebrityRecognitionResult withVideoMetadata(VideoMetadata videoMetadata) {
        this.setVideoMetadata(videoMetadata);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetCelebrityRecognitionResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<CelebrityRecognition> getCelebrities() {
        return this.celebrities;
    }

    public void setCelebrities(Collection<CelebrityRecognition> celebrities) {
        if (celebrities == null) {
            this.celebrities = null;
            return;
        }
        this.celebrities = new ArrayList<CelebrityRecognition>(celebrities);
    }

    public GetCelebrityRecognitionResult withCelebrities(CelebrityRecognition ... celebrities) {
        if (this.celebrities == null) {
            this.setCelebrities(new ArrayList<CelebrityRecognition>(celebrities.length));
        }
        for (CelebrityRecognition ele : celebrities) {
            this.celebrities.add(ele);
        }
        return this;
    }

    public GetCelebrityRecognitionResult withCelebrities(Collection<CelebrityRecognition> celebrities) {
        this.setCelebrities(celebrities);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobStatus() != null) {
            sb.append("JobStatus: ").append(this.getJobStatus()).append(",");
        }
        if (this.getStatusMessage() != null) {
            sb.append("StatusMessage: ").append(this.getStatusMessage()).append(",");
        }
        if (this.getVideoMetadata() != null) {
            sb.append("VideoMetadata: ").append(this.getVideoMetadata()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getCelebrities() != null) {
            sb.append("Celebrities: ").append(this.getCelebrities());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCelebrityRecognitionResult)) {
            return false;
        }
        GetCelebrityRecognitionResult other = (GetCelebrityRecognitionResult)obj;
        if (other.getJobStatus() == null ^ this.getJobStatus() == null) {
            return false;
        }
        if (other.getJobStatus() != null && !other.getJobStatus().equals(this.getJobStatus())) {
            return false;
        }
        if (other.getStatusMessage() == null ^ this.getStatusMessage() == null) {
            return false;
        }
        if (other.getStatusMessage() != null && !other.getStatusMessage().equals(this.getStatusMessage())) {
            return false;
        }
        if (other.getVideoMetadata() == null ^ this.getVideoMetadata() == null) {
            return false;
        }
        if (other.getVideoMetadata() != null && !other.getVideoMetadata().equals(this.getVideoMetadata())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getCelebrities() == null ^ this.getCelebrities() == null) {
            return false;
        }
        return other.getCelebrities() == null || other.getCelebrities().equals(this.getCelebrities());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobStatus() == null ? 0 : this.getJobStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatusMessage() == null ? 0 : this.getStatusMessage().hashCode());
        hashCode = 31 * hashCode + (this.getVideoMetadata() == null ? 0 : this.getVideoMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getCelebrities() == null ? 0 : this.getCelebrities().hashCode());
        return hashCode;
    }

    public GetCelebrityRecognitionResult clone() {
        try {
            return (GetCelebrityRecognitionResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

