/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.rekognition.model.DetectLabelsImageProperties;
import com.amazonaws.services.rekognition.model.Label;
import com.amazonaws.services.rekognition.model.OrientationCorrection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DetectLabelsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Label> labels;
    private String orientationCorrection;
    private String labelModelVersion;
    private DetectLabelsImageProperties imageProperties;

    public List<Label> getLabels() {
        return this.labels;
    }

    public void setLabels(Collection<Label> labels) {
        if (labels == null) {
            this.labels = null;
            return;
        }
        this.labels = new ArrayList<Label>(labels);
    }

    public DetectLabelsResult withLabels(Label ... labels) {
        if (this.labels == null) {
            this.setLabels(new ArrayList<Label>(labels.length));
        }
        for (Label ele : labels) {
            this.labels.add(ele);
        }
        return this;
    }

    public DetectLabelsResult withLabels(Collection<Label> labels) {
        this.setLabels(labels);
        return this;
    }

    public void setOrientationCorrection(String orientationCorrection) {
        this.orientationCorrection = orientationCorrection;
    }

    public String getOrientationCorrection() {
        return this.orientationCorrection;
    }

    public DetectLabelsResult withOrientationCorrection(String orientationCorrection) {
        this.setOrientationCorrection(orientationCorrection);
        return this;
    }

    public void setOrientationCorrection(OrientationCorrection orientationCorrection) {
        this.withOrientationCorrection(orientationCorrection);
    }

    public DetectLabelsResult withOrientationCorrection(OrientationCorrection orientationCorrection) {
        this.orientationCorrection = orientationCorrection.toString();
        return this;
    }

    public void setLabelModelVersion(String labelModelVersion) {
        this.labelModelVersion = labelModelVersion;
    }

    public String getLabelModelVersion() {
        return this.labelModelVersion;
    }

    public DetectLabelsResult withLabelModelVersion(String labelModelVersion) {
        this.setLabelModelVersion(labelModelVersion);
        return this;
    }

    public void setImageProperties(DetectLabelsImageProperties imageProperties) {
        this.imageProperties = imageProperties;
    }

    public DetectLabelsImageProperties getImageProperties() {
        return this.imageProperties;
    }

    public DetectLabelsResult withImageProperties(DetectLabelsImageProperties imageProperties) {
        this.setImageProperties(imageProperties);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLabels() != null) {
            sb.append("Labels: ").append(this.getLabels()).append(",");
        }
        if (this.getOrientationCorrection() != null) {
            sb.append("OrientationCorrection: ").append(this.getOrientationCorrection()).append(",");
        }
        if (this.getLabelModelVersion() != null) {
            sb.append("LabelModelVersion: ").append(this.getLabelModelVersion()).append(",");
        }
        if (this.getImageProperties() != null) {
            sb.append("ImageProperties: ").append(this.getImageProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectLabelsResult)) {
            return false;
        }
        DetectLabelsResult other = (DetectLabelsResult)obj;
        if (other.getLabels() == null ^ this.getLabels() == null) {
            return false;
        }
        if (other.getLabels() != null && !other.getLabels().equals(this.getLabels())) {
            return false;
        }
        if (other.getOrientationCorrection() == null ^ this.getOrientationCorrection() == null) {
            return false;
        }
        if (other.getOrientationCorrection() != null && !other.getOrientationCorrection().equals(this.getOrientationCorrection())) {
            return false;
        }
        if (other.getLabelModelVersion() == null ^ this.getLabelModelVersion() == null) {
            return false;
        }
        if (other.getLabelModelVersion() != null && !other.getLabelModelVersion().equals(this.getLabelModelVersion())) {
            return false;
        }
        if (other.getImageProperties() == null ^ this.getImageProperties() == null) {
            return false;
        }
        return other.getImageProperties() == null || other.getImageProperties().equals(this.getImageProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLabels() == null ? 0 : this.getLabels().hashCode());
        hashCode = 31 * hashCode + (this.getOrientationCorrection() == null ? 0 : this.getOrientationCorrection().hashCode());
        hashCode = 31 * hashCode + (this.getLabelModelVersion() == null ? 0 : this.getLabelModelVersion().hashCode());
        hashCode = 31 * hashCode + (this.getImageProperties() == null ? 0 : this.getImageProperties().hashCode());
        return hashCode;
    }

    public DetectLabelsResult clone() {
        try {
            return (DetectLabelsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

