/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.services.rekognition.model.S3Object;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class S3ObjectJsonUnmarshaller
implements Unmarshaller<S3Object, JsonUnmarshallerContext> {
    private static S3ObjectJsonUnmarshaller instance;

    public S3Object unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3Object s3Object = new S3Object();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Bucket", targetDepth)) {
                    context.nextToken();
                    s3Object.setBucket((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    s3Object.setName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Version", targetDepth)) {
                    context.nextToken();
                    s3Object.setVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return s3Object;
    }

    public static S3ObjectJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3ObjectJsonUnmarshaller();
        }
        return instance;
    }
}

