/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.redshiftdataapi.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Information about an SQL statement.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/SubStatementData" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SubStatementData implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The date and time (UTC) the statement was created.
     * </p>
     */
    private java.util.Date createdAt;
    /**
     * <p>
     * The amount of time in nanoseconds that the statement ran.
     * </p>
     */
    private Long duration;
    /**
     * <p>
     * The error message from the cluster if the SQL statement encountered an error while running.
     * </p>
     */
    private String error;
    /**
     * <p>
     * A value that indicates whether the statement has a result set. The result set can be empty. The value is true for
     * an empty result set.
     * </p>
     */
    private Boolean hasResultSet;
    /**
     * <p>
     * The identifier of the SQL statement. This value is a universally unique identifier (UUID) generated by Amazon
     * Redshift Data API. A suffix indicates the number of the SQL statement. For example,
     * <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL
     * statement of a batch query.
     * </p>
     */
    private String id;
    /**
     * <p>
     * The SQL statement text.
     * </p>
     */
    private String queryString;
    /**
     * <p>
     * The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift
     * Data API.
     * </p>
     */
    private Long redshiftQueryId;
    /**
     * <p>
     * Either the number of rows returned from the SQL statement or the number of rows affected. If result size is
     * greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE,
     * DELETE, COPY, and others. A <code>-1</code> indicates the value is null.
     * </p>
     */
    private Long resultRows;
    /**
     * <p>
     * The size in bytes of the returned results. A <code>-1</code> indicates the value is null.
     * </p>
     */
    private Long resultSize;
    /**
     * <p>
     * The status of the SQL statement. An example is the that the SQL statement finished.
     * </p>
     */
    private String status;
    /**
     * <p>
     * The date and time (UTC) that the statement metadata was last updated.
     * </p>
     */
    private java.util.Date updatedAt;

    /**
     * <p>
     * The date and time (UTC) the statement was created.
     * </p>
     * 
     * @param createdAt
     *        The date and time (UTC) the statement was created.
     */

    public void setCreatedAt(java.util.Date createdAt) {
        this.createdAt = createdAt;
    }

    /**
     * <p>
     * The date and time (UTC) the statement was created.
     * </p>
     * 
     * @return The date and time (UTC) the statement was created.
     */

    public java.util.Date getCreatedAt() {
        return this.createdAt;
    }

    /**
     * <p>
     * The date and time (UTC) the statement was created.
     * </p>
     * 
     * @param createdAt
     *        The date and time (UTC) the statement was created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SubStatementData withCreatedAt(java.util.Date createdAt) {
        setCreatedAt(createdAt);
        return this;
    }

    /**
     * <p>
     * The amount of time in nanoseconds that the statement ran.
     * </p>
     * 
     * @param duration
     *        The amount of time in nanoseconds that the statement ran.
     */

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    /**
     * <p>
     * The amount of time in nanoseconds that the statement ran.
     * </p>
     * 
     * @return The amount of time in nanoseconds that the statement ran.
     */

    public Long getDuration() {
        return this.duration;
    }

    /**
     * <p>
     * The amount of time in nanoseconds that the statement ran.
     * </p>
     * 
     * @param duration
     *        The amount of time in nanoseconds that the statement ran.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SubStatementData withDuration(Long duration) {
        setDuration(duration);
        return this;
    }

    /**
     * <p>
     * The error message from the cluster if the SQL statement encountered an error while running.
     * </p>
     * 
     * @param error
     *        The error message from the cluster if the SQL statement encountered an error while running.
     */

    public void setError(String error) {
        this.error = error;
    }

    /**
     * <p>
     * The error message from the cluster if the SQL statement encountered an error while running.
     * </p>
     * 
     * @return The error message from the cluster if the SQL statement encountered an error while running.
     */

    public String getError() {
        return this.error;
    }

    /**
     * <p>
     * The error message from the cluster if the SQL statement encountered an error while running.
     * </p>
     * 
     * @param error
     *        The error message from the cluster if the SQL statement encountered an error while running.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SubStatementData withError(String error) {
        setError(error);
        return this;
    }

    /**
     * <p>
     * A value that indicates whether the statement has a result set. The result set can be empty. The value is true for
     * an empty result set.
     * </p>
     * 
     * @param hasResultSet
     *        A value that indicates whether the statement has a result set. The result set can be empty. The value is
     *        true for an empty result set.
     */

    public void setHasResultSet(Boolean hasResultSet) {
        this.hasResultSet = hasResultSet;
    }

    /**
     * <p>
     * A value that indicates whether the statement has a result set. The result set can be empty. The value is true for
     * an empty result set.
     * </p>
     * 
     * @return A value that indicates whether the statement has a result set. The result set can be empty. The value is
     *         true for an empty result set.
     */

    public Boolean getHasResultSet() {
        return this.hasResultSet;
    }

    /**
     * <p>
     * A value that indicates whether the statement has a result set. The result set can be empty. The value is true for
     * an empty result set.
     * </p>
     * 
     * @param hasResultSet
     *        A value that indicates whether the statement has a result set. The result set can be empty. The value is
     *        true for an empty result set.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SubStatementData withHasResultSet(Boolean hasResultSet) {
        setHasResultSet(hasResultSet);
        return this;
    }

    /**
     * <p>
     * A value that indicates whether the statement has a result set. The result set can be empty. The value is true for
     * an empty result set.
     * </p>
     * 
     * @return A value that indicates whether the statement has a result set. The result set can be empty. The value is
     *         true for an empty result set.
     */

    public Boolean isHasResultSet() {
        return this.hasResultSet;
    }

    /**
     * <p>
     * The identifier of the SQL statement. This value is a universally unique identifier (UUID) generated by Amazon
     * Redshift Data API. A suffix indicates the number of the SQL statement. For example,
     * <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL
     * statement of a batch query.
     * </p>
     * 
     * @param id
     *        The identifier of the SQL statement. This value is a universally unique identifier (UUID) generated by
     *        Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example,
     *        <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the
     *        second SQL statement of a batch query.
     */

    public void setId(String id) {
        this.id = id;
    }

    /**
     * <p>
     * The identifier of the SQL statement. This value is a universally unique identifier (UUID) generated by Amazon
     * Redshift Data API. A suffix indicates the number of the SQL statement. For example,
     * <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL
     * statement of a batch query.
     * </p>
     * 
     * @return The identifier of the SQL statement. This value is a universally unique identifier (UUID) generated by
     *         Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example,
     *         <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the
     *         second SQL statement of a batch query.
     */

    public String getId() {
        return this.id;
    }

    /**
     * <p>
     * The identifier of the SQL statement. This value is a universally unique identifier (UUID) generated by Amazon
     * Redshift Data API. A suffix indicates the number of the SQL statement. For example,
     * <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL
     * statement of a batch query.
     * </p>
     * 
     * @param id
     *        The identifier of the SQL statement. This value is a universally unique identifier (UUID) generated by
     *        Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example,
     *        <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the
     *        second SQL statement of a batch query.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SubStatementData withId(String id) {
        setId(id);
        return this;
    }

    /**
     * <p>
     * The SQL statement text.
     * </p>
     * 
     * @param queryString
     *        The SQL statement text.
     */

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    /**
     * <p>
     * The SQL statement text.
     * </p>
     * 
     * @return The SQL statement text.
     */

    public String getQueryString() {
        return this.queryString;
    }

    /**
     * <p>
     * The SQL statement text.
     * </p>
     * 
     * @param queryString
     *        The SQL statement text.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SubStatementData withQueryString(String queryString) {
        setQueryString(queryString);
        return this;
    }

    /**
     * <p>
     * The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift
     * Data API.
     * </p>
     * 
     * @param redshiftQueryId
     *        The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon
     *        Redshift Data API.
     */

    public void setRedshiftQueryId(Long redshiftQueryId) {
        this.redshiftQueryId = redshiftQueryId;
    }

    /**
     * <p>
     * The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift
     * Data API.
     * </p>
     * 
     * @return The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon
     *         Redshift Data API.
     */

    public Long getRedshiftQueryId() {
        return this.redshiftQueryId;
    }

    /**
     * <p>
     * The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift
     * Data API.
     * </p>
     * 
     * @param redshiftQueryId
     *        The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon
     *        Redshift Data API.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SubStatementData withRedshiftQueryId(Long redshiftQueryId) {
        setRedshiftQueryId(redshiftQueryId);
        return this;
    }

    /**
     * <p>
     * Either the number of rows returned from the SQL statement or the number of rows affected. If result size is
     * greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE,
     * DELETE, COPY, and others. A <code>-1</code> indicates the value is null.
     * </p>
     * 
     * @param resultRows
     *        Either the number of rows returned from the SQL statement or the number of rows affected. If result size
     *        is greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT,
     *        UPDATE, DELETE, COPY, and others. A <code>-1</code> indicates the value is null.
     */

    public void setResultRows(Long resultRows) {
        this.resultRows = resultRows;
    }

    /**
     * <p>
     * Either the number of rows returned from the SQL statement or the number of rows affected. If result size is
     * greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE,
     * DELETE, COPY, and others. A <code>-1</code> indicates the value is null.
     * </p>
     * 
     * @return Either the number of rows returned from the SQL statement or the number of rows affected. If result size
     *         is greater than zero, the result rows can be the number of rows affected by SQL statements such as
     *         INSERT, UPDATE, DELETE, COPY, and others. A <code>-1</code> indicates the value is null.
     */

    public Long getResultRows() {
        return this.resultRows;
    }

    /**
     * <p>
     * Either the number of rows returned from the SQL statement or the number of rows affected. If result size is
     * greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE,
     * DELETE, COPY, and others. A <code>-1</code> indicates the value is null.
     * </p>
     * 
     * @param resultRows
     *        Either the number of rows returned from the SQL statement or the number of rows affected. If result size
     *        is greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT,
     *        UPDATE, DELETE, COPY, and others. A <code>-1</code> indicates the value is null.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SubStatementData withResultRows(Long resultRows) {
        setResultRows(resultRows);
        return this;
    }

    /**
     * <p>
     * The size in bytes of the returned results. A <code>-1</code> indicates the value is null.
     * </p>
     * 
     * @param resultSize
     *        The size in bytes of the returned results. A <code>-1</code> indicates the value is null.
     */

    public void setResultSize(Long resultSize) {
        this.resultSize = resultSize;
    }

    /**
     * <p>
     * The size in bytes of the returned results. A <code>-1</code> indicates the value is null.
     * </p>
     * 
     * @return The size in bytes of the returned results. A <code>-1</code> indicates the value is null.
     */

    public Long getResultSize() {
        return this.resultSize;
    }

    /**
     * <p>
     * The size in bytes of the returned results. A <code>-1</code> indicates the value is null.
     * </p>
     * 
     * @param resultSize
     *        The size in bytes of the returned results. A <code>-1</code> indicates the value is null.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SubStatementData withResultSize(Long resultSize) {
        setResultSize(resultSize);
        return this;
    }

    /**
     * <p>
     * The status of the SQL statement. An example is the that the SQL statement finished.
     * </p>
     * 
     * @param status
     *        The status of the SQL statement. An example is the that the SQL statement finished.
     * @see StatementStatusString
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * The status of the SQL statement. An example is the that the SQL statement finished.
     * </p>
     * 
     * @return The status of the SQL statement. An example is the that the SQL statement finished.
     * @see StatementStatusString
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The status of the SQL statement. An example is the that the SQL statement finished.
     * </p>
     * 
     * @param status
     *        The status of the SQL statement. An example is the that the SQL statement finished.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see StatementStatusString
     */

    public SubStatementData withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * The status of the SQL statement. An example is the that the SQL statement finished.
     * </p>
     * 
     * @param status
     *        The status of the SQL statement. An example is the that the SQL statement finished.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see StatementStatusString
     */

    public SubStatementData withStatus(StatementStatusString status) {
        this.status = status.toString();
        return this;
    }

    /**
     * <p>
     * The date and time (UTC) that the statement metadata was last updated.
     * </p>
     * 
     * @param updatedAt
     *        The date and time (UTC) that the statement metadata was last updated.
     */

    public void setUpdatedAt(java.util.Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    /**
     * <p>
     * The date and time (UTC) that the statement metadata was last updated.
     * </p>
     * 
     * @return The date and time (UTC) that the statement metadata was last updated.
     */

    public java.util.Date getUpdatedAt() {
        return this.updatedAt;
    }

    /**
     * <p>
     * The date and time (UTC) that the statement metadata was last updated.
     * </p>
     * 
     * @param updatedAt
     *        The date and time (UTC) that the statement metadata was last updated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SubStatementData withUpdatedAt(java.util.Date updatedAt) {
        setUpdatedAt(updatedAt);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCreatedAt() != null)
            sb.append("CreatedAt: ").append(getCreatedAt()).append(",");
        if (getDuration() != null)
            sb.append("Duration: ").append(getDuration()).append(",");
        if (getError() != null)
            sb.append("Error: ").append(getError()).append(",");
        if (getHasResultSet() != null)
            sb.append("HasResultSet: ").append(getHasResultSet()).append(",");
        if (getId() != null)
            sb.append("Id: ").append(getId()).append(",");
        if (getQueryString() != null)
            sb.append("QueryString: ").append(getQueryString()).append(",");
        if (getRedshiftQueryId() != null)
            sb.append("RedshiftQueryId: ").append(getRedshiftQueryId()).append(",");
        if (getResultRows() != null)
            sb.append("ResultRows: ").append(getResultRows()).append(",");
        if (getResultSize() != null)
            sb.append("ResultSize: ").append(getResultSize()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getUpdatedAt() != null)
            sb.append("UpdatedAt: ").append(getUpdatedAt());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof SubStatementData == false)
            return false;
        SubStatementData other = (SubStatementData) obj;
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null)
            return false;
        if (other.getCreatedAt() != null && other.getCreatedAt().equals(this.getCreatedAt()) == false)
            return false;
        if (other.getDuration() == null ^ this.getDuration() == null)
            return false;
        if (other.getDuration() != null && other.getDuration().equals(this.getDuration()) == false)
            return false;
        if (other.getError() == null ^ this.getError() == null)
            return false;
        if (other.getError() != null && other.getError().equals(this.getError()) == false)
            return false;
        if (other.getHasResultSet() == null ^ this.getHasResultSet() == null)
            return false;
        if (other.getHasResultSet() != null && other.getHasResultSet().equals(this.getHasResultSet()) == false)
            return false;
        if (other.getId() == null ^ this.getId() == null)
            return false;
        if (other.getId() != null && other.getId().equals(this.getId()) == false)
            return false;
        if (other.getQueryString() == null ^ this.getQueryString() == null)
            return false;
        if (other.getQueryString() != null && other.getQueryString().equals(this.getQueryString()) == false)
            return false;
        if (other.getRedshiftQueryId() == null ^ this.getRedshiftQueryId() == null)
            return false;
        if (other.getRedshiftQueryId() != null && other.getRedshiftQueryId().equals(this.getRedshiftQueryId()) == false)
            return false;
        if (other.getResultRows() == null ^ this.getResultRows() == null)
            return false;
        if (other.getResultRows() != null && other.getResultRows().equals(this.getResultRows()) == false)
            return false;
        if (other.getResultSize() == null ^ this.getResultSize() == null)
            return false;
        if (other.getResultSize() != null && other.getResultSize().equals(this.getResultSize()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getUpdatedAt() == null ^ this.getUpdatedAt() == null)
            return false;
        if (other.getUpdatedAt() != null && other.getUpdatedAt().equals(this.getUpdatedAt()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCreatedAt() == null) ? 0 : getCreatedAt().hashCode());
        hashCode = prime * hashCode + ((getDuration() == null) ? 0 : getDuration().hashCode());
        hashCode = prime * hashCode + ((getError() == null) ? 0 : getError().hashCode());
        hashCode = prime * hashCode + ((getHasResultSet() == null) ? 0 : getHasResultSet().hashCode());
        hashCode = prime * hashCode + ((getId() == null) ? 0 : getId().hashCode());
        hashCode = prime * hashCode + ((getQueryString() == null) ? 0 : getQueryString().hashCode());
        hashCode = prime * hashCode + ((getRedshiftQueryId() == null) ? 0 : getRedshiftQueryId().hashCode());
        hashCode = prime * hashCode + ((getResultRows() == null) ? 0 : getResultRows().hashCode());
        hashCode = prime * hashCode + ((getResultSize() == null) ? 0 : getResultSize().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getUpdatedAt() == null) ? 0 : getUpdatedAt().hashCode());
        return hashCode;
    }

    @Override
    public SubStatementData clone() {
        try {
            return (SubStatementData) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.redshiftdataapi.model.transform.SubStatementDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
