/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.redshiftdataapi.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/DescribeStatement" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeStatementRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The identifier of the SQL statement to describe. This value is a universally unique identifier (UUID) generated
     * by Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example,
     * <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL
     * statement of a batch query. This identifier is returned by <code>BatchExecuteStatment</code>,
     * <code>ExecuteStatement</code>, and <code>ListStatements</code>.
     * </p>
     */
    private String id;

    /**
     * <p>
     * The identifier of the SQL statement to describe. This value is a universally unique identifier (UUID) generated
     * by Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example,
     * <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL
     * statement of a batch query. This identifier is returned by <code>BatchExecuteStatment</code>,
     * <code>ExecuteStatement</code>, and <code>ListStatements</code>.
     * </p>
     * 
     * @param id
     *        The identifier of the SQL statement to describe. This value is a universally unique identifier (UUID)
     *        generated by Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example,
     *        <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the
     *        second SQL statement of a batch query. This identifier is returned by <code>BatchExecuteStatment</code>,
     *        <code>ExecuteStatement</code>, and <code>ListStatements</code>.
     */

    public void setId(String id) {
        this.id = id;
    }

    /**
     * <p>
     * The identifier of the SQL statement to describe. This value is a universally unique identifier (UUID) generated
     * by Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example,
     * <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL
     * statement of a batch query. This identifier is returned by <code>BatchExecuteStatment</code>,
     * <code>ExecuteStatement</code>, and <code>ListStatements</code>.
     * </p>
     * 
     * @return The identifier of the SQL statement to describe. This value is a universally unique identifier (UUID)
     *         generated by Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example,
     *         <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the
     *         second SQL statement of a batch query. This identifier is returned by <code>BatchExecuteStatment</code>,
     *         <code>ExecuteStatement</code>, and <code>ListStatements</code>.
     */

    public String getId() {
        return this.id;
    }

    /**
     * <p>
     * The identifier of the SQL statement to describe. This value is a universally unique identifier (UUID) generated
     * by Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example,
     * <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL
     * statement of a batch query. This identifier is returned by <code>BatchExecuteStatment</code>,
     * <code>ExecuteStatement</code>, and <code>ListStatements</code>.
     * </p>
     * 
     * @param id
     *        The identifier of the SQL statement to describe. This value is a universally unique identifier (UUID)
     *        generated by Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example,
     *        <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the
     *        second SQL statement of a batch query. This identifier is returned by <code>BatchExecuteStatment</code>,
     *        <code>ExecuteStatement</code>, and <code>ListStatements</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStatementRequest withId(String id) {
        setId(id);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getId() != null)
            sb.append("Id: ").append(getId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeStatementRequest == false)
            return false;
        DescribeStatementRequest other = (DescribeStatementRequest) obj;
        if (other.getId() == null ^ this.getId() == null)
            return false;
        if (other.getId() != null && other.getId().equals(this.getId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getId() == null) ? 0 : getId().hashCode());
        return hashCode;
    }

    @Override
    public DescribeStatementRequest clone() {
        return (DescribeStatementRequest) super.clone();
    }

}
