/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.services.redshift.model.Association;
import com.amazonaws.services.redshift.model.CertificateAssociation;
import com.amazonaws.services.redshift.model.transform.CertificateAssociationStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class AssociationStaxUnmarshaller
implements Unmarshaller<Association, StaxUnmarshallerContext> {
    private static AssociationStaxUnmarshaller instance;

    public Association unmarshall(StaxUnmarshallerContext context) throws Exception {
        Association association = new Association();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return association;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CustomDomainCertificateArn", targetDepth)) {
                    association.setCustomDomainCertificateArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CustomDomainCertificateExpiryDate", targetDepth)) {
                    association.setCustomDomainCertificateExpiryDate(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("CertificateAssociations", targetDepth)) {
                    association.withCertificateAssociations(new ArrayList<CertificateAssociation>());
                    continue;
                }
                if (!context.testExpression("CertificateAssociations/CertificateAssociation", targetDepth)) continue;
                association.withCertificateAssociations(CertificateAssociationStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return association;
    }

    public static AssociationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AssociationStaxUnmarshaller();
        }
        return instance;
    }
}

