/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.IntegrationError;
import com.amazonaws.services.redshift.model.ZeroETLIntegrationStatus;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class InboundIntegration
implements Serializable,
Cloneable {
    private String integrationArn;
    private String sourceArn;
    private String targetArn;
    private String status;
    private SdkInternalList<IntegrationError> errors;
    private Date createTime;

    public void setIntegrationArn(String integrationArn) {
        this.integrationArn = integrationArn;
    }

    public String getIntegrationArn() {
        return this.integrationArn;
    }

    public InboundIntegration withIntegrationArn(String integrationArn) {
        this.setIntegrationArn(integrationArn);
        return this;
    }

    public void setSourceArn(String sourceArn) {
        this.sourceArn = sourceArn;
    }

    public String getSourceArn() {
        return this.sourceArn;
    }

    public InboundIntegration withSourceArn(String sourceArn) {
        this.setSourceArn(sourceArn);
        return this;
    }

    public void setTargetArn(String targetArn) {
        this.targetArn = targetArn;
    }

    public String getTargetArn() {
        return this.targetArn;
    }

    public InboundIntegration withTargetArn(String targetArn) {
        this.setTargetArn(targetArn);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public InboundIntegration withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public InboundIntegration withStatus(ZeroETLIntegrationStatus status) {
        this.status = status.toString();
        return this;
    }

    public List<IntegrationError> getErrors() {
        if (this.errors == null) {
            this.errors = new SdkInternalList();
        }
        return this.errors;
    }

    public void setErrors(Collection<IntegrationError> errors) {
        if (errors == null) {
            this.errors = null;
            return;
        }
        this.errors = new SdkInternalList(errors);
    }

    public InboundIntegration withErrors(IntegrationError ... errors) {
        if (this.errors == null) {
            this.setErrors((Collection<IntegrationError>)new SdkInternalList(errors.length));
        }
        for (IntegrationError ele : errors) {
            this.errors.add((Object)ele);
        }
        return this;
    }

    public InboundIntegration withErrors(Collection<IntegrationError> errors) {
        this.setErrors(errors);
        return this;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public InboundIntegration withCreateTime(Date createTime) {
        this.setCreateTime(createTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIntegrationArn() != null) {
            sb.append("IntegrationArn: ").append(this.getIntegrationArn()).append(",");
        }
        if (this.getSourceArn() != null) {
            sb.append("SourceArn: ").append(this.getSourceArn()).append(",");
        }
        if (this.getTargetArn() != null) {
            sb.append("TargetArn: ").append(this.getTargetArn()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getErrors() != null) {
            sb.append("Errors: ").append(this.getErrors()).append(",");
        }
        if (this.getCreateTime() != null) {
            sb.append("CreateTime: ").append(this.getCreateTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InboundIntegration)) {
            return false;
        }
        InboundIntegration other = (InboundIntegration)obj;
        if (other.getIntegrationArn() == null ^ this.getIntegrationArn() == null) {
            return false;
        }
        if (other.getIntegrationArn() != null && !other.getIntegrationArn().equals(this.getIntegrationArn())) {
            return false;
        }
        if (other.getSourceArn() == null ^ this.getSourceArn() == null) {
            return false;
        }
        if (other.getSourceArn() != null && !other.getSourceArn().equals(this.getSourceArn())) {
            return false;
        }
        if (other.getTargetArn() == null ^ this.getTargetArn() == null) {
            return false;
        }
        if (other.getTargetArn() != null && !other.getTargetArn().equals(this.getTargetArn())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getErrors() == null ^ this.getErrors() == null) {
            return false;
        }
        if (other.getErrors() != null && !other.getErrors().equals(this.getErrors())) {
            return false;
        }
        if (other.getCreateTime() == null ^ this.getCreateTime() == null) {
            return false;
        }
        return other.getCreateTime() == null || other.getCreateTime().equals(this.getCreateTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIntegrationArn() == null ? 0 : this.getIntegrationArn().hashCode());
        hashCode = 31 * hashCode + (this.getSourceArn() == null ? 0 : this.getSourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getTargetArn() == null ? 0 : this.getTargetArn().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getErrors() == null ? 0 : this.getErrors().hashCode());
        hashCode = 31 * hashCode + (this.getCreateTime() == null ? 0 : this.getCreateTime().hashCode());
        return hashCode;
    }

    public InboundIntegration clone() {
        try {
            return (InboundIntegration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

