/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.AuthorizedTokenIssuer;
import com.amazonaws.services.redshift.model.CreateRedshiftIdcApplicationRequest;
import com.amazonaws.services.redshift.model.LakeFormationQuery;
import com.amazonaws.services.redshift.model.LakeFormationScopeUnion;
import com.amazonaws.services.redshift.model.ServiceIntegrationsUnion;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateRedshiftIdcApplicationRequestMarshaller
implements Marshaller<Request<CreateRedshiftIdcApplicationRequest>, CreateRedshiftIdcApplicationRequest> {
    public Request<CreateRedshiftIdcApplicationRequest> marshall(CreateRedshiftIdcApplicationRequest createRedshiftIdcApplicationRequest) {
        if (createRedshiftIdcApplicationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createRedshiftIdcApplicationRequest, "AmazonRedshift");
        request.addParameter("Action", "CreateRedshiftIdcApplication");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createRedshiftIdcApplicationRequest.getIdcInstanceArn() != null) {
            request.addParameter("IdcInstanceArn", StringUtils.fromString((String)createRedshiftIdcApplicationRequest.getIdcInstanceArn()));
        }
        if (createRedshiftIdcApplicationRequest.getRedshiftIdcApplicationName() != null) {
            request.addParameter("RedshiftIdcApplicationName", StringUtils.fromString((String)createRedshiftIdcApplicationRequest.getRedshiftIdcApplicationName()));
        }
        if (createRedshiftIdcApplicationRequest.getIdentityNamespace() != null) {
            request.addParameter("IdentityNamespace", StringUtils.fromString((String)createRedshiftIdcApplicationRequest.getIdentityNamespace()));
        }
        if (createRedshiftIdcApplicationRequest.getIdcDisplayName() != null) {
            request.addParameter("IdcDisplayName", StringUtils.fromString((String)createRedshiftIdcApplicationRequest.getIdcDisplayName()));
        }
        if (createRedshiftIdcApplicationRequest.getIamRoleArn() != null) {
            request.addParameter("IamRoleArn", StringUtils.fromString((String)createRedshiftIdcApplicationRequest.getIamRoleArn()));
        }
        if (!createRedshiftIdcApplicationRequest.getAuthorizedTokenIssuerList().isEmpty() || !((SdkInternalList)createRedshiftIdcApplicationRequest.getAuthorizedTokenIssuerList()).isAutoConstruct()) {
            SdkInternalList authorizedTokenIssuerListList = (SdkInternalList)createRedshiftIdcApplicationRequest.getAuthorizedTokenIssuerList();
            int authorizedTokenIssuerListListIndex = 1;
            for (AuthorizedTokenIssuer authorizedTokenIssuerListListValue : authorizedTokenIssuerListList) {
                if (authorizedTokenIssuerListListValue != null) {
                    if (authorizedTokenIssuerListListValue.getTrustedTokenIssuerArn() != null) {
                        request.addParameter("AuthorizedTokenIssuerList.member." + authorizedTokenIssuerListListIndex + ".TrustedTokenIssuerArn", StringUtils.fromString((String)authorizedTokenIssuerListListValue.getTrustedTokenIssuerArn()));
                    }
                    if (!authorizedTokenIssuerListListValue.getAuthorizedAudiencesList().isEmpty() || !((SdkInternalList)authorizedTokenIssuerListListValue.getAuthorizedAudiencesList()).isAutoConstruct()) {
                        SdkInternalList authorizedAudiencesListList = (SdkInternalList)authorizedTokenIssuerListListValue.getAuthorizedAudiencesList();
                        int authorizedAudiencesListListIndex = 1;
                        for (String authorizedAudiencesListListValue : authorizedAudiencesListList) {
                            if (authorizedAudiencesListListValue != null) {
                                request.addParameter("AuthorizedTokenIssuerList.member." + authorizedTokenIssuerListListIndex + ".AuthorizedAudiencesList.member." + authorizedAudiencesListListIndex, StringUtils.fromString((String)authorizedAudiencesListListValue));
                            }
                            ++authorizedAudiencesListListIndex;
                        }
                    }
                }
                ++authorizedTokenIssuerListListIndex;
            }
        }
        if (!createRedshiftIdcApplicationRequest.getServiceIntegrations().isEmpty() || !((SdkInternalList)createRedshiftIdcApplicationRequest.getServiceIntegrations()).isAutoConstruct()) {
            SdkInternalList serviceIntegrationsList = (SdkInternalList)createRedshiftIdcApplicationRequest.getServiceIntegrations();
            int serviceIntegrationsListIndex = 1;
            for (ServiceIntegrationsUnion serviceIntegrationsListValue : serviceIntegrationsList) {
                if (!(serviceIntegrationsListValue == null || serviceIntegrationsListValue.getLakeFormation().isEmpty() && ((SdkInternalList)serviceIntegrationsListValue.getLakeFormation()).isAutoConstruct())) {
                    SdkInternalList lakeFormationList = (SdkInternalList)serviceIntegrationsListValue.getLakeFormation();
                    int lakeFormationListIndex = 1;
                    for (LakeFormationScopeUnion lakeFormationListValue : lakeFormationList) {
                        LakeFormationQuery lakeFormationQuery;
                        if (lakeFormationListValue != null && (lakeFormationQuery = lakeFormationListValue.getLakeFormationQuery()) != null && lakeFormationQuery.getAuthorization() != null) {
                            request.addParameter("ServiceIntegrations.member." + serviceIntegrationsListIndex + ".LakeFormation.member." + lakeFormationListIndex + ".LakeFormationQuery.Authorization", StringUtils.fromString((String)lakeFormationQuery.getAuthorization()));
                        }
                        ++lakeFormationListIndex;
                    }
                }
                ++serviceIntegrationsListIndex;
            }
        }
        return request;
    }
}

