/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.redshift.model.ResizeClusterRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ResizeClusterRequestMarshaller
implements Marshaller<Request<ResizeClusterRequest>, ResizeClusterRequest> {
    public Request<ResizeClusterRequest> marshall(ResizeClusterRequest resizeClusterRequest) {
        if (resizeClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)resizeClusterRequest, "AmazonRedshift");
        request.addParameter("Action", "ResizeCluster");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (resizeClusterRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)resizeClusterRequest.getClusterIdentifier()));
        }
        if (resizeClusterRequest.getClusterType() != null) {
            request.addParameter("ClusterType", StringUtils.fromString((String)resizeClusterRequest.getClusterType()));
        }
        if (resizeClusterRequest.getNodeType() != null) {
            request.addParameter("NodeType", StringUtils.fromString((String)resizeClusterRequest.getNodeType()));
        }
        if (resizeClusterRequest.getNumberOfNodes() != null) {
            request.addParameter("NumberOfNodes", StringUtils.fromInteger((Integer)resizeClusterRequest.getNumberOfNodes()));
        }
        if (resizeClusterRequest.getClassic() != null) {
            request.addParameter("Classic", StringUtils.fromBoolean((Boolean)resizeClusterRequest.getClassic()));
        }
        if (resizeClusterRequest.getReservedNodeId() != null) {
            request.addParameter("ReservedNodeId", StringUtils.fromString((String)resizeClusterRequest.getReservedNodeId()));
        }
        if (resizeClusterRequest.getTargetReservedNodeOfferingId() != null) {
            request.addParameter("TargetReservedNodeOfferingId", StringUtils.fromString((String)resizeClusterRequest.getTargetReservedNodeOfferingId()));
        }
        return request;
    }
}

