/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.services.redshift.model.EndpointAuthorization;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class EndpointAuthorizationStaxUnmarshaller
implements Unmarshaller<EndpointAuthorization, StaxUnmarshallerContext> {
    private static EndpointAuthorizationStaxUnmarshaller instance;

    public EndpointAuthorization unmarshall(StaxUnmarshallerContext context) throws Exception {
        EndpointAuthorization endpointAuthorization = new EndpointAuthorization();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return endpointAuthorization;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Grantor", targetDepth)) {
                    endpointAuthorization.setGrantor(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Grantee", targetDepth)) {
                    endpointAuthorization.setGrantee(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ClusterIdentifier", targetDepth)) {
                    endpointAuthorization.setClusterIdentifier(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AuthorizeTime", targetDepth)) {
                    endpointAuthorization.setAuthorizeTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("ClusterStatus", targetDepth)) {
                    endpointAuthorization.setClusterStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    endpointAuthorization.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AllowedAllVPCs", targetDepth)) {
                    endpointAuthorization.setAllowedAllVPCs(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AllowedVPCs", targetDepth)) {
                    endpointAuthorization.withAllowedVPCs(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("AllowedVPCs/VpcIdentifier", targetDepth)) {
                    endpointAuthorization.withAllowedVPCs(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("EndpointCount", targetDepth)) continue;
                endpointAuthorization.setEndpointCount(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return endpointAuthorization;
    }

    public static EndpointAuthorizationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EndpointAuthorizationStaxUnmarshaller();
        }
        return instance;
    }
}

