/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.DescribeNodeConfigurationOptionsRequest;
import com.amazonaws.services.redshift.model.NodeConfigurationOptionsFilter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeNodeConfigurationOptionsRequestMarshaller
implements Marshaller<Request<DescribeNodeConfigurationOptionsRequest>, DescribeNodeConfigurationOptionsRequest> {
    public Request<DescribeNodeConfigurationOptionsRequest> marshall(DescribeNodeConfigurationOptionsRequest describeNodeConfigurationOptionsRequest) {
        if (describeNodeConfigurationOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeNodeConfigurationOptionsRequest, "AmazonRedshift");
        request.addParameter("Action", "DescribeNodeConfigurationOptions");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeNodeConfigurationOptionsRequest.getActionType() != null) {
            request.addParameter("ActionType", StringUtils.fromString((String)describeNodeConfigurationOptionsRequest.getActionType()));
        }
        if (describeNodeConfigurationOptionsRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)describeNodeConfigurationOptionsRequest.getClusterIdentifier()));
        }
        if (describeNodeConfigurationOptionsRequest.getSnapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringUtils.fromString((String)describeNodeConfigurationOptionsRequest.getSnapshotIdentifier()));
        }
        if (describeNodeConfigurationOptionsRequest.getOwnerAccount() != null) {
            request.addParameter("OwnerAccount", StringUtils.fromString((String)describeNodeConfigurationOptionsRequest.getOwnerAccount()));
        }
        if (!describeNodeConfigurationOptionsRequest.getFilters().isEmpty() || !((SdkInternalList)describeNodeConfigurationOptionsRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeNodeConfigurationOptionsRequest.getFilters();
            int filtersListIndex = 1;
            for (NodeConfigurationOptionsFilter filtersListValue : filtersList) {
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filter.NodeConfigurationOptionsFilter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                }
                if (filtersListValue.getOperator() != null) {
                    request.addParameter("Filter.NodeConfigurationOptionsFilter." + filtersListIndex + ".Operator", StringUtils.fromString((String)filtersListValue.getOperator()));
                }
                if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                    SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filter.NodeConfigurationOptionsFilter." + filtersListIndex + ".Value.item." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeNodeConfigurationOptionsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeNodeConfigurationOptionsRequest.getMarker()));
        }
        if (describeNodeConfigurationOptionsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeNodeConfigurationOptionsRequest.getMaxRecords()));
        }
        return request;
    }
}

