/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ModifyClusterRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clusterIdentifier;
    private String clusterType;
    private String nodeType;
    private Integer numberOfNodes;
    private SdkInternalList<String> clusterSecurityGroups;
    private SdkInternalList<String> vpcSecurityGroupIds;
    private String masterUserPassword;
    private String clusterParameterGroupName;
    private Integer automatedSnapshotRetentionPeriod;
    private String preferredMaintenanceWindow;
    private String clusterVersion;
    private Boolean allowVersionUpgrade;
    private String hsmClientCertificateIdentifier;
    private String hsmConfigurationIdentifier;
    private String newClusterIdentifier;
    private Boolean publiclyAccessible;
    private String elasticIp;
    private Boolean enhancedVpcRouting;

    public void setClusterIdentifier(String clusterIdentifier) {
        this.clusterIdentifier = clusterIdentifier;
    }

    public String getClusterIdentifier() {
        return this.clusterIdentifier;
    }

    public ModifyClusterRequest withClusterIdentifier(String clusterIdentifier) {
        this.setClusterIdentifier(clusterIdentifier);
        return this;
    }

    public void setClusterType(String clusterType) {
        this.clusterType = clusterType;
    }

    public String getClusterType() {
        return this.clusterType;
    }

    public ModifyClusterRequest withClusterType(String clusterType) {
        this.setClusterType(clusterType);
        return this;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public ModifyClusterRequest withNodeType(String nodeType) {
        this.setNodeType(nodeType);
        return this;
    }

    public void setNumberOfNodes(Integer numberOfNodes) {
        this.numberOfNodes = numberOfNodes;
    }

    public Integer getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public ModifyClusterRequest withNumberOfNodes(Integer numberOfNodes) {
        this.setNumberOfNodes(numberOfNodes);
        return this;
    }

    public List<String> getClusterSecurityGroups() {
        if (this.clusterSecurityGroups == null) {
            this.clusterSecurityGroups = new SdkInternalList();
        }
        return this.clusterSecurityGroups;
    }

    public void setClusterSecurityGroups(Collection<String> clusterSecurityGroups) {
        if (clusterSecurityGroups == null) {
            this.clusterSecurityGroups = null;
            return;
        }
        this.clusterSecurityGroups = new SdkInternalList(clusterSecurityGroups);
    }

    public ModifyClusterRequest withClusterSecurityGroups(String ... clusterSecurityGroups) {
        if (this.clusterSecurityGroups == null) {
            this.setClusterSecurityGroups((Collection<String>)new SdkInternalList(clusterSecurityGroups.length));
        }
        for (String ele : clusterSecurityGroups) {
            this.clusterSecurityGroups.add((Object)ele);
        }
        return this;
    }

    public ModifyClusterRequest withClusterSecurityGroups(Collection<String> clusterSecurityGroups) {
        this.setClusterSecurityGroups(clusterSecurityGroups);
        return this;
    }

    public List<String> getVpcSecurityGroupIds() {
        if (this.vpcSecurityGroupIds == null) {
            this.vpcSecurityGroupIds = new SdkInternalList();
        }
        return this.vpcSecurityGroupIds;
    }

    public void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
        if (vpcSecurityGroupIds == null) {
            this.vpcSecurityGroupIds = null;
            return;
        }
        this.vpcSecurityGroupIds = new SdkInternalList(vpcSecurityGroupIds);
    }

    public ModifyClusterRequest withVpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
        if (this.vpcSecurityGroupIds == null) {
            this.setVpcSecurityGroupIds((Collection<String>)new SdkInternalList(vpcSecurityGroupIds.length));
        }
        for (String ele : vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds.add((Object)ele);
        }
        return this;
    }

    public ModifyClusterRequest withVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
        this.setVpcSecurityGroupIds(vpcSecurityGroupIds);
        return this;
    }

    public void setMasterUserPassword(String masterUserPassword) {
        this.masterUserPassword = masterUserPassword;
    }

    public String getMasterUserPassword() {
        return this.masterUserPassword;
    }

    public ModifyClusterRequest withMasterUserPassword(String masterUserPassword) {
        this.setMasterUserPassword(masterUserPassword);
        return this;
    }

    public void setClusterParameterGroupName(String clusterParameterGroupName) {
        this.clusterParameterGroupName = clusterParameterGroupName;
    }

    public String getClusterParameterGroupName() {
        return this.clusterParameterGroupName;
    }

    public ModifyClusterRequest withClusterParameterGroupName(String clusterParameterGroupName) {
        this.setClusterParameterGroupName(clusterParameterGroupName);
        return this;
    }

    public void setAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
        this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
    }

    public Integer getAutomatedSnapshotRetentionPeriod() {
        return this.automatedSnapshotRetentionPeriod;
    }

    public ModifyClusterRequest withAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
        this.setAutomatedSnapshotRetentionPeriod(automatedSnapshotRetentionPeriod);
        return this;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public ModifyClusterRequest withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.setPreferredMaintenanceWindow(preferredMaintenanceWindow);
        return this;
    }

    public void setClusterVersion(String clusterVersion) {
        this.clusterVersion = clusterVersion;
    }

    public String getClusterVersion() {
        return this.clusterVersion;
    }

    public ModifyClusterRequest withClusterVersion(String clusterVersion) {
        this.setClusterVersion(clusterVersion);
        return this;
    }

    public void setAllowVersionUpgrade(Boolean allowVersionUpgrade) {
        this.allowVersionUpgrade = allowVersionUpgrade;
    }

    public Boolean getAllowVersionUpgrade() {
        return this.allowVersionUpgrade;
    }

    public ModifyClusterRequest withAllowVersionUpgrade(Boolean allowVersionUpgrade) {
        this.setAllowVersionUpgrade(allowVersionUpgrade);
        return this;
    }

    public Boolean isAllowVersionUpgrade() {
        return this.allowVersionUpgrade;
    }

    public void setHsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
        this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
    }

    public String getHsmClientCertificateIdentifier() {
        return this.hsmClientCertificateIdentifier;
    }

    public ModifyClusterRequest withHsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
        this.setHsmClientCertificateIdentifier(hsmClientCertificateIdentifier);
        return this;
    }

    public void setHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
        this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
    }

    public String getHsmConfigurationIdentifier() {
        return this.hsmConfigurationIdentifier;
    }

    public ModifyClusterRequest withHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
        this.setHsmConfigurationIdentifier(hsmConfigurationIdentifier);
        return this;
    }

    public void setNewClusterIdentifier(String newClusterIdentifier) {
        this.newClusterIdentifier = newClusterIdentifier;
    }

    public String getNewClusterIdentifier() {
        return this.newClusterIdentifier;
    }

    public ModifyClusterRequest withNewClusterIdentifier(String newClusterIdentifier) {
        this.setNewClusterIdentifier(newClusterIdentifier);
        return this;
    }

    public void setPubliclyAccessible(Boolean publiclyAccessible) {
        this.publiclyAccessible = publiclyAccessible;
    }

    public Boolean getPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public ModifyClusterRequest withPubliclyAccessible(Boolean publiclyAccessible) {
        this.setPubliclyAccessible(publiclyAccessible);
        return this;
    }

    public Boolean isPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public void setElasticIp(String elasticIp) {
        this.elasticIp = elasticIp;
    }

    public String getElasticIp() {
        return this.elasticIp;
    }

    public ModifyClusterRequest withElasticIp(String elasticIp) {
        this.setElasticIp(elasticIp);
        return this;
    }

    public void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
        this.enhancedVpcRouting = enhancedVpcRouting;
    }

    public Boolean getEnhancedVpcRouting() {
        return this.enhancedVpcRouting;
    }

    public ModifyClusterRequest withEnhancedVpcRouting(Boolean enhancedVpcRouting) {
        this.setEnhancedVpcRouting(enhancedVpcRouting);
        return this;
    }

    public Boolean isEnhancedVpcRouting() {
        return this.enhancedVpcRouting;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterIdentifier() != null) {
            sb.append("ClusterIdentifier: " + this.getClusterIdentifier() + ",");
        }
        if (this.getClusterType() != null) {
            sb.append("ClusterType: " + this.getClusterType() + ",");
        }
        if (this.getNodeType() != null) {
            sb.append("NodeType: " + this.getNodeType() + ",");
        }
        if (this.getNumberOfNodes() != null) {
            sb.append("NumberOfNodes: " + this.getNumberOfNodes() + ",");
        }
        if (this.getClusterSecurityGroups() != null) {
            sb.append("ClusterSecurityGroups: " + this.getClusterSecurityGroups() + ",");
        }
        if (this.getVpcSecurityGroupIds() != null) {
            sb.append("VpcSecurityGroupIds: " + this.getVpcSecurityGroupIds() + ",");
        }
        if (this.getMasterUserPassword() != null) {
            sb.append("MasterUserPassword: " + this.getMasterUserPassword() + ",");
        }
        if (this.getClusterParameterGroupName() != null) {
            sb.append("ClusterParameterGroupName: " + this.getClusterParameterGroupName() + ",");
        }
        if (this.getAutomatedSnapshotRetentionPeriod() != null) {
            sb.append("AutomatedSnapshotRetentionPeriod: " + this.getAutomatedSnapshotRetentionPeriod() + ",");
        }
        if (this.getPreferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: " + this.getPreferredMaintenanceWindow() + ",");
        }
        if (this.getClusterVersion() != null) {
            sb.append("ClusterVersion: " + this.getClusterVersion() + ",");
        }
        if (this.getAllowVersionUpgrade() != null) {
            sb.append("AllowVersionUpgrade: " + this.getAllowVersionUpgrade() + ",");
        }
        if (this.getHsmClientCertificateIdentifier() != null) {
            sb.append("HsmClientCertificateIdentifier: " + this.getHsmClientCertificateIdentifier() + ",");
        }
        if (this.getHsmConfigurationIdentifier() != null) {
            sb.append("HsmConfigurationIdentifier: " + this.getHsmConfigurationIdentifier() + ",");
        }
        if (this.getNewClusterIdentifier() != null) {
            sb.append("NewClusterIdentifier: " + this.getNewClusterIdentifier() + ",");
        }
        if (this.getPubliclyAccessible() != null) {
            sb.append("PubliclyAccessible: " + this.getPubliclyAccessible() + ",");
        }
        if (this.getElasticIp() != null) {
            sb.append("ElasticIp: " + this.getElasticIp() + ",");
        }
        if (this.getEnhancedVpcRouting() != null) {
            sb.append("EnhancedVpcRouting: " + this.getEnhancedVpcRouting());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyClusterRequest)) {
            return false;
        }
        ModifyClusterRequest other = (ModifyClusterRequest)obj;
        if (other.getClusterIdentifier() == null ^ this.getClusterIdentifier() == null) {
            return false;
        }
        if (other.getClusterIdentifier() != null && !other.getClusterIdentifier().equals(this.getClusterIdentifier())) {
            return false;
        }
        if (other.getClusterType() == null ^ this.getClusterType() == null) {
            return false;
        }
        if (other.getClusterType() != null && !other.getClusterType().equals(this.getClusterType())) {
            return false;
        }
        if (other.getNodeType() == null ^ this.getNodeType() == null) {
            return false;
        }
        if (other.getNodeType() != null && !other.getNodeType().equals(this.getNodeType())) {
            return false;
        }
        if (other.getNumberOfNodes() == null ^ this.getNumberOfNodes() == null) {
            return false;
        }
        if (other.getNumberOfNodes() != null && !other.getNumberOfNodes().equals(this.getNumberOfNodes())) {
            return false;
        }
        if (other.getClusterSecurityGroups() == null ^ this.getClusterSecurityGroups() == null) {
            return false;
        }
        if (other.getClusterSecurityGroups() != null && !other.getClusterSecurityGroups().equals(this.getClusterSecurityGroups())) {
            return false;
        }
        if (other.getVpcSecurityGroupIds() == null ^ this.getVpcSecurityGroupIds() == null) {
            return false;
        }
        if (other.getVpcSecurityGroupIds() != null && !other.getVpcSecurityGroupIds().equals(this.getVpcSecurityGroupIds())) {
            return false;
        }
        if (other.getMasterUserPassword() == null ^ this.getMasterUserPassword() == null) {
            return false;
        }
        if (other.getMasterUserPassword() != null && !other.getMasterUserPassword().equals(this.getMasterUserPassword())) {
            return false;
        }
        if (other.getClusterParameterGroupName() == null ^ this.getClusterParameterGroupName() == null) {
            return false;
        }
        if (other.getClusterParameterGroupName() != null && !other.getClusterParameterGroupName().equals(this.getClusterParameterGroupName())) {
            return false;
        }
        if (other.getAutomatedSnapshotRetentionPeriod() == null ^ this.getAutomatedSnapshotRetentionPeriod() == null) {
            return false;
        }
        if (other.getAutomatedSnapshotRetentionPeriod() != null && !other.getAutomatedSnapshotRetentionPeriod().equals(this.getAutomatedSnapshotRetentionPeriod())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getClusterVersion() == null ^ this.getClusterVersion() == null) {
            return false;
        }
        if (other.getClusterVersion() != null && !other.getClusterVersion().equals(this.getClusterVersion())) {
            return false;
        }
        if (other.getAllowVersionUpgrade() == null ^ this.getAllowVersionUpgrade() == null) {
            return false;
        }
        if (other.getAllowVersionUpgrade() != null && !other.getAllowVersionUpgrade().equals(this.getAllowVersionUpgrade())) {
            return false;
        }
        if (other.getHsmClientCertificateIdentifier() == null ^ this.getHsmClientCertificateIdentifier() == null) {
            return false;
        }
        if (other.getHsmClientCertificateIdentifier() != null && !other.getHsmClientCertificateIdentifier().equals(this.getHsmClientCertificateIdentifier())) {
            return false;
        }
        if (other.getHsmConfigurationIdentifier() == null ^ this.getHsmConfigurationIdentifier() == null) {
            return false;
        }
        if (other.getHsmConfigurationIdentifier() != null && !other.getHsmConfigurationIdentifier().equals(this.getHsmConfigurationIdentifier())) {
            return false;
        }
        if (other.getNewClusterIdentifier() == null ^ this.getNewClusterIdentifier() == null) {
            return false;
        }
        if (other.getNewClusterIdentifier() != null && !other.getNewClusterIdentifier().equals(this.getNewClusterIdentifier())) {
            return false;
        }
        if (other.getPubliclyAccessible() == null ^ this.getPubliclyAccessible() == null) {
            return false;
        }
        if (other.getPubliclyAccessible() != null && !other.getPubliclyAccessible().equals(this.getPubliclyAccessible())) {
            return false;
        }
        if (other.getElasticIp() == null ^ this.getElasticIp() == null) {
            return false;
        }
        if (other.getElasticIp() != null && !other.getElasticIp().equals(this.getElasticIp())) {
            return false;
        }
        if (other.getEnhancedVpcRouting() == null ^ this.getEnhancedVpcRouting() == null) {
            return false;
        }
        return other.getEnhancedVpcRouting() == null || other.getEnhancedVpcRouting().equals(this.getEnhancedVpcRouting());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterIdentifier() == null ? 0 : this.getClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getClusterType() == null ? 0 : this.getClusterType().hashCode());
        hashCode = 31 * hashCode + (this.getNodeType() == null ? 0 : this.getNodeType().hashCode());
        hashCode = 31 * hashCode + (this.getNumberOfNodes() == null ? 0 : this.getNumberOfNodes().hashCode());
        hashCode = 31 * hashCode + (this.getClusterSecurityGroups() == null ? 0 : this.getClusterSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getVpcSecurityGroupIds() == null ? 0 : this.getVpcSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getMasterUserPassword() == null ? 0 : this.getMasterUserPassword().hashCode());
        hashCode = 31 * hashCode + (this.getClusterParameterGroupName() == null ? 0 : this.getClusterParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getAutomatedSnapshotRetentionPeriod() == null ? 0 : this.getAutomatedSnapshotRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getClusterVersion() == null ? 0 : this.getClusterVersion().hashCode());
        hashCode = 31 * hashCode + (this.getAllowVersionUpgrade() == null ? 0 : this.getAllowVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.getHsmClientCertificateIdentifier() == null ? 0 : this.getHsmClientCertificateIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getHsmConfigurationIdentifier() == null ? 0 : this.getHsmConfigurationIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getNewClusterIdentifier() == null ? 0 : this.getNewClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getPubliclyAccessible() == null ? 0 : this.getPubliclyAccessible().hashCode());
        hashCode = 31 * hashCode + (this.getElasticIp() == null ? 0 : this.getElasticIp().hashCode());
        hashCode = 31 * hashCode + (this.getEnhancedVpcRouting() == null ? 0 : this.getEnhancedVpcRouting().hashCode());
        return hashCode;
    }

    public ModifyClusterRequest clone() {
        return (ModifyClusterRequest)super.clone();
    }
}

