/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.redshift.model.EnableLoggingRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class EnableLoggingRequestMarshaller
implements Marshaller<Request<EnableLoggingRequest>, EnableLoggingRequest> {
    public Request<EnableLoggingRequest> marshall(EnableLoggingRequest enableLoggingRequest) {
        if (enableLoggingRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)enableLoggingRequest, "AmazonRedshift");
        request.addParameter("Action", "EnableLogging");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (enableLoggingRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)enableLoggingRequest.getClusterIdentifier()));
        }
        if (enableLoggingRequest.getBucketName() != null) {
            request.addParameter("BucketName", StringUtils.fromString((String)enableLoggingRequest.getBucketName()));
        }
        if (enableLoggingRequest.getS3KeyPrefix() != null) {
            request.addParameter("S3KeyPrefix", StringUtils.fromString((String)enableLoggingRequest.getS3KeyPrefix()));
        }
        return request;
    }
}

