/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeClusterParameterGroupsRequestMarshaller
implements Marshaller<Request<DescribeClusterParameterGroupsRequest>, DescribeClusterParameterGroupsRequest> {
    public Request<DescribeClusterParameterGroupsRequest> marshall(DescribeClusterParameterGroupsRequest describeClusterParameterGroupsRequest) {
        if (describeClusterParameterGroupsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeClusterParameterGroupsRequest, "AmazonRedshift");
        request.addParameter("Action", "DescribeClusterParameterGroups");
        request.addParameter("Version", "2012-12-01");
        if (describeClusterParameterGroupsRequest.getParameterGroupName() != null) {
            request.addParameter("ParameterGroupName", StringUtils.fromString((String)describeClusterParameterGroupsRequest.getParameterGroupName()));
        }
        if (describeClusterParameterGroupsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeClusterParameterGroupsRequest.getMaxRecords()));
        }
        if (describeClusterParameterGroupsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeClusterParameterGroupsRequest.getMarker()));
        }
        List<String> tagKeysList = describeClusterParameterGroupsRequest.getTagKeys();
        int tagKeysListIndex = 1;
        for (String tagKeysListValue : tagKeysList) {
            if (tagKeysListValue != null) {
                request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringUtils.fromString((String)tagKeysListValue));
            }
            ++tagKeysListIndex;
        }
        List<String> tagValuesList = describeClusterParameterGroupsRequest.getTagValues();
        int tagValuesListIndex = 1;
        for (String tagValuesListValue : tagValuesList) {
            if (tagValuesListValue != null) {
                request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringUtils.fromString((String)tagValuesListValue));
            }
            ++tagValuesListIndex;
        }
        return request;
    }
}

