/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.redshift.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateHsmConfigurationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String hsmConfigurationIdentifier;
    private String description;
    private String hsmIpAddress;
    private String hsmPartitionName;
    private String hsmPartitionPassword;
    private String hsmServerPublicCertificate;
    private ListWithAutoConstructFlag<Tag> tags;

    public String getHsmConfigurationIdentifier() {
        return this.hsmConfigurationIdentifier;
    }

    public void setHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
        this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
    }

    public CreateHsmConfigurationRequest withHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
        this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateHsmConfigurationRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getHsmIpAddress() {
        return this.hsmIpAddress;
    }

    public void setHsmIpAddress(String hsmIpAddress) {
        this.hsmIpAddress = hsmIpAddress;
    }

    public CreateHsmConfigurationRequest withHsmIpAddress(String hsmIpAddress) {
        this.hsmIpAddress = hsmIpAddress;
        return this;
    }

    public String getHsmPartitionName() {
        return this.hsmPartitionName;
    }

    public void setHsmPartitionName(String hsmPartitionName) {
        this.hsmPartitionName = hsmPartitionName;
    }

    public CreateHsmConfigurationRequest withHsmPartitionName(String hsmPartitionName) {
        this.hsmPartitionName = hsmPartitionName;
        return this;
    }

    public String getHsmPartitionPassword() {
        return this.hsmPartitionPassword;
    }

    public void setHsmPartitionPassword(String hsmPartitionPassword) {
        this.hsmPartitionPassword = hsmPartitionPassword;
    }

    public CreateHsmConfigurationRequest withHsmPartitionPassword(String hsmPartitionPassword) {
        this.hsmPartitionPassword = hsmPartitionPassword;
        return this;
    }

    public String getHsmServerPublicCertificate() {
        return this.hsmServerPublicCertificate;
    }

    public void setHsmServerPublicCertificate(String hsmServerPublicCertificate) {
        this.hsmServerPublicCertificate = hsmServerPublicCertificate;
    }

    public CreateHsmConfigurationRequest withHsmServerPublicCertificate(String hsmServerPublicCertificate) {
        this.hsmServerPublicCertificate = hsmServerPublicCertificate;
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public CreateHsmConfigurationRequest withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public CreateHsmConfigurationRequest withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHsmConfigurationIdentifier() != null) {
            sb.append("HsmConfigurationIdentifier: " + this.getHsmConfigurationIdentifier() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getHsmIpAddress() != null) {
            sb.append("HsmIpAddress: " + this.getHsmIpAddress() + ",");
        }
        if (this.getHsmPartitionName() != null) {
            sb.append("HsmPartitionName: " + this.getHsmPartitionName() + ",");
        }
        if (this.getHsmPartitionPassword() != null) {
            sb.append("HsmPartitionPassword: " + this.getHsmPartitionPassword() + ",");
        }
        if (this.getHsmServerPublicCertificate() != null) {
            sb.append("HsmServerPublicCertificate: " + this.getHsmServerPublicCertificate() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHsmConfigurationIdentifier() == null ? 0 : this.getHsmConfigurationIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getHsmIpAddress() == null ? 0 : this.getHsmIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getHsmPartitionName() == null ? 0 : this.getHsmPartitionName().hashCode());
        hashCode = 31 * hashCode + (this.getHsmPartitionPassword() == null ? 0 : this.getHsmPartitionPassword().hashCode());
        hashCode = 31 * hashCode + (this.getHsmServerPublicCertificate() == null ? 0 : this.getHsmServerPublicCertificate().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHsmConfigurationRequest)) {
            return false;
        }
        CreateHsmConfigurationRequest other = (CreateHsmConfigurationRequest)obj;
        if (other.getHsmConfigurationIdentifier() == null ^ this.getHsmConfigurationIdentifier() == null) {
            return false;
        }
        if (other.getHsmConfigurationIdentifier() != null && !other.getHsmConfigurationIdentifier().equals(this.getHsmConfigurationIdentifier())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getHsmIpAddress() == null ^ this.getHsmIpAddress() == null) {
            return false;
        }
        if (other.getHsmIpAddress() != null && !other.getHsmIpAddress().equals(this.getHsmIpAddress())) {
            return false;
        }
        if (other.getHsmPartitionName() == null ^ this.getHsmPartitionName() == null) {
            return false;
        }
        if (other.getHsmPartitionName() != null && !other.getHsmPartitionName().equals(this.getHsmPartitionName())) {
            return false;
        }
        if (other.getHsmPartitionPassword() == null ^ this.getHsmPartitionPassword() == null) {
            return false;
        }
        if (other.getHsmPartitionPassword() != null && !other.getHsmPartitionPassword().equals(this.getHsmPartitionPassword())) {
            return false;
        }
        if (other.getHsmServerPublicCertificate() == null ^ this.getHsmServerPublicCertificate() == null) {
            return false;
        }
        if (other.getHsmServerPublicCertificate() != null && !other.getHsmServerPublicCertificate().equals(this.getHsmServerPublicCertificate())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public CreateHsmConfigurationRequest clone() {
        return (CreateHsmConfigurationRequest)super.clone();
    }
}

