/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.redshift.model.Cluster;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeClustersResult
implements Serializable,
Cloneable {
    private String marker;
    private ListWithAutoConstructFlag<Cluster> clusters;

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public DescribeClustersResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public List<Cluster> getClusters() {
        if (this.clusters == null) {
            this.clusters = new ListWithAutoConstructFlag();
            this.clusters.setAutoConstruct(true);
        }
        return this.clusters;
    }

    public void setClusters(Collection<Cluster> clusters) {
        if (clusters == null) {
            this.clusters = null;
            return;
        }
        ListWithAutoConstructFlag clustersCopy = new ListWithAutoConstructFlag(clusters.size());
        clustersCopy.addAll(clusters);
        this.clusters = clustersCopy;
    }

    public DescribeClustersResult withClusters(Cluster ... clusters) {
        if (this.getClusters() == null) {
            this.setClusters(new ArrayList<Cluster>(clusters.length));
        }
        for (Cluster value : clusters) {
            this.getClusters().add(value);
        }
        return this;
    }

    public DescribeClustersResult withClusters(Collection<Cluster> clusters) {
        if (clusters == null) {
            this.clusters = null;
        } else {
            ListWithAutoConstructFlag clustersCopy = new ListWithAutoConstructFlag(clusters.size());
            clustersCopy.addAll(clusters);
            this.clusters = clustersCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker() + ",");
        }
        if (this.getClusters() != null) {
            sb.append("Clusters: " + this.getClusters());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getClusters() == null ? 0 : this.getClusters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClustersResult)) {
            return false;
        }
        DescribeClustersResult other = (DescribeClustersResult)obj;
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getClusters() == null ^ this.getClusters() == null) {
            return false;
        }
        return other.getClusters() == null || other.getClusters().equals(this.getClusters());
    }

    public DescribeClustersResult clone() {
        try {
            return (DescribeClustersResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

