/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.services.redshift.model.EventSubscription;
import com.amazonaws.services.redshift.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class EventSubscriptionStaxUnmarshaller
implements Unmarshaller<EventSubscription, StaxUnmarshallerContext> {
    private static EventSubscriptionStaxUnmarshaller instance;

    public EventSubscription unmarshall(StaxUnmarshallerContext context) throws Exception {
        EventSubscription eventSubscription = new EventSubscription();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return eventSubscription;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CustomerAwsId", targetDepth)) {
                    eventSubscription.setCustomerAwsId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CustSubscriptionId", targetDepth)) {
                    eventSubscription.setCustSubscriptionId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SnsTopicArn", targetDepth)) {
                    eventSubscription.setSnsTopicArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    eventSubscription.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SubscriptionCreationTime", targetDepth)) {
                    eventSubscription.setSubscriptionCreationTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SourceType", targetDepth)) {
                    eventSubscription.setSourceType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SourceIdsList/SourceId", targetDepth)) {
                    eventSubscription.getSourceIdsList().add(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EventCategoriesList/EventCategory", targetDepth)) {
                    eventSubscription.getEventCategoriesList().add(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Severity", targetDepth)) {
                    eventSubscription.setSeverity(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Enabled", targetDepth)) {
                    eventSubscription.setEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Tags/Tag", targetDepth)) continue;
                eventSubscription.getTags().add(TagStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return eventSubscription;
    }

    public static EventSubscriptionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EventSubscriptionStaxUnmarshaller();
        }
        return instance;
    }
}

