/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.recyclebin;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.recyclebin.AmazonRecycleBinAsync;
import com.amazonaws.services.recyclebin.AmazonRecycleBinAsyncClientBuilder;
import com.amazonaws.services.recyclebin.AmazonRecycleBinClient;
import com.amazonaws.services.recyclebin.model.CreateRuleRequest;
import com.amazonaws.services.recyclebin.model.CreateRuleResult;
import com.amazonaws.services.recyclebin.model.DeleteRuleRequest;
import com.amazonaws.services.recyclebin.model.DeleteRuleResult;
import com.amazonaws.services.recyclebin.model.GetRuleRequest;
import com.amazonaws.services.recyclebin.model.GetRuleResult;
import com.amazonaws.services.recyclebin.model.ListRulesRequest;
import com.amazonaws.services.recyclebin.model.ListRulesResult;
import com.amazonaws.services.recyclebin.model.ListTagsForResourceRequest;
import com.amazonaws.services.recyclebin.model.ListTagsForResourceResult;
import com.amazonaws.services.recyclebin.model.TagResourceRequest;
import com.amazonaws.services.recyclebin.model.TagResourceResult;
import com.amazonaws.services.recyclebin.model.UntagResourceRequest;
import com.amazonaws.services.recyclebin.model.UntagResourceResult;
import com.amazonaws.services.recyclebin.model.UpdateRuleRequest;
import com.amazonaws.services.recyclebin.model.UpdateRuleResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonRecycleBinAsyncClient
extends AmazonRecycleBinClient
implements AmazonRecycleBinAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonRecycleBinAsyncClientBuilder asyncBuilder() {
        return AmazonRecycleBinAsyncClientBuilder.standard();
    }

    AmazonRecycleBinAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonRecycleBinAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateRuleResult> createRuleAsync(CreateRuleRequest request) {
        return this.createRuleAsync(request, null);
    }

    @Override
    public Future<CreateRuleResult> createRuleAsync(CreateRuleRequest request, final AsyncHandler<CreateRuleRequest, CreateRuleResult> asyncHandler) {
        final CreateRuleRequest finalRequest = (CreateRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateRuleResult>(){

            @Override
            public CreateRuleResult call() throws Exception {
                CreateRuleResult result = null;
                try {
                    result = AmazonRecycleBinAsyncClient.this.executeCreateRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRuleResult> deleteRuleAsync(DeleteRuleRequest request) {
        return this.deleteRuleAsync(request, null);
    }

    @Override
    public Future<DeleteRuleResult> deleteRuleAsync(DeleteRuleRequest request, final AsyncHandler<DeleteRuleRequest, DeleteRuleResult> asyncHandler) {
        final DeleteRuleRequest finalRequest = (DeleteRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteRuleResult>(){

            @Override
            public DeleteRuleResult call() throws Exception {
                DeleteRuleResult result = null;
                try {
                    result = AmazonRecycleBinAsyncClient.this.executeDeleteRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRuleResult> getRuleAsync(GetRuleRequest request) {
        return this.getRuleAsync(request, null);
    }

    @Override
    public Future<GetRuleResult> getRuleAsync(GetRuleRequest request, final AsyncHandler<GetRuleRequest, GetRuleResult> asyncHandler) {
        final GetRuleRequest finalRequest = (GetRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRuleResult>(){

            @Override
            public GetRuleResult call() throws Exception {
                GetRuleResult result = null;
                try {
                    result = AmazonRecycleBinAsyncClient.this.executeGetRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRulesResult> listRulesAsync(ListRulesRequest request) {
        return this.listRulesAsync(request, null);
    }

    @Override
    public Future<ListRulesResult> listRulesAsync(ListRulesRequest request, final AsyncHandler<ListRulesRequest, ListRulesResult> asyncHandler) {
        final ListRulesRequest finalRequest = (ListRulesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRulesResult>(){

            @Override
            public ListRulesResult call() throws Exception {
                ListRulesResult result = null;
                try {
                    result = AmazonRecycleBinAsyncClient.this.executeListRules(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonRecycleBinAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonRecycleBinAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonRecycleBinAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateRuleResult> updateRuleAsync(UpdateRuleRequest request) {
        return this.updateRuleAsync(request, null);
    }

    @Override
    public Future<UpdateRuleResult> updateRuleAsync(UpdateRuleRequest request, final AsyncHandler<UpdateRuleRequest, UpdateRuleResult> asyncHandler) {
        final UpdateRuleRequest finalRequest = (UpdateRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateRuleResult>(){

            @Override
            public UpdateRuleResult call() throws Exception {
                UpdateRuleResult result = null;
                try {
                    result = AmazonRecycleBinAsyncClient.this.executeUpdateRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

