/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.rds.model.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import com.amazonaws.services.rds.model.*;
import com.amazonaws.transform.Unmarshaller;

import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DBCluster StAX Unmarshaller
 */

@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DBClusterStaxUnmarshaller implements Unmarshaller<DBCluster, StaxUnmarshallerContext> {

    public DBCluster unmarshall(StaxUnmarshallerContext context) throws Exception {
        DBCluster dBCluster = new DBCluster();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 3;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument())
                return dBCluster;

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("AllocatedStorage", targetDepth)) {
                    dBCluster.setAllocatedStorage(IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("AvailabilityZones", targetDepth)) {
                    dBCluster.withAvailabilityZones(new ArrayList<String>());
                    continue;
                }

                if (context.testExpression("AvailabilityZones/AvailabilityZone", targetDepth)) {
                    dBCluster.withAvailabilityZones(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("BackupRetentionPeriod", targetDepth)) {
                    dBCluster.setBackupRetentionPeriod(IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("CharacterSetName", targetDepth)) {
                    dBCluster.setCharacterSetName(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DatabaseName", targetDepth)) {
                    dBCluster.setDatabaseName(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DBClusterIdentifier", targetDepth)) {
                    dBCluster.setDBClusterIdentifier(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DBClusterParameterGroup", targetDepth)) {
                    dBCluster.setDBClusterParameterGroup(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DBSubnetGroup", targetDepth)) {
                    dBCluster.setDBSubnetGroup(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Status", targetDepth)) {
                    dBCluster.setStatus(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("AutomaticRestartTime", targetDepth)) {
                    dBCluster.setAutomaticRestartTime(DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                    continue;
                }

                if (context.testExpression("PercentProgress", targetDepth)) {
                    dBCluster.setPercentProgress(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("EarliestRestorableTime", targetDepth)) {
                    dBCluster.setEarliestRestorableTime(DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                    continue;
                }

                if (context.testExpression("Endpoint", targetDepth)) {
                    dBCluster.setEndpoint(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ReaderEndpoint", targetDepth)) {
                    dBCluster.setReaderEndpoint(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("CustomEndpoints", targetDepth)) {
                    dBCluster.withCustomEndpoints(new ArrayList<String>());
                    continue;
                }

                if (context.testExpression("CustomEndpoints/member", targetDepth)) {
                    dBCluster.withCustomEndpoints(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MultiAZ", targetDepth)) {
                    dBCluster.setMultiAZ(BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Engine", targetDepth)) {
                    dBCluster.setEngine(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("EngineVersion", targetDepth)) {
                    dBCluster.setEngineVersion(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("LatestRestorableTime", targetDepth)) {
                    dBCluster.setLatestRestorableTime(DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                    continue;
                }

                if (context.testExpression("Port", targetDepth)) {
                    dBCluster.setPort(IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MasterUsername", targetDepth)) {
                    dBCluster.setMasterUsername(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DBClusterOptionGroupMemberships", targetDepth)) {
                    dBCluster.withDBClusterOptionGroupMemberships(new ArrayList<DBClusterOptionGroupStatus>());
                    continue;
                }

                if (context.testExpression("DBClusterOptionGroupMemberships/DBClusterOptionGroup", targetDepth)) {
                    dBCluster.withDBClusterOptionGroupMemberships(DBClusterOptionGroupStatusStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("PreferredBackupWindow", targetDepth)) {
                    dBCluster.setPreferredBackupWindow(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("PreferredMaintenanceWindow", targetDepth)) {
                    dBCluster.setPreferredMaintenanceWindow(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ReplicationSourceIdentifier", targetDepth)) {
                    dBCluster.setReplicationSourceIdentifier(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ReadReplicaIdentifiers", targetDepth)) {
                    dBCluster.withReadReplicaIdentifiers(new ArrayList<String>());
                    continue;
                }

                if (context.testExpression("ReadReplicaIdentifiers/ReadReplicaIdentifier", targetDepth)) {
                    dBCluster.withReadReplicaIdentifiers(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("StatusInfos", targetDepth)) {
                    dBCluster.withStatusInfos(new ArrayList<DBClusterStatusInfo>());
                    continue;
                }

                if (context.testExpression("StatusInfos/DBClusterStatusInfo", targetDepth)) {
                    dBCluster.withStatusInfos(DBClusterStatusInfoStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DBClusterMembers", targetDepth)) {
                    dBCluster.withDBClusterMembers(new ArrayList<DBClusterMember>());
                    continue;
                }

                if (context.testExpression("DBClusterMembers/DBClusterMember", targetDepth)) {
                    dBCluster.withDBClusterMembers(DBClusterMemberStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("VpcSecurityGroups", targetDepth)) {
                    dBCluster.withVpcSecurityGroups(new ArrayList<VpcSecurityGroupMembership>());
                    continue;
                }

                if (context.testExpression("VpcSecurityGroups/VpcSecurityGroupMembership", targetDepth)) {
                    dBCluster.withVpcSecurityGroups(VpcSecurityGroupMembershipStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("HostedZoneId", targetDepth)) {
                    dBCluster.setHostedZoneId(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("StorageEncrypted", targetDepth)) {
                    dBCluster.setStorageEncrypted(BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("KmsKeyId", targetDepth)) {
                    dBCluster.setKmsKeyId(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DbClusterResourceId", targetDepth)) {
                    dBCluster.setDbClusterResourceId(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DBClusterArn", targetDepth)) {
                    dBCluster.setDBClusterArn(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("AssociatedRoles", targetDepth)) {
                    dBCluster.withAssociatedRoles(new ArrayList<DBClusterRole>());
                    continue;
                }

                if (context.testExpression("AssociatedRoles/DBClusterRole", targetDepth)) {
                    dBCluster.withAssociatedRoles(DBClusterRoleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("IAMDatabaseAuthenticationEnabled", targetDepth)) {
                    dBCluster.setIAMDatabaseAuthenticationEnabled(BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("CloneGroupId", targetDepth)) {
                    dBCluster.setCloneGroupId(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ClusterCreateTime", targetDepth)) {
                    dBCluster.setClusterCreateTime(DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                    continue;
                }

                if (context.testExpression("EarliestBacktrackTime", targetDepth)) {
                    dBCluster.setEarliestBacktrackTime(DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                    continue;
                }

                if (context.testExpression("BacktrackWindow", targetDepth)) {
                    dBCluster.setBacktrackWindow(LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("BacktrackConsumedChangeRecords", targetDepth)) {
                    dBCluster.setBacktrackConsumedChangeRecords(LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("EnabledCloudwatchLogsExports", targetDepth)) {
                    dBCluster.withEnabledCloudwatchLogsExports(new ArrayList<String>());
                    continue;
                }

                if (context.testExpression("EnabledCloudwatchLogsExports/member", targetDepth)) {
                    dBCluster.withEnabledCloudwatchLogsExports(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Capacity", targetDepth)) {
                    dBCluster.setCapacity(IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("EngineMode", targetDepth)) {
                    dBCluster.setEngineMode(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ScalingConfigurationInfo", targetDepth)) {
                    dBCluster.setScalingConfigurationInfo(ScalingConfigurationInfoStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("RdsCustomClusterConfiguration", targetDepth)) {
                    dBCluster.setRdsCustomClusterConfiguration(RdsCustomClusterConfigurationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DeletionProtection", targetDepth)) {
                    dBCluster.setDeletionProtection(BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("HttpEndpointEnabled", targetDepth)) {
                    dBCluster.setHttpEndpointEnabled(BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ActivityStreamMode", targetDepth)) {
                    dBCluster.setActivityStreamMode(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ActivityStreamStatus", targetDepth)) {
                    dBCluster.setActivityStreamStatus(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ActivityStreamKmsKeyId", targetDepth)) {
                    dBCluster.setActivityStreamKmsKeyId(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ActivityStreamKinesisStreamName", targetDepth)) {
                    dBCluster.setActivityStreamKinesisStreamName(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("CopyTagsToSnapshot", targetDepth)) {
                    dBCluster.setCopyTagsToSnapshot(BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("CrossAccountClone", targetDepth)) {
                    dBCluster.setCrossAccountClone(BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DomainMemberships", targetDepth)) {
                    dBCluster.withDomainMemberships(new ArrayList<DomainMembership>());
                    continue;
                }

                if (context.testExpression("DomainMemberships/DomainMembership", targetDepth)) {
                    dBCluster.withDomainMemberships(DomainMembershipStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("TagList", targetDepth)) {
                    dBCluster.withTagList(new ArrayList<Tag>());
                    continue;
                }

                if (context.testExpression("TagList/Tag", targetDepth)) {
                    dBCluster.withTagList(TagStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("GlobalWriteForwardingStatus", targetDepth)) {
                    dBCluster.setGlobalWriteForwardingStatus(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("GlobalWriteForwardingRequested", targetDepth)) {
                    dBCluster.setGlobalWriteForwardingRequested(BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("PendingModifiedValues", targetDepth)) {
                    dBCluster.setPendingModifiedValues(ClusterPendingModifiedValuesStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DBClusterInstanceClass", targetDepth)) {
                    dBCluster.setDBClusterInstanceClass(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("StorageType", targetDepth)) {
                    dBCluster.setStorageType(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Iops", targetDepth)) {
                    dBCluster.setIops(IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("PubliclyAccessible", targetDepth)) {
                    dBCluster.setPubliclyAccessible(BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("AutoMinorVersionUpgrade", targetDepth)) {
                    dBCluster.setAutoMinorVersionUpgrade(BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MonitoringInterval", targetDepth)) {
                    dBCluster.setMonitoringInterval(IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MonitoringRoleArn", targetDepth)) {
                    dBCluster.setMonitoringRoleArn(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("PerformanceInsightsEnabled", targetDepth)) {
                    dBCluster.setPerformanceInsightsEnabled(BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("PerformanceInsightsKMSKeyId", targetDepth)) {
                    dBCluster.setPerformanceInsightsKMSKeyId(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("PerformanceInsightsRetentionPeriod", targetDepth)) {
                    dBCluster.setPerformanceInsightsRetentionPeriod(IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ServerlessV2ScalingConfiguration", targetDepth)) {
                    dBCluster.setServerlessV2ScalingConfiguration(ServerlessV2ScalingConfigurationInfoStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NetworkType", targetDepth)) {
                    dBCluster.setNetworkType(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DBSystemId", targetDepth)) {
                    dBCluster.setDBSystemId(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MasterUserSecret", targetDepth)) {
                    dBCluster.setMasterUserSecret(MasterUserSecretStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("IOOptimizedNextAllowedModificationTime", targetDepth)) {
                    dBCluster.setIOOptimizedNextAllowedModificationTime(DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                    continue;
                }

                if (context.testExpression("LocalWriteForwardingStatus", targetDepth)) {
                    dBCluster.setLocalWriteForwardingStatus(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("AwsBackupRecoveryPointArn", targetDepth)) {
                    dBCluster.setAwsBackupRecoveryPointArn(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("LimitlessDatabase", targetDepth)) {
                    dBCluster.setLimitlessDatabase(LimitlessDatabaseStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("StorageThroughput", targetDepth)) {
                    dBCluster.setStorageThroughput(IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("CertificateDetails", targetDepth)) {
                    dBCluster.setCertificateDetails(CertificateDetailsStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    return dBCluster;
                }
            }
        }
    }

    private static DBClusterStaxUnmarshaller instance;

    public static DBClusterStaxUnmarshaller getInstance() {
        if (instance == null)
            instance = new DBClusterStaxUnmarshaller();
        return instance;
    }
}
