/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.CreateDBClusterRequest;
import com.amazonaws.services.rds.model.ScalingConfiguration;
import com.amazonaws.services.rds.model.ServerlessV2ScalingConfiguration;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateDBClusterRequestMarshaller
implements Marshaller<Request<CreateDBClusterRequest>, CreateDBClusterRequest> {
    public Request<CreateDBClusterRequest> marshall(CreateDBClusterRequest createDBClusterRequest) {
        ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration;
        ScalingConfiguration scalingConfiguration;
        if (createDBClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDBClusterRequest, "AmazonRDS");
        request.addParameter("Action", "CreateDBCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (!createDBClusterRequest.getAvailabilityZones().isEmpty() || !((SdkInternalList)createDBClusterRequest.getAvailabilityZones()).isAutoConstruct()) {
            SdkInternalList availabilityZonesList = (SdkInternalList)createDBClusterRequest.getAvailabilityZones();
            int availabilityZonesListIndex = 1;
            for (String availabilityZonesListValue : availabilityZonesList) {
                if (availabilityZonesListValue != null) {
                    request.addParameter("AvailabilityZones.AvailabilityZone." + availabilityZonesListIndex, StringUtils.fromString((String)availabilityZonesListValue));
                }
                ++availabilityZonesListIndex;
            }
        }
        if (createDBClusterRequest.getBackupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringUtils.fromInteger((Integer)createDBClusterRequest.getBackupRetentionPeriod()));
        }
        if (createDBClusterRequest.getCharacterSetName() != null) {
            request.addParameter("CharacterSetName", StringUtils.fromString((String)createDBClusterRequest.getCharacterSetName()));
        }
        if (createDBClusterRequest.getDatabaseName() != null) {
            request.addParameter("DatabaseName", StringUtils.fromString((String)createDBClusterRequest.getDatabaseName()));
        }
        if (createDBClusterRequest.getDBClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)createDBClusterRequest.getDBClusterIdentifier()));
        }
        if (createDBClusterRequest.getDBClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringUtils.fromString((String)createDBClusterRequest.getDBClusterParameterGroupName()));
        }
        if (!createDBClusterRequest.getVpcSecurityGroupIds().isEmpty() || !((SdkInternalList)createDBClusterRequest.getVpcSecurityGroupIds()).isAutoConstruct()) {
            SdkInternalList vpcSecurityGroupIdsList = (SdkInternalList)createDBClusterRequest.getVpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (createDBClusterRequest.getDBSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString((String)createDBClusterRequest.getDBSubnetGroupName()));
        }
        if (createDBClusterRequest.getEngine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)createDBClusterRequest.getEngine()));
        }
        if (createDBClusterRequest.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)createDBClusterRequest.getEngineVersion()));
        }
        if (createDBClusterRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)createDBClusterRequest.getPort()));
        }
        if (createDBClusterRequest.getMasterUsername() != null) {
            request.addParameter("MasterUsername", StringUtils.fromString((String)createDBClusterRequest.getMasterUsername()));
        }
        if (createDBClusterRequest.getMasterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringUtils.fromString((String)createDBClusterRequest.getMasterUserPassword()));
        }
        if (createDBClusterRequest.getOptionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)createDBClusterRequest.getOptionGroupName()));
        }
        if (createDBClusterRequest.getPreferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringUtils.fromString((String)createDBClusterRequest.getPreferredBackupWindow()));
        }
        if (createDBClusterRequest.getPreferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)createDBClusterRequest.getPreferredMaintenanceWindow()));
        }
        if (createDBClusterRequest.getReplicationSourceIdentifier() != null) {
            request.addParameter("ReplicationSourceIdentifier", StringUtils.fromString((String)createDBClusterRequest.getReplicationSourceIdentifier()));
        }
        if (!createDBClusterRequest.getTags().isEmpty() || !((SdkInternalList)createDBClusterRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createDBClusterRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        if (createDBClusterRequest.getStorageEncrypted() != null) {
            request.addParameter("StorageEncrypted", StringUtils.fromBoolean((Boolean)createDBClusterRequest.getStorageEncrypted()));
        }
        if (createDBClusterRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)createDBClusterRequest.getKmsKeyId()));
        }
        if (createDBClusterRequest.getPreSignedUrl() != null) {
            request.addParameter("PreSignedUrl", StringUtils.fromString((String)createDBClusterRequest.getPreSignedUrl()));
        }
        if (createDBClusterRequest.getEnableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean((Boolean)createDBClusterRequest.getEnableIAMDatabaseAuthentication()));
        }
        if (createDBClusterRequest.getBacktrackWindow() != null) {
            request.addParameter("BacktrackWindow", StringUtils.fromLong((Long)createDBClusterRequest.getBacktrackWindow()));
        }
        if (!createDBClusterRequest.getEnableCloudwatchLogsExports().isEmpty() || !((SdkInternalList)createDBClusterRequest.getEnableCloudwatchLogsExports()).isAutoConstruct()) {
            SdkInternalList enableCloudwatchLogsExportsList = (SdkInternalList)createDBClusterRequest.getEnableCloudwatchLogsExports();
            int enableCloudwatchLogsExportsListIndex = 1;
            for (String enableCloudwatchLogsExportsListValue : enableCloudwatchLogsExportsList) {
                if (enableCloudwatchLogsExportsListValue != null) {
                    request.addParameter("EnableCloudwatchLogsExports.member." + enableCloudwatchLogsExportsListIndex, StringUtils.fromString((String)enableCloudwatchLogsExportsListValue));
                }
                ++enableCloudwatchLogsExportsListIndex;
            }
        }
        if (createDBClusterRequest.getEngineMode() != null) {
            request.addParameter("EngineMode", StringUtils.fromString((String)createDBClusterRequest.getEngineMode()));
        }
        if ((scalingConfiguration = createDBClusterRequest.getScalingConfiguration()) != null) {
            if (scalingConfiguration.getMinCapacity() != null) {
                request.addParameter("ScalingConfiguration.MinCapacity", StringUtils.fromInteger((Integer)scalingConfiguration.getMinCapacity()));
            }
            if (scalingConfiguration.getMaxCapacity() != null) {
                request.addParameter("ScalingConfiguration.MaxCapacity", StringUtils.fromInteger((Integer)scalingConfiguration.getMaxCapacity()));
            }
            if (scalingConfiguration.getAutoPause() != null) {
                request.addParameter("ScalingConfiguration.AutoPause", StringUtils.fromBoolean((Boolean)scalingConfiguration.getAutoPause()));
            }
            if (scalingConfiguration.getSecondsUntilAutoPause() != null) {
                request.addParameter("ScalingConfiguration.SecondsUntilAutoPause", StringUtils.fromInteger((Integer)scalingConfiguration.getSecondsUntilAutoPause()));
            }
            if (scalingConfiguration.getTimeoutAction() != null) {
                request.addParameter("ScalingConfiguration.TimeoutAction", StringUtils.fromString((String)scalingConfiguration.getTimeoutAction()));
            }
            if (scalingConfiguration.getSecondsBeforeTimeout() != null) {
                request.addParameter("ScalingConfiguration.SecondsBeforeTimeout", StringUtils.fromInteger((Integer)scalingConfiguration.getSecondsBeforeTimeout()));
            }
        }
        if (createDBClusterRequest.getDeletionProtection() != null) {
            request.addParameter("DeletionProtection", StringUtils.fromBoolean((Boolean)createDBClusterRequest.getDeletionProtection()));
        }
        if (createDBClusterRequest.getGlobalClusterIdentifier() != null) {
            request.addParameter("GlobalClusterIdentifier", StringUtils.fromString((String)createDBClusterRequest.getGlobalClusterIdentifier()));
        }
        if (createDBClusterRequest.getEnableHttpEndpoint() != null) {
            request.addParameter("EnableHttpEndpoint", StringUtils.fromBoolean((Boolean)createDBClusterRequest.getEnableHttpEndpoint()));
        }
        if (createDBClusterRequest.getCopyTagsToSnapshot() != null) {
            request.addParameter("CopyTagsToSnapshot", StringUtils.fromBoolean((Boolean)createDBClusterRequest.getCopyTagsToSnapshot()));
        }
        if (createDBClusterRequest.getDomain() != null) {
            request.addParameter("Domain", StringUtils.fromString((String)createDBClusterRequest.getDomain()));
        }
        if (createDBClusterRequest.getDomainIAMRoleName() != null) {
            request.addParameter("DomainIAMRoleName", StringUtils.fromString((String)createDBClusterRequest.getDomainIAMRoleName()));
        }
        if (createDBClusterRequest.getEnableGlobalWriteForwarding() != null) {
            request.addParameter("EnableGlobalWriteForwarding", StringUtils.fromBoolean((Boolean)createDBClusterRequest.getEnableGlobalWriteForwarding()));
        }
        if (createDBClusterRequest.getDBClusterInstanceClass() != null) {
            request.addParameter("DBClusterInstanceClass", StringUtils.fromString((String)createDBClusterRequest.getDBClusterInstanceClass()));
        }
        if (createDBClusterRequest.getAllocatedStorage() != null) {
            request.addParameter("AllocatedStorage", StringUtils.fromInteger((Integer)createDBClusterRequest.getAllocatedStorage()));
        }
        if (createDBClusterRequest.getStorageType() != null) {
            request.addParameter("StorageType", StringUtils.fromString((String)createDBClusterRequest.getStorageType()));
        }
        if (createDBClusterRequest.getIops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger((Integer)createDBClusterRequest.getIops()));
        }
        if (createDBClusterRequest.getPubliclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringUtils.fromBoolean((Boolean)createDBClusterRequest.getPubliclyAccessible()));
        }
        if (createDBClusterRequest.getAutoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean((Boolean)createDBClusterRequest.getAutoMinorVersionUpgrade()));
        }
        if (createDBClusterRequest.getMonitoringInterval() != null) {
            request.addParameter("MonitoringInterval", StringUtils.fromInteger((Integer)createDBClusterRequest.getMonitoringInterval()));
        }
        if (createDBClusterRequest.getMonitoringRoleArn() != null) {
            request.addParameter("MonitoringRoleArn", StringUtils.fromString((String)createDBClusterRequest.getMonitoringRoleArn()));
        }
        if (createDBClusterRequest.getEnablePerformanceInsights() != null) {
            request.addParameter("EnablePerformanceInsights", StringUtils.fromBoolean((Boolean)createDBClusterRequest.getEnablePerformanceInsights()));
        }
        if (createDBClusterRequest.getPerformanceInsightsKMSKeyId() != null) {
            request.addParameter("PerformanceInsightsKMSKeyId", StringUtils.fromString((String)createDBClusterRequest.getPerformanceInsightsKMSKeyId()));
        }
        if (createDBClusterRequest.getPerformanceInsightsRetentionPeriod() != null) {
            request.addParameter("PerformanceInsightsRetentionPeriod", StringUtils.fromInteger((Integer)createDBClusterRequest.getPerformanceInsightsRetentionPeriod()));
        }
        if ((serverlessV2ScalingConfiguration = createDBClusterRequest.getServerlessV2ScalingConfiguration()) != null) {
            if (serverlessV2ScalingConfiguration.getMinCapacity() != null) {
                request.addParameter("ServerlessV2ScalingConfiguration.MinCapacity", StringUtils.fromDouble((Double)serverlessV2ScalingConfiguration.getMinCapacity()));
            }
            if (serverlessV2ScalingConfiguration.getMaxCapacity() != null) {
                request.addParameter("ServerlessV2ScalingConfiguration.MaxCapacity", StringUtils.fromDouble((Double)serverlessV2ScalingConfiguration.getMaxCapacity()));
            }
        }
        if (createDBClusterRequest.getNetworkType() != null) {
            request.addParameter("NetworkType", StringUtils.fromString((String)createDBClusterRequest.getNetworkType()));
        }
        if (createDBClusterRequest.getSourceRegion() != null) {
            request.addParameter("SourceRegion", StringUtils.fromString((String)createDBClusterRequest.getSourceRegion()));
        }
        return request;
    }
}

