/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ram;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.ram.AWSRAMAsync;
import com.amazonaws.services.ram.AWSRAMAsyncClientBuilder;
import com.amazonaws.services.ram.AWSRAMClient;
import com.amazonaws.services.ram.model.AcceptResourceShareInvitationRequest;
import com.amazonaws.services.ram.model.AcceptResourceShareInvitationResult;
import com.amazonaws.services.ram.model.AssociateResourceSharePermissionRequest;
import com.amazonaws.services.ram.model.AssociateResourceSharePermissionResult;
import com.amazonaws.services.ram.model.AssociateResourceShareRequest;
import com.amazonaws.services.ram.model.AssociateResourceShareResult;
import com.amazonaws.services.ram.model.CreateResourceShareRequest;
import com.amazonaws.services.ram.model.CreateResourceShareResult;
import com.amazonaws.services.ram.model.DeleteResourceShareRequest;
import com.amazonaws.services.ram.model.DeleteResourceShareResult;
import com.amazonaws.services.ram.model.DisassociateResourceSharePermissionRequest;
import com.amazonaws.services.ram.model.DisassociateResourceSharePermissionResult;
import com.amazonaws.services.ram.model.DisassociateResourceShareRequest;
import com.amazonaws.services.ram.model.DisassociateResourceShareResult;
import com.amazonaws.services.ram.model.EnableSharingWithAwsOrganizationRequest;
import com.amazonaws.services.ram.model.EnableSharingWithAwsOrganizationResult;
import com.amazonaws.services.ram.model.GetPermissionRequest;
import com.amazonaws.services.ram.model.GetPermissionResult;
import com.amazonaws.services.ram.model.GetResourcePoliciesRequest;
import com.amazonaws.services.ram.model.GetResourcePoliciesResult;
import com.amazonaws.services.ram.model.GetResourceShareAssociationsRequest;
import com.amazonaws.services.ram.model.GetResourceShareAssociationsResult;
import com.amazonaws.services.ram.model.GetResourceShareInvitationsRequest;
import com.amazonaws.services.ram.model.GetResourceShareInvitationsResult;
import com.amazonaws.services.ram.model.GetResourceSharesRequest;
import com.amazonaws.services.ram.model.GetResourceSharesResult;
import com.amazonaws.services.ram.model.ListPendingInvitationResourcesRequest;
import com.amazonaws.services.ram.model.ListPendingInvitationResourcesResult;
import com.amazonaws.services.ram.model.ListPermissionsRequest;
import com.amazonaws.services.ram.model.ListPermissionsResult;
import com.amazonaws.services.ram.model.ListPrincipalsRequest;
import com.amazonaws.services.ram.model.ListPrincipalsResult;
import com.amazonaws.services.ram.model.ListResourceSharePermissionsRequest;
import com.amazonaws.services.ram.model.ListResourceSharePermissionsResult;
import com.amazonaws.services.ram.model.ListResourcesRequest;
import com.amazonaws.services.ram.model.ListResourcesResult;
import com.amazonaws.services.ram.model.PromoteResourceShareCreatedFromPolicyRequest;
import com.amazonaws.services.ram.model.PromoteResourceShareCreatedFromPolicyResult;
import com.amazonaws.services.ram.model.RejectResourceShareInvitationRequest;
import com.amazonaws.services.ram.model.RejectResourceShareInvitationResult;
import com.amazonaws.services.ram.model.TagResourceRequest;
import com.amazonaws.services.ram.model.TagResourceResult;
import com.amazonaws.services.ram.model.UntagResourceRequest;
import com.amazonaws.services.ram.model.UntagResourceResult;
import com.amazonaws.services.ram.model.UpdateResourceShareRequest;
import com.amazonaws.services.ram.model.UpdateResourceShareResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSRAMAsyncClient
extends AWSRAMClient
implements AWSRAMAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSRAMAsyncClientBuilder asyncBuilder() {
        return AWSRAMAsyncClientBuilder.standard();
    }

    AWSRAMAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AcceptResourceShareInvitationResult> acceptResourceShareInvitationAsync(AcceptResourceShareInvitationRequest request) {
        return this.acceptResourceShareInvitationAsync(request, null);
    }

    @Override
    public Future<AcceptResourceShareInvitationResult> acceptResourceShareInvitationAsync(AcceptResourceShareInvitationRequest request, final AsyncHandler<AcceptResourceShareInvitationRequest, AcceptResourceShareInvitationResult> asyncHandler) {
        final AcceptResourceShareInvitationRequest finalRequest = (AcceptResourceShareInvitationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AcceptResourceShareInvitationResult>(){

            @Override
            public AcceptResourceShareInvitationResult call() throws Exception {
                AcceptResourceShareInvitationResult result = null;
                try {
                    result = AWSRAMAsyncClient.this.executeAcceptResourceShareInvitation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AssociateResourceShareResult> associateResourceShareAsync(AssociateResourceShareRequest request) {
        return this.associateResourceShareAsync(request, null);
    }

    @Override
    public Future<AssociateResourceShareResult> associateResourceShareAsync(AssociateResourceShareRequest request, final AsyncHandler<AssociateResourceShareRequest, AssociateResourceShareResult> asyncHandler) {
        final AssociateResourceShareRequest finalRequest = (AssociateResourceShareRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateResourceShareResult>(){

            @Override
            public AssociateResourceShareResult call() throws Exception {
                AssociateResourceShareResult result = null;
                try {
                    result = AWSRAMAsyncClient.this.executeAssociateResourceShare(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AssociateResourceSharePermissionResult> associateResourceSharePermissionAsync(AssociateResourceSharePermissionRequest request) {
        return this.associateResourceSharePermissionAsync(request, null);
    }

    @Override
    public Future<AssociateResourceSharePermissionResult> associateResourceSharePermissionAsync(AssociateResourceSharePermissionRequest request, final AsyncHandler<AssociateResourceSharePermissionRequest, AssociateResourceSharePermissionResult> asyncHandler) {
        final AssociateResourceSharePermissionRequest finalRequest = (AssociateResourceSharePermissionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateResourceSharePermissionResult>(){

            @Override
            public AssociateResourceSharePermissionResult call() throws Exception {
                AssociateResourceSharePermissionResult result = null;
                try {
                    result = AWSRAMAsyncClient.this.executeAssociateResourceSharePermission(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateResourceShareResult> createResourceShareAsync(CreateResourceShareRequest request) {
        return this.createResourceShareAsync(request, null);
    }

    @Override
    public Future<CreateResourceShareResult> createResourceShareAsync(CreateResourceShareRequest request, final AsyncHandler<CreateResourceShareRequest, CreateResourceShareResult> asyncHandler) {
        final CreateResourceShareRequest finalRequest = (CreateResourceShareRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateResourceShareResult>(){

            @Override
            public CreateResourceShareResult call() throws Exception {
                CreateResourceShareResult result = null;
                try {
                    result = AWSRAMAsyncClient.this.executeCreateResourceShare(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteResourceShareResult> deleteResourceShareAsync(DeleteResourceShareRequest request) {
        return this.deleteResourceShareAsync(request, null);
    }

    @Override
    public Future<DeleteResourceShareResult> deleteResourceShareAsync(DeleteResourceShareRequest request, final AsyncHandler<DeleteResourceShareRequest, DeleteResourceShareResult> asyncHandler) {
        final DeleteResourceShareRequest finalRequest = (DeleteResourceShareRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteResourceShareResult>(){

            @Override
            public DeleteResourceShareResult call() throws Exception {
                DeleteResourceShareResult result = null;
                try {
                    result = AWSRAMAsyncClient.this.executeDeleteResourceShare(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateResourceShareResult> disassociateResourceShareAsync(DisassociateResourceShareRequest request) {
        return this.disassociateResourceShareAsync(request, null);
    }

    @Override
    public Future<DisassociateResourceShareResult> disassociateResourceShareAsync(DisassociateResourceShareRequest request, final AsyncHandler<DisassociateResourceShareRequest, DisassociateResourceShareResult> asyncHandler) {
        final DisassociateResourceShareRequest finalRequest = (DisassociateResourceShareRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateResourceShareResult>(){

            @Override
            public DisassociateResourceShareResult call() throws Exception {
                DisassociateResourceShareResult result = null;
                try {
                    result = AWSRAMAsyncClient.this.executeDisassociateResourceShare(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateResourceSharePermissionResult> disassociateResourceSharePermissionAsync(DisassociateResourceSharePermissionRequest request) {
        return this.disassociateResourceSharePermissionAsync(request, null);
    }

    @Override
    public Future<DisassociateResourceSharePermissionResult> disassociateResourceSharePermissionAsync(DisassociateResourceSharePermissionRequest request, final AsyncHandler<DisassociateResourceSharePermissionRequest, DisassociateResourceSharePermissionResult> asyncHandler) {
        final DisassociateResourceSharePermissionRequest finalRequest = (DisassociateResourceSharePermissionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateResourceSharePermissionResult>(){

            @Override
            public DisassociateResourceSharePermissionResult call() throws Exception {
                DisassociateResourceSharePermissionResult result = null;
                try {
                    result = AWSRAMAsyncClient.this.executeDisassociateResourceSharePermission(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableSharingWithAwsOrganizationResult> enableSharingWithAwsOrganizationAsync(EnableSharingWithAwsOrganizationRequest request) {
        return this.enableSharingWithAwsOrganizationAsync(request, null);
    }

    @Override
    public Future<EnableSharingWithAwsOrganizationResult> enableSharingWithAwsOrganizationAsync(EnableSharingWithAwsOrganizationRequest request, final AsyncHandler<EnableSharingWithAwsOrganizationRequest, EnableSharingWithAwsOrganizationResult> asyncHandler) {
        final EnableSharingWithAwsOrganizationRequest finalRequest = (EnableSharingWithAwsOrganizationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EnableSharingWithAwsOrganizationResult>(){

            @Override
            public EnableSharingWithAwsOrganizationResult call() throws Exception {
                EnableSharingWithAwsOrganizationResult result = null;
                try {
                    result = AWSRAMAsyncClient.this.executeEnableSharingWithAwsOrganization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPermissionResult> getPermissionAsync(GetPermissionRequest request) {
        return this.getPermissionAsync(request, null);
    }

    @Override
    public Future<GetPermissionResult> getPermissionAsync(GetPermissionRequest request, final AsyncHandler<GetPermissionRequest, GetPermissionResult> asyncHandler) {
        final GetPermissionRequest finalRequest = (GetPermissionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPermissionResult>(){

            @Override
            public GetPermissionResult call() throws Exception {
                GetPermissionResult result = null;
                try {
                    result = AWSRAMAsyncClient.this.executeGetPermission(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetResourcePoliciesResult> getResourcePoliciesAsync(GetResourcePoliciesRequest request) {
        return this.getResourcePoliciesAsync(request, null);
    }

    @Override
    public Future<GetResourcePoliciesResult> getResourcePoliciesAsync(GetResourcePoliciesRequest request, final AsyncHandler<GetResourcePoliciesRequest, GetResourcePoliciesResult> asyncHandler) {
        final GetResourcePoliciesRequest finalRequest = (GetResourcePoliciesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetResourcePoliciesResult>(){

            @Override
            public GetResourcePoliciesResult call() throws Exception {
                GetResourcePoliciesResult result = null;
                try {
                    result = AWSRAMAsyncClient.this.executeGetResourcePolicies(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetResourceShareAssociationsResult> getResourceShareAssociationsAsync(GetResourceShareAssociationsRequest request) {
        return this.getResourceShareAssociationsAsync(request, null);
    }

    @Override
    public Future<GetResourceShareAssociationsResult> getResourceShareAssociationsAsync(GetResourceShareAssociationsRequest request, final AsyncHandler<GetResourceShareAssociationsRequest, GetResourceShareAssociationsResult> asyncHandler) {
        final GetResourceShareAssociationsRequest finalRequest = (GetResourceShareAssociationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetResourceShareAssociationsResult>(){

            @Override
            public GetResourceShareAssociationsResult call() throws Exception {
                GetResourceShareAssociationsResult result = null;
                try {
                    result = AWSRAMAsyncClient.this.executeGetResourceShareAssociations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetResourceShareInvitationsResult> getResourceShareInvitationsAsync(GetResourceShareInvitationsRequest request) {
        return this.getResourceShareInvitationsAsync(request, null);
    }

    @Override
    public Future<GetResourceShareInvitationsResult> getResourceShareInvitationsAsync(GetResourceShareInvitationsRequest request, final AsyncHandler<GetResourceShareInvitationsRequest, GetResourceShareInvitationsResult> asyncHandler) {
        final GetResourceShareInvitationsRequest finalRequest = (GetResourceShareInvitationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetResourceShareInvitationsResult>(){

            @Override
            public GetResourceShareInvitationsResult call() throws Exception {
                GetResourceShareInvitationsResult result = null;
                try {
                    result = AWSRAMAsyncClient.this.executeGetResourceShareInvitations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetResourceSharesResult> getResourceSharesAsync(GetResourceSharesRequest request) {
        return this.getResourceSharesAsync(request, null);
    }

    @Override
    public Future<GetResourceSharesResult> getResourceSharesAsync(GetResourceSharesRequest request, final AsyncHandler<GetResourceSharesRequest, GetResourceSharesResult> asyncHandler) {
        final GetResourceSharesRequest finalRequest = (GetResourceSharesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetResourceSharesResult>(){

            @Override
            public GetResourceSharesResult call() throws Exception {
                GetResourceSharesResult result = null;
                try {
                    result = AWSRAMAsyncClient.this.executeGetResourceShares(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPendingInvitationResourcesResult> listPendingInvitationResourcesAsync(ListPendingInvitationResourcesRequest request) {
        return this.listPendingInvitationResourcesAsync(request, null);
    }

    @Override
    public Future<ListPendingInvitationResourcesResult> listPendingInvitationResourcesAsync(ListPendingInvitationResourcesRequest request, final AsyncHandler<ListPendingInvitationResourcesRequest, ListPendingInvitationResourcesResult> asyncHandler) {
        final ListPendingInvitationResourcesRequest finalRequest = (ListPendingInvitationResourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPendingInvitationResourcesResult>(){

            @Override
            public ListPendingInvitationResourcesResult call() throws Exception {
                ListPendingInvitationResourcesResult result = null;
                try {
                    result = AWSRAMAsyncClient.this.executeListPendingInvitationResources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPermissionsResult> listPermissionsAsync(ListPermissionsRequest request) {
        return this.listPermissionsAsync(request, null);
    }

    @Override
    public Future<ListPermissionsResult> listPermissionsAsync(ListPermissionsRequest request, final AsyncHandler<ListPermissionsRequest, ListPermissionsResult> asyncHandler) {
        final ListPermissionsRequest finalRequest = (ListPermissionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPermissionsResult>(){

            @Override
            public ListPermissionsResult call() throws Exception {
                ListPermissionsResult result = null;
                try {
                    result = AWSRAMAsyncClient.this.executeListPermissions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPrincipalsResult> listPrincipalsAsync(ListPrincipalsRequest request) {
        return this.listPrincipalsAsync(request, null);
    }

    @Override
    public Future<ListPrincipalsResult> listPrincipalsAsync(ListPrincipalsRequest request, final AsyncHandler<ListPrincipalsRequest, ListPrincipalsResult> asyncHandler) {
        final ListPrincipalsRequest finalRequest = (ListPrincipalsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPrincipalsResult>(){

            @Override
            public ListPrincipalsResult call() throws Exception {
                ListPrincipalsResult result = null;
                try {
                    result = AWSRAMAsyncClient.this.executeListPrincipals(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListResourceSharePermissionsResult> listResourceSharePermissionsAsync(ListResourceSharePermissionsRequest request) {
        return this.listResourceSharePermissionsAsync(request, null);
    }

    @Override
    public Future<ListResourceSharePermissionsResult> listResourceSharePermissionsAsync(ListResourceSharePermissionsRequest request, final AsyncHandler<ListResourceSharePermissionsRequest, ListResourceSharePermissionsResult> asyncHandler) {
        final ListResourceSharePermissionsRequest finalRequest = (ListResourceSharePermissionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListResourceSharePermissionsResult>(){

            @Override
            public ListResourceSharePermissionsResult call() throws Exception {
                ListResourceSharePermissionsResult result = null;
                try {
                    result = AWSRAMAsyncClient.this.executeListResourceSharePermissions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListResourcesResult> listResourcesAsync(ListResourcesRequest request) {
        return this.listResourcesAsync(request, null);
    }

    @Override
    public Future<ListResourcesResult> listResourcesAsync(ListResourcesRequest request, final AsyncHandler<ListResourcesRequest, ListResourcesResult> asyncHandler) {
        final ListResourcesRequest finalRequest = (ListResourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListResourcesResult>(){

            @Override
            public ListResourcesResult call() throws Exception {
                ListResourcesResult result = null;
                try {
                    result = AWSRAMAsyncClient.this.executeListResources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PromoteResourceShareCreatedFromPolicyResult> promoteResourceShareCreatedFromPolicyAsync(PromoteResourceShareCreatedFromPolicyRequest request) {
        return this.promoteResourceShareCreatedFromPolicyAsync(request, null);
    }

    @Override
    public Future<PromoteResourceShareCreatedFromPolicyResult> promoteResourceShareCreatedFromPolicyAsync(PromoteResourceShareCreatedFromPolicyRequest request, final AsyncHandler<PromoteResourceShareCreatedFromPolicyRequest, PromoteResourceShareCreatedFromPolicyResult> asyncHandler) {
        final PromoteResourceShareCreatedFromPolicyRequest finalRequest = (PromoteResourceShareCreatedFromPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PromoteResourceShareCreatedFromPolicyResult>(){

            @Override
            public PromoteResourceShareCreatedFromPolicyResult call() throws Exception {
                PromoteResourceShareCreatedFromPolicyResult result = null;
                try {
                    result = AWSRAMAsyncClient.this.executePromoteResourceShareCreatedFromPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RejectResourceShareInvitationResult> rejectResourceShareInvitationAsync(RejectResourceShareInvitationRequest request) {
        return this.rejectResourceShareInvitationAsync(request, null);
    }

    @Override
    public Future<RejectResourceShareInvitationResult> rejectResourceShareInvitationAsync(RejectResourceShareInvitationRequest request, final AsyncHandler<RejectResourceShareInvitationRequest, RejectResourceShareInvitationResult> asyncHandler) {
        final RejectResourceShareInvitationRequest finalRequest = (RejectResourceShareInvitationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RejectResourceShareInvitationResult>(){

            @Override
            public RejectResourceShareInvitationResult call() throws Exception {
                RejectResourceShareInvitationResult result = null;
                try {
                    result = AWSRAMAsyncClient.this.executeRejectResourceShareInvitation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSRAMAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSRAMAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateResourceShareResult> updateResourceShareAsync(UpdateResourceShareRequest request) {
        return this.updateResourceShareAsync(request, null);
    }

    @Override
    public Future<UpdateResourceShareResult> updateResourceShareAsync(UpdateResourceShareRequest request, final AsyncHandler<UpdateResourceShareRequest, UpdateResourceShareResult> asyncHandler) {
        final UpdateResourceShareRequest finalRequest = (UpdateResourceShareRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateResourceShareResult>(){

            @Override
            public UpdateResourceShareResult call() throws Exception {
                UpdateResourceShareResult result = null;
                try {
                    result = AWSRAMAsyncClient.this.executeUpdateResourceShare(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

