/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.AggType;
import com.amazonaws.services.quicksight.model.AggregationPartitionBy;
import com.amazonaws.services.quicksight.model.Anchor;
import com.amazonaws.services.quicksight.model.FilterAggMetrics;
import com.amazonaws.services.quicksight.model.FilterClass;
import com.amazonaws.services.quicksight.model.Identifier;
import com.amazonaws.services.quicksight.model.NullFilterOption;
import com.amazonaws.services.quicksight.model.TimeGranularity;
import com.amazonaws.services.quicksight.model.TopicConstantValue;
import com.amazonaws.services.quicksight.model.TopicIRFilterFunction;
import com.amazonaws.services.quicksight.model.TopicIRFilterType;
import com.amazonaws.services.quicksight.model.TopicSortDirection;
import com.amazonaws.services.quicksight.model.transform.TopicIRFilterOptionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TopicIRFilterOption
implements Serializable,
Cloneable,
StructuredPojo {
    private String filterType;
    private String filterClass;
    private Identifier operandField;
    private String function;
    private TopicConstantValue constant;
    private Boolean inverse;
    private String nullFilter;
    private String aggregation;
    private Map<String, String> aggregationFunctionParameters;
    private List<AggregationPartitionBy> aggregationPartitionBy;
    private TopicConstantValue range;
    private Boolean inclusive;
    private String timeGranularity;
    private TopicConstantValue lastNextOffset;
    private List<FilterAggMetrics> aggMetrics;
    private TopicConstantValue topBottomLimit;
    private String sortDirection;
    private Anchor anchor;

    public void setFilterType(String filterType) {
        this.filterType = filterType;
    }

    public String getFilterType() {
        return this.filterType;
    }

    public TopicIRFilterOption withFilterType(String filterType) {
        this.setFilterType(filterType);
        return this;
    }

    public TopicIRFilterOption withFilterType(TopicIRFilterType filterType) {
        this.filterType = filterType.toString();
        return this;
    }

    public void setFilterClass(String filterClass) {
        this.filterClass = filterClass;
    }

    public String getFilterClass() {
        return this.filterClass;
    }

    public TopicIRFilterOption withFilterClass(String filterClass) {
        this.setFilterClass(filterClass);
        return this;
    }

    public TopicIRFilterOption withFilterClass(FilterClass filterClass) {
        this.filterClass = filterClass.toString();
        return this;
    }

    public void setOperandField(Identifier operandField) {
        this.operandField = operandField;
    }

    public Identifier getOperandField() {
        return this.operandField;
    }

    public TopicIRFilterOption withOperandField(Identifier operandField) {
        this.setOperandField(operandField);
        return this;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public String getFunction() {
        return this.function;
    }

    public TopicIRFilterOption withFunction(String function) {
        this.setFunction(function);
        return this;
    }

    public TopicIRFilterOption withFunction(TopicIRFilterFunction function) {
        this.function = function.toString();
        return this;
    }

    public void setConstant(TopicConstantValue constant) {
        this.constant = constant;
    }

    public TopicConstantValue getConstant() {
        return this.constant;
    }

    public TopicIRFilterOption withConstant(TopicConstantValue constant) {
        this.setConstant(constant);
        return this;
    }

    public void setInverse(Boolean inverse) {
        this.inverse = inverse;
    }

    public Boolean getInverse() {
        return this.inverse;
    }

    public TopicIRFilterOption withInverse(Boolean inverse) {
        this.setInverse(inverse);
        return this;
    }

    public Boolean isInverse() {
        return this.inverse;
    }

    public void setNullFilter(String nullFilter) {
        this.nullFilter = nullFilter;
    }

    public String getNullFilter() {
        return this.nullFilter;
    }

    public TopicIRFilterOption withNullFilter(String nullFilter) {
        this.setNullFilter(nullFilter);
        return this;
    }

    public TopicIRFilterOption withNullFilter(NullFilterOption nullFilter) {
        this.nullFilter = nullFilter.toString();
        return this;
    }

    public void setAggregation(String aggregation) {
        this.aggregation = aggregation;
    }

    public String getAggregation() {
        return this.aggregation;
    }

    public TopicIRFilterOption withAggregation(String aggregation) {
        this.setAggregation(aggregation);
        return this;
    }

    public TopicIRFilterOption withAggregation(AggType aggregation) {
        this.aggregation = aggregation.toString();
        return this;
    }

    public Map<String, String> getAggregationFunctionParameters() {
        return this.aggregationFunctionParameters;
    }

    public void setAggregationFunctionParameters(Map<String, String> aggregationFunctionParameters) {
        this.aggregationFunctionParameters = aggregationFunctionParameters;
    }

    public TopicIRFilterOption withAggregationFunctionParameters(Map<String, String> aggregationFunctionParameters) {
        this.setAggregationFunctionParameters(aggregationFunctionParameters);
        return this;
    }

    public TopicIRFilterOption addAggregationFunctionParametersEntry(String key, String value) {
        if (null == this.aggregationFunctionParameters) {
            this.aggregationFunctionParameters = new HashMap<String, String>();
        }
        if (this.aggregationFunctionParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.aggregationFunctionParameters.put(key, value);
        return this;
    }

    public TopicIRFilterOption clearAggregationFunctionParametersEntries() {
        this.aggregationFunctionParameters = null;
        return this;
    }

    public List<AggregationPartitionBy> getAggregationPartitionBy() {
        return this.aggregationPartitionBy;
    }

    public void setAggregationPartitionBy(Collection<AggregationPartitionBy> aggregationPartitionBy) {
        if (aggregationPartitionBy == null) {
            this.aggregationPartitionBy = null;
            return;
        }
        this.aggregationPartitionBy = new ArrayList<AggregationPartitionBy>(aggregationPartitionBy);
    }

    public TopicIRFilterOption withAggregationPartitionBy(AggregationPartitionBy ... aggregationPartitionBy) {
        if (this.aggregationPartitionBy == null) {
            this.setAggregationPartitionBy(new ArrayList<AggregationPartitionBy>(aggregationPartitionBy.length));
        }
        for (AggregationPartitionBy ele : aggregationPartitionBy) {
            this.aggregationPartitionBy.add(ele);
        }
        return this;
    }

    public TopicIRFilterOption withAggregationPartitionBy(Collection<AggregationPartitionBy> aggregationPartitionBy) {
        this.setAggregationPartitionBy(aggregationPartitionBy);
        return this;
    }

    public void setRange(TopicConstantValue range) {
        this.range = range;
    }

    public TopicConstantValue getRange() {
        return this.range;
    }

    public TopicIRFilterOption withRange(TopicConstantValue range) {
        this.setRange(range);
        return this;
    }

    public void setInclusive(Boolean inclusive) {
        this.inclusive = inclusive;
    }

    public Boolean getInclusive() {
        return this.inclusive;
    }

    public TopicIRFilterOption withInclusive(Boolean inclusive) {
        this.setInclusive(inclusive);
        return this;
    }

    public Boolean isInclusive() {
        return this.inclusive;
    }

    public void setTimeGranularity(String timeGranularity) {
        this.timeGranularity = timeGranularity;
    }

    public String getTimeGranularity() {
        return this.timeGranularity;
    }

    public TopicIRFilterOption withTimeGranularity(String timeGranularity) {
        this.setTimeGranularity(timeGranularity);
        return this;
    }

    public TopicIRFilterOption withTimeGranularity(TimeGranularity timeGranularity) {
        this.timeGranularity = timeGranularity.toString();
        return this;
    }

    public void setLastNextOffset(TopicConstantValue lastNextOffset) {
        this.lastNextOffset = lastNextOffset;
    }

    public TopicConstantValue getLastNextOffset() {
        return this.lastNextOffset;
    }

    public TopicIRFilterOption withLastNextOffset(TopicConstantValue lastNextOffset) {
        this.setLastNextOffset(lastNextOffset);
        return this;
    }

    public List<FilterAggMetrics> getAggMetrics() {
        return this.aggMetrics;
    }

    public void setAggMetrics(Collection<FilterAggMetrics> aggMetrics) {
        if (aggMetrics == null) {
            this.aggMetrics = null;
            return;
        }
        this.aggMetrics = new ArrayList<FilterAggMetrics>(aggMetrics);
    }

    public TopicIRFilterOption withAggMetrics(FilterAggMetrics ... aggMetrics) {
        if (this.aggMetrics == null) {
            this.setAggMetrics(new ArrayList<FilterAggMetrics>(aggMetrics.length));
        }
        for (FilterAggMetrics ele : aggMetrics) {
            this.aggMetrics.add(ele);
        }
        return this;
    }

    public TopicIRFilterOption withAggMetrics(Collection<FilterAggMetrics> aggMetrics) {
        this.setAggMetrics(aggMetrics);
        return this;
    }

    public void setTopBottomLimit(TopicConstantValue topBottomLimit) {
        this.topBottomLimit = topBottomLimit;
    }

    public TopicConstantValue getTopBottomLimit() {
        return this.topBottomLimit;
    }

    public TopicIRFilterOption withTopBottomLimit(TopicConstantValue topBottomLimit) {
        this.setTopBottomLimit(topBottomLimit);
        return this;
    }

    public void setSortDirection(String sortDirection) {
        this.sortDirection = sortDirection;
    }

    public String getSortDirection() {
        return this.sortDirection;
    }

    public TopicIRFilterOption withSortDirection(String sortDirection) {
        this.setSortDirection(sortDirection);
        return this;
    }

    public TopicIRFilterOption withSortDirection(TopicSortDirection sortDirection) {
        this.sortDirection = sortDirection.toString();
        return this;
    }

    public void setAnchor(Anchor anchor) {
        this.anchor = anchor;
    }

    public Anchor getAnchor() {
        return this.anchor;
    }

    public TopicIRFilterOption withAnchor(Anchor anchor) {
        this.setAnchor(anchor);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilterType() != null) {
            sb.append("FilterType: ").append(this.getFilterType()).append(",");
        }
        if (this.getFilterClass() != null) {
            sb.append("FilterClass: ").append(this.getFilterClass()).append(",");
        }
        if (this.getOperandField() != null) {
            sb.append("OperandField: ").append(this.getOperandField()).append(",");
        }
        if (this.getFunction() != null) {
            sb.append("Function: ").append(this.getFunction()).append(",");
        }
        if (this.getConstant() != null) {
            sb.append("Constant: ").append(this.getConstant()).append(",");
        }
        if (this.getInverse() != null) {
            sb.append("Inverse: ").append(this.getInverse()).append(",");
        }
        if (this.getNullFilter() != null) {
            sb.append("NullFilter: ").append(this.getNullFilter()).append(",");
        }
        if (this.getAggregation() != null) {
            sb.append("Aggregation: ").append(this.getAggregation()).append(",");
        }
        if (this.getAggregationFunctionParameters() != null) {
            sb.append("AggregationFunctionParameters: ").append(this.getAggregationFunctionParameters()).append(",");
        }
        if (this.getAggregationPartitionBy() != null) {
            sb.append("AggregationPartitionBy: ").append(this.getAggregationPartitionBy()).append(",");
        }
        if (this.getRange() != null) {
            sb.append("Range: ").append(this.getRange()).append(",");
        }
        if (this.getInclusive() != null) {
            sb.append("Inclusive: ").append(this.getInclusive()).append(",");
        }
        if (this.getTimeGranularity() != null) {
            sb.append("TimeGranularity: ").append(this.getTimeGranularity()).append(",");
        }
        if (this.getLastNextOffset() != null) {
            sb.append("LastNextOffset: ").append(this.getLastNextOffset()).append(",");
        }
        if (this.getAggMetrics() != null) {
            sb.append("AggMetrics: ").append(this.getAggMetrics()).append(",");
        }
        if (this.getTopBottomLimit() != null) {
            sb.append("TopBottomLimit: ").append(this.getTopBottomLimit()).append(",");
        }
        if (this.getSortDirection() != null) {
            sb.append("SortDirection: ").append(this.getSortDirection()).append(",");
        }
        if (this.getAnchor() != null) {
            sb.append("Anchor: ").append(this.getAnchor());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicIRFilterOption)) {
            return false;
        }
        TopicIRFilterOption other = (TopicIRFilterOption)obj;
        if (other.getFilterType() == null ^ this.getFilterType() == null) {
            return false;
        }
        if (other.getFilterType() != null && !other.getFilterType().equals(this.getFilterType())) {
            return false;
        }
        if (other.getFilterClass() == null ^ this.getFilterClass() == null) {
            return false;
        }
        if (other.getFilterClass() != null && !other.getFilterClass().equals(this.getFilterClass())) {
            return false;
        }
        if (other.getOperandField() == null ^ this.getOperandField() == null) {
            return false;
        }
        if (other.getOperandField() != null && !other.getOperandField().equals(this.getOperandField())) {
            return false;
        }
        if (other.getFunction() == null ^ this.getFunction() == null) {
            return false;
        }
        if (other.getFunction() != null && !other.getFunction().equals(this.getFunction())) {
            return false;
        }
        if (other.getConstant() == null ^ this.getConstant() == null) {
            return false;
        }
        if (other.getConstant() != null && !other.getConstant().equals(this.getConstant())) {
            return false;
        }
        if (other.getInverse() == null ^ this.getInverse() == null) {
            return false;
        }
        if (other.getInverse() != null && !other.getInverse().equals(this.getInverse())) {
            return false;
        }
        if (other.getNullFilter() == null ^ this.getNullFilter() == null) {
            return false;
        }
        if (other.getNullFilter() != null && !other.getNullFilter().equals(this.getNullFilter())) {
            return false;
        }
        if (other.getAggregation() == null ^ this.getAggregation() == null) {
            return false;
        }
        if (other.getAggregation() != null && !other.getAggregation().equals(this.getAggregation())) {
            return false;
        }
        if (other.getAggregationFunctionParameters() == null ^ this.getAggregationFunctionParameters() == null) {
            return false;
        }
        if (other.getAggregationFunctionParameters() != null && !other.getAggregationFunctionParameters().equals(this.getAggregationFunctionParameters())) {
            return false;
        }
        if (other.getAggregationPartitionBy() == null ^ this.getAggregationPartitionBy() == null) {
            return false;
        }
        if (other.getAggregationPartitionBy() != null && !other.getAggregationPartitionBy().equals(this.getAggregationPartitionBy())) {
            return false;
        }
        if (other.getRange() == null ^ this.getRange() == null) {
            return false;
        }
        if (other.getRange() != null && !other.getRange().equals(this.getRange())) {
            return false;
        }
        if (other.getInclusive() == null ^ this.getInclusive() == null) {
            return false;
        }
        if (other.getInclusive() != null && !other.getInclusive().equals(this.getInclusive())) {
            return false;
        }
        if (other.getTimeGranularity() == null ^ this.getTimeGranularity() == null) {
            return false;
        }
        if (other.getTimeGranularity() != null && !other.getTimeGranularity().equals(this.getTimeGranularity())) {
            return false;
        }
        if (other.getLastNextOffset() == null ^ this.getLastNextOffset() == null) {
            return false;
        }
        if (other.getLastNextOffset() != null && !other.getLastNextOffset().equals(this.getLastNextOffset())) {
            return false;
        }
        if (other.getAggMetrics() == null ^ this.getAggMetrics() == null) {
            return false;
        }
        if (other.getAggMetrics() != null && !other.getAggMetrics().equals(this.getAggMetrics())) {
            return false;
        }
        if (other.getTopBottomLimit() == null ^ this.getTopBottomLimit() == null) {
            return false;
        }
        if (other.getTopBottomLimit() != null && !other.getTopBottomLimit().equals(this.getTopBottomLimit())) {
            return false;
        }
        if (other.getSortDirection() == null ^ this.getSortDirection() == null) {
            return false;
        }
        if (other.getSortDirection() != null && !other.getSortDirection().equals(this.getSortDirection())) {
            return false;
        }
        if (other.getAnchor() == null ^ this.getAnchor() == null) {
            return false;
        }
        return other.getAnchor() == null || other.getAnchor().equals(this.getAnchor());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilterType() == null ? 0 : this.getFilterType().hashCode());
        hashCode = 31 * hashCode + (this.getFilterClass() == null ? 0 : this.getFilterClass().hashCode());
        hashCode = 31 * hashCode + (this.getOperandField() == null ? 0 : this.getOperandField().hashCode());
        hashCode = 31 * hashCode + (this.getFunction() == null ? 0 : this.getFunction().hashCode());
        hashCode = 31 * hashCode + (this.getConstant() == null ? 0 : this.getConstant().hashCode());
        hashCode = 31 * hashCode + (this.getInverse() == null ? 0 : this.getInverse().hashCode());
        hashCode = 31 * hashCode + (this.getNullFilter() == null ? 0 : this.getNullFilter().hashCode());
        hashCode = 31 * hashCode + (this.getAggregation() == null ? 0 : this.getAggregation().hashCode());
        hashCode = 31 * hashCode + (this.getAggregationFunctionParameters() == null ? 0 : this.getAggregationFunctionParameters().hashCode());
        hashCode = 31 * hashCode + (this.getAggregationPartitionBy() == null ? 0 : this.getAggregationPartitionBy().hashCode());
        hashCode = 31 * hashCode + (this.getRange() == null ? 0 : this.getRange().hashCode());
        hashCode = 31 * hashCode + (this.getInclusive() == null ? 0 : this.getInclusive().hashCode());
        hashCode = 31 * hashCode + (this.getTimeGranularity() == null ? 0 : this.getTimeGranularity().hashCode());
        hashCode = 31 * hashCode + (this.getLastNextOffset() == null ? 0 : this.getLastNextOffset().hashCode());
        hashCode = 31 * hashCode + (this.getAggMetrics() == null ? 0 : this.getAggMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getTopBottomLimit() == null ? 0 : this.getTopBottomLimit().hashCode());
        hashCode = 31 * hashCode + (this.getSortDirection() == null ? 0 : this.getSortDirection().hashCode());
        hashCode = 31 * hashCode + (this.getAnchor() == null ? 0 : this.getAnchor().hashCode());
        return hashCode;
    }

    public TopicIRFilterOption clone() {
        try {
            return (TopicIRFilterOption)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TopicIRFilterOptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

